/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.workbench.models.guided.dtable.backend.GuidedDTXMLPersistence;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzer;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil.AnalyzerProvider;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.data.Coordinate;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.events.DeleteRowEvent;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerFromFileTest {
    @GwtMock
    AnalysisConstants analysisConstants;
    @GwtMock
    DateTimeFormat dateTimeFormat;
    private AnalyzerProvider analyzerProvider;

    @Before
    public void setUp() throws Exception {
        this.analyzerProvider = new AnalyzerProvider();
    }

    @Test
    public void testFile1() throws Exception {
        String xml = TestUtil.loadResource("Pricing loans.gdst");
        GuidedDecisionTable52 table52 = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        DecisionTableAnalyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.analyze(Collections.emptyList());
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), "MissingRangeTitle");
    }

    @Test
    public void testFile2() throws Exception {
        String xml = TestUtil.loadResource("Large file.gdst");
        DecisionTableAnalyzer analyzer = this.analyzerProvider.makeAnalyser(GuidedDTXMLPersistence.getInstance().unmarshal(xml));
        analyzer.analyze(Collections.emptyList());
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), "SingleHitLost");
    }

    @Test
    public void testFile3() throws Exception {
        String xml = TestUtil.loadResource("Pricing loans version 2.gdst");
        GuidedDecisionTable52 table52 = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        DecisionTableAnalyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.analyze(Collections.emptyList());
        TestUtil.assertDoesNotContain("ThisRowIsRedundantTo", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testFile4() throws Exception {
        Mockito.when((Object)this.analyzerProvider.getOracle().getFieldType("Player", "score")).thenReturn((Object)"Integer");
        String xml = TestUtil.loadResource("Score Achievements.gdst");
        DecisionTableAnalyzer analyzer = this.analyzerProvider.makeAnalyser(GuidedDTXMLPersistence.getInstance().unmarshal(xml));
        analyzer.analyze(Collections.emptyList());
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), "MissingRangeTitle", "SingleHitLost");
    }

    @Test
    public void testFile5() throws Exception {
        String xml = TestUtil.loadResource("Base entitlement.gdst");
        DecisionTableAnalyzer analyzer = this.analyzerProvider.makeAnalyser(GuidedDTXMLPersistence.getInstance().unmarshal(xml));
        analyzer.analyze(Collections.emptyList());
        Assert.assertTrue((boolean)this.analyzerProvider.getAnalysisReport().getAnalysisData().isEmpty());
    }

    @Test
    public void testFile2WithUpdate() throws Exception {
        long baseline = System.currentTimeMillis();
        String xml = TestUtil.loadResource("Large file.gdst");
        GuidedDecisionTable52 table52 = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        long now = System.currentTimeMillis();
        System.out.println("Loading of model took.. " + (now - baseline) + " ms");
        baseline = now;
        DecisionTableAnalyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        now = System.currentTimeMillis();
        System.out.println("Indexing took.. " + (now - baseline) + " ms");
        analyzer.analyze(Collections.emptyList());
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), "SingleHitLost");
        now = System.currentTimeMillis();
        System.out.println("Initial analysis took.. " + (now - baseline) + " ms");
        baseline = now;
        ((DTCellValue52)((List)table52.getData().get(2)).get(6)).clearValues();
        ArrayList<Coordinate> updates = new ArrayList<Coordinate>();
        updates.add(new Coordinate(2, 6));
        analyzer.analyze(updates);
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), "SingleHitLost");
        now = System.currentTimeMillis();
        System.out.println("Partial analysis took.. " + (now - baseline) + " ms");
    }

    @Test
    public void testFile2WithDeletes() throws Exception {
        String xml = TestUtil.loadResource("Large file.gdst");
        GuidedDecisionTable52 table52 = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        DecisionTableAnalyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.analyze(Collections.emptyList());
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), "SingleHitLost");
        long baseline = System.currentTimeMillis();
        for (int iterations = 0; iterations < 10; ++iterations) {
            DeleteRowEvent event = new DeleteRowEvent(100);
            analyzer.deleteRow(event.getIndex());
            table52.getData().remove(100);
            analyzer.updateColumns(0);
            long now = System.currentTimeMillis();
            System.out.println("Partial analysis took.. " + (now - baseline) + " ms");
            baseline = now;
            TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), "SingleHitLost");
        }
    }
}

