/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import com.google.gwt.event.shared.EventBus;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzerProvider;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.controller.AnalyzerControllerImpl;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReportScreen;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerProviderTest {
    @Mock
    private AnalysisReportScreen analysisReportScreen;

    @Test
    public void defaultAnalyserSetting() throws Exception {
        ApplicationPreferences.setUp(Collections.emptyMap());
        Assert.assertTrue((boolean)(new DecisionTableAnalyzerProvider(this.analysisReportScreen).newAnalyzer((PlaceRequest)Mockito.mock(PlaceRequest.class), (AsyncPackageDataModelOracle)Mockito.mock(AsyncPackageDataModelOracle.class), (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class), (EventBus)Mockito.mock(EventBus.class)) instanceof AnalyzerControllerImpl));
    }

    @Test
    public void verificationDisabledWithSetting() throws Exception {
        HashMap<String, String> preferences = new HashMap<String, String>(){
            {
                this.put("org.kie.verification.disable-dtable-realtime-verification", "true");
            }
        };
        ApplicationPreferences.setUp((Map)preferences);
        Assert.assertFalse((boolean)(new DecisionTableAnalyzerProvider(this.analysisReportScreen).newAnalyzer((PlaceRequest)Mockito.mock(PlaceRequest.class), (AsyncPackageDataModelOracle)Mockito.mock(AsyncPackageDataModelOracle.class), (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class), (EventBus)Mockito.mock(EventBus.class)) instanceof AnalyzerControllerImpl));
    }

    @Test
    public void verificationEnabledWithSetting() throws Exception {
        HashMap<String, String> preferences = new HashMap<String, String>(){
            {
                this.put("org.kie.verification.disable-dtable-realtime-verification", "false");
            }
        };
        ApplicationPreferences.setUp((Map)preferences);
        Assert.assertTrue((boolean)(new DecisionTableAnalyzerProvider(this.analysisReportScreen).newAnalyzer((PlaceRequest)Mockito.mock(PlaceRequest.class), (AsyncPackageDataModelOracle)Mockito.mock(AsyncPackageDataModelOracle.class), (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class), (EventBus)Mockito.mock(EventBus.class)) instanceof AnalyzerControllerImpl));
    }
}

