/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.AnalyzerUpdateTestBase;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DataBuilderProvider;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil.TestUtil;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerRangeCheckTest
extends AnalyzerUpdateTestBase {
    @Test
    public void testMissingRangeNoIssueNameHasNoRange() throws Exception {
        this.analyzer = this.analyzerProvider.makeAnalyser().withPersonNameColumn("==").withApplicationApprovedSetField().withData(DataBuilderProvider.row((Object[])new Object[]{"Toni", true}).row(new Object[]{"Michael", true}).end()).buildAnalyzer();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain("MissingRangeTitle", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testMissingRangeNoIssue() throws Exception {
        this.analyzer = this.analyzerProvider.makeAnalyser().withPersonApprovedColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row((Object[])new Object[]{true, true}).row(new Object[]{false, true}).end()).buildAnalyzer();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain("MissingRangeTitle", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testMissingRangeMissingNotApprovedFromLHS() throws Exception {
        this.analyzer = this.analyzerProvider.makeAnalyser().withPersonApprovedColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row((Object[])new Object[]{true, true}).row(new Object[]{true, false}).end()).buildAnalyzer();
        this.fireUpAnalyzer();
        TestUtil.assertContains("MissingRangeTitle", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testMissingAgeBetween1And100() throws Exception {
        this.analyzer = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("<").withPersonAgeColumn(">=").withPersonApprovedActionSetField().withData(DataBuilderProvider.row((Object[])new Object[]{0, null, true}).row(new Object[]{null, 100, false}).end()).buildAnalyzer();
        this.fireUpAnalyzer();
        TestUtil.assertContains("MissingRangeTitle", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testCompleteAgeRange() throws Exception {
        this.analyzer = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("<").withPersonAgeColumn(">=").withPersonApprovedActionSetField().withData(DataBuilderProvider.row((Object[])new Object[]{0, null, true}).row(new Object[]{null, 0, true}).end()).buildAnalyzer();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain("MissingRangeTitle", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testMissingDepositBetween0And12345() throws Exception {
        this.analyzer = this.analyzerProvider.makeAnalyser().withAccountDepositColumn("<").withAccountDepositColumn(">").withPersonApprovedActionSetField().withData(DataBuilderProvider.row((Object[])new Object[]{0.0, null, true}).row(new Object[]{null, 12345.0, true}).end()).buildAnalyzer();
        this.fireUpAnalyzer();
        TestUtil.assertContains("MissingRangeTitle", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testCompleteAccountRange() throws Exception {
        this.analyzer = this.analyzerProvider.makeAnalyser().withAccountDepositColumn(">=").withAccountDepositColumn("<").withPersonApprovedActionSetField().withData(DataBuilderProvider.row((Object[])new Object[]{0.0, null, true}).row(new Object[]{null, 0.0, true}).end()).buildAnalyzer();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain("MissingRangeTitle", this.analyzerProvider.getAnalysisReport());
    }
}

