/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.AnalyzerUpdateTestBase;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil.ExtendedGuidedDecisionTableBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil.TestUtil;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerSubsumptionTest
extends AnalyzerUpdateTestBase {
    @Test
    public void testSubsumptionBooleanDifferentValueDifferentOperator() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionBooleanColumn("a", "Person", "approved", "==").withConditionBooleanColumn("a", "Person", "approved", "!=").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", true, null, true}, {2, "description", null, false, true}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains("RedundantRows", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testSubsumptionBooleansWithSameValue() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionBooleanColumn("a", "Person", "approved", "==").withConditionBooleanColumn("a", "Person", "approved", "==").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", true, null, true}, {2, "description", null, true, true}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains("RedundantRows", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testBooleansAreNotRedundant() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionBooleanColumn("a", "Person", "approved", "==").withConditionBooleanColumn("a", "Person", "approved", "==").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", true, null, true}, {2, "description", null, false, true}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain("RedundantRows", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testBooleansAreNotRedundantDifferentOperator() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionBooleanColumn("a", "Person", "approved", "==").withConditionBooleanColumn("a", "Person", "approved", "!=").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", true, null, true}, {2, "description", null, true, true}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain("RedundantRows", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testSumbsumptantAgeRows() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withConditionIntegerColumn("a", "Person", "age", ">").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", 0, null, true}, {2, "description", null, 0, true}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains("RedundantRows", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testSumbsumptantAgeDifferentOperator() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withConditionIntegerColumn("a", "Person", "age", ">=").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", 0, null, true}, {2, "description", null, 1, true}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains("RedundantRows", this.analyzerProvider.getAnalysisReport());
    }
}

