/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.AnalyzerUpdateTestBase;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DataBuilderProvider;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil.ExtendedGuidedDecisionTableBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil.LimitedGuidedDecisionTableBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerTest
extends AnalyzerUpdateTestBase {
    @Test
    public void testEmpty() throws Exception {
        this.table52 = new GuidedDecisionTable52();
        this.fireUpAnalyzer();
        Assert.assertTrue((boolean)this.analyzerProvider.getAnalysisReport().getAnalysisData().isEmpty());
    }

    @Test
    public void testEmptyRow() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withData(new Object[][]{{1, "description", ""}}).buildTable();
        this.fireUpAnalyzer();
        Assert.assertTrue((boolean)this.analyzerProvider.getAnalysisReport().getAnalysisData().isEmpty());
    }

    @Test
    public void testRuleHasNoAction() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withData(new Object[][]{{1, "description", 0}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains("RuleHasNoAction", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void ruleHasNoActionShouldNotIgnoreRetract() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withRetract().withData(DataBuilderProvider.row((Object[])new Object[]{0, "a"}).end()).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain("RuleHasNoAction", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testRuleHasNoActionSet() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withActionSetField("a", "age", "Integer").withActionSetField("a", "approved", "Boolean").withActionSetField("a", "name", "String").withData(new Object[][]{{1, "description", 0, null, null, ""}, {2, "description", null, null, null, null}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains("RuleHasNoAction", this.analyzerProvider.getAnalysisReport(), 1);
        TestUtil.assertDoesNotContain("RuleHasNoAction", this.analyzerProvider.getAnalysisReport(), 2);
    }

    @Test
    public void testRuleHasNoRestrictions() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withActionInsertFact("Person", "a", "approved", "Boolean").withData(new Object[][]{{1, "description", true}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains("RuleHasNoRestrictionsAndWillAlwaysFire", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testRuleHasNoRestrictionsSet() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withStringColumn("a", "Person", "name", "==").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", null, "", true}, {2, "description", null, null, null}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains("RuleHasNoRestrictionsAndWillAlwaysFire", this.analyzerProvider.getAnalysisReport(), 1);
        TestUtil.assertDoesNotContain("RuleHasNoRestrictionsAndWillAlwaysFire", this.analyzerProvider.getAnalysisReport(), 2);
    }

    @Test
    public void testMultipleValuesForOneAction() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withActionSetField("a", "approved", "Boolean").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", 100, true, false}}).buildTable();
        this.analyzer = this.analyzerProvider.makeAnalyser(this.table52);
        this.analyzer.start();
        TestUtil.assertContains("MultipleValuesForOneAction", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testRedundancy() throws Exception {
        this.table52 = new LimitedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withIntegerColumn("a", "Person", "age", "==", 0).withAction("a", "Person", "approved", new DTCellValue52(){
            {
                this.setBooleanValue(true);
            }
        }).withAction("a", "Person", "approved", new DTCellValue52(){
            {
                this.setBooleanValue(true);
            }
        }).withData(new Object[][]{{1, "description", true, true, false}, {2, "description", true, false, true}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains("RedundantRows", this.analyzerProvider.getAnalysisReport(), 1);
        TestUtil.assertContains("RedundantRows", this.analyzerProvider.getAnalysisReport(), 2);
        Assert.assertNotNull((Object)this.analyzerProvider.getStatus());
    }

    @Test
    public void testRuleHasNoActionBRLFragmentHasAction() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withActionBRLFragment().withData(new Object[][]{{1, "description", 0, true}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain("RuleHasNoAction", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testConditionsShouldNotBeIgnored() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionBRLColumn().withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", null, true}, {2, "description", null, null}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain("RuleHasNoRestrictionsAndWillAlwaysFire", this.analyzerProvider.getAnalysisReport(), 1);
        TestUtil.assertDoesNotContain("RuleHasNoRestrictionsAndWillAlwaysFire", this.analyzerProvider.getAnalysisReport(), 2);
    }
}

