/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import org.drools.workbench.models.guided.dtable.backend.GuidedDTXMLPersistence;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzer;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil.AnalyzerProvider;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil.TestUtil;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class RangeCheckFromFileTest {
    @GwtMock
    AnalysisConstants analysisConstants;
    @GwtMock
    DateTimeFormat dateTimeFormat;
    private AnalyzerProvider analyzerProvider;

    @Before
    public void setUp() throws Exception {
        this.analyzerProvider = new AnalyzerProvider();
        Mockito.when((Object)this.analyzerProvider.getOracle().getFieldType("Employee", "age")).thenReturn((Object)"Integer");
        Mockito.when((Object)this.analyzerProvider.getOracle().getFieldType("Employee", "yearsService")).thenReturn((Object)"Integer");
        Mockito.when((Object)this.analyzerProvider.getOracle().getFieldType("Employee", "vacationEntitlement")).thenReturn((Object)"Integer");
    }

    @Test
    public void testFileExtraDays() throws Exception {
        String xml = TestUtil.loadResource("Extra 5 days.gdst");
        DecisionTableAnalyzer analyzer = this.analyzerProvider.makeAnalyser(GuidedDTXMLPersistence.getInstance().unmarshal(xml));
        analyzer.analyze(Collections.emptyList());
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), "MissingRangeTitle");
    }
}

