/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DataBuilderProvider;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzer;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil.AnalyzerProvider;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil.TestUtil;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.data.Coordinate;
import org.mockito.Mock;

@RunWith(value=GwtMockitoTestRunner.class)
@Ignore(value="Just for profiling")
public class SpeedTest {
    @GwtMock
    AnalysisConstants analysisConstants;
    @GwtMock
    DateTimeFormat dateTimeFormat;
    @Mock
    AsyncPackageDataModelOracle oracle;
    private AnalyzerProvider analyzerProvider;

    @Before
    public void setUp() throws Exception {
        this.analyzerProvider = new AnalyzerProvider();
    }

    @Test
    public void subsumptionTable() throws Exception {
        long baseline = System.currentTimeMillis();
        DataBuilderProvider.DataBuilder builder = DataBuilderProvider.row((Object[])new Object[]{true, null, true});
        for (int i = 0; i < 1000; ++i) {
            builder.row(new Object[]{null, false, true});
        }
        Object[][] end = builder.end();
        long now = System.currentTimeMillis();
        System.out.println("Loading of model took.. " + (now - baseline) + " ms");
        baseline = now;
        GuidedDecisionTable52 table52 = this.analyzerProvider.makeAnalyser().withPersonApprovedColumn("==").withPersonApprovedColumn("!=").withPersonApprovedActionSetField().withData(end).buildTable();
        now = System.currentTimeMillis();
        System.out.println("Made table.. " + (now - baseline) + " ms");
        baseline = now;
        DecisionTableAnalyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        now = System.currentTimeMillis();
        System.out.println("Indexing.. " + (now - baseline) + " ms");
        baseline = now;
        analyzer.analyze(Collections.emptyList());
        now = System.currentTimeMillis();
        System.out.println("Validated.. " + (now - baseline) + " ms");
        baseline = now;
        ((DTCellValue52)((List)table52.getData().get(1)).get(2)).setBooleanValue(Boolean.valueOf(false));
        ArrayList<Coordinate> updates = new ArrayList<Coordinate>();
        updates.add(new Coordinate(1, 2));
        analyzer.analyze(updates);
        now = System.currentTimeMillis();
        System.out.println("Update.. " + (now - baseline) + " ms");
        TestUtil.assertContains("RedundantRows", this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void noConflictTable() throws Exception {
        long baseline = System.currentTimeMillis();
        DataBuilderProvider.DataBuilder builder = DataBuilderProvider.row((Object[])new Object[]{-1, true});
        for (int i = 0; i < 1000; ++i) {
            builder.row(new Object[]{i, true});
        }
        Object[][] end = builder.end();
        long now = System.currentTimeMillis();
        System.out.println("Loading of model took.. " + (now - baseline) + " ms");
        baseline = now;
        GuidedDecisionTable52 table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(end).buildTable();
        now = System.currentTimeMillis();
        System.out.println("Made table.. " + (now - baseline) + " ms");
        baseline = now;
        DecisionTableAnalyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        now = System.currentTimeMillis();
        System.out.println("Indexing.. " + (now - baseline) + " ms");
        baseline = now;
        analyzer.analyze(Collections.emptyList());
        now = System.currentTimeMillis();
        System.out.println("Validated.. " + (now - baseline) + " ms");
        baseline = now;
        ((DTCellValue52)((List)table52.getData().get(1)).get(2)).setNumericValue(Integer.valueOf(3));
        ArrayList<Coordinate> updates = new ArrayList<Coordinate>();
        updates.add(new Coordinate(1, 2));
        analyzer.analyze(updates);
        now = System.currentTimeMillis();
        System.out.println("Update.. " + (now - baseline) + " ms");
        TestUtil.assertContains("RedundantRows", this.analyzerProvider.getAnalysisReport());
    }
}

