/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashMap;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.FieldInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.RuleInspectorUpdater;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Actions;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Column;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Conditions;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Field;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.FieldAction;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.FieldCondition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.ObjectField;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Values;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class FieldInspectorUpdateTest {
    @GwtMock
    AnalysisConstants analysisConstants;
    @GwtMock
    DateTimeFormat dateTimeFormat;
    @Mock
    ObjectField objectField;
    @Mock
    RuleInspectorUpdater ruleInspectorUpdater;
    private FieldCondition fieldCondition;
    private FieldAction fieldAction;

    @Before
    public void setUp() throws Exception {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("drools.dateformat", "dd-MMM-yyyy");
        ApplicationPreferences.setUp(preferences);
        Field field = (Field)Mockito.spy((Object)new Field(this.objectField, "org.Person", "String", "name"));
        this.fieldCondition = this.makeCondition(field);
        this.fieldAction = this.makeAction(field);
        new FieldInspector(field, this.ruleInspectorUpdater);
    }

    private FieldCondition makeCondition(Field field) {
        FieldCondition fieldAction = new FieldCondition(field, (Column)Mockito.mock(Column.class), "==", new Values(new Comparable[]{Integer.valueOf(11)}));
        ArrayList<FieldCondition> actionsList = new ArrayList<FieldCondition>();
        actionsList.add(fieldAction);
        Conditions conditions = new Conditions(actionsList);
        Mockito.when((Object)field.getConditions()).thenReturn((Object)conditions);
        return fieldAction;
    }

    private FieldAction makeAction(Field field) {
        FieldAction fieldAction = new FieldAction(field, (Column)Mockito.mock(Column.class), DataType.DataTypes.NUMERIC, new Values(new Comparable[]{Integer.valueOf(11)}));
        ArrayList<FieldAction> actionsList = new ArrayList<FieldAction>();
        actionsList.add(fieldAction);
        Actions actions = new Actions(actionsList);
        Mockito.when((Object)field.getActions()).thenReturn((Object)actions);
        return fieldAction;
    }

    @Test
    public void updateAction() throws Exception {
        this.fieldAction.setValue(new Values(new Comparable[]{Integer.valueOf(20)}));
        ((RuleInspectorUpdater)Mockito.verify((Object)this.ruleInspectorUpdater)).resetActionsInspectors();
    }

    @Test
    public void updateCondition() throws Exception {
        this.fieldCondition.setValue(new Values(new Comparable[]{Integer.valueOf(20)}));
        ((RuleInspectorUpdater)Mockito.verify((Object)this.ruleInspectorUpdater)).resetConditionsInspectors();
    }
}

