/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.action;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.action.ActionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.action.FieldActionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Action;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Column;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Field;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.FieldAction;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.ObjectField;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Values;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class ActionInspectorConflictResolverTest {
    @GwtMock
    DateTimeFormat dateTimeFormat;

    @Before
    public void setUp() throws Exception {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("drools.dateformat", "dd-MMM-yyyy");
        ApplicationPreferences.setUp(preferences);
    }

    @Test
    public void testRedundancy001() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name"), DataType.DataTypes.STRING, (Comparable)((Object)"Toni"));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name"), DataType.DataTypes.STRING, (Comparable)((Object)"Toni"));
        Assert.assertTrue((boolean)a.isRedundant((Object)b));
        Assert.assertTrue((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy002() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name"), DataType.DataTypes.STRING, (Comparable)((Object)"Toni"));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name"), DataType.DataTypes.STRING, (Comparable)((Object)"Rambo"));
        Assert.assertFalse((boolean)a.isRedundant((Object)b));
        Assert.assertFalse((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy003() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "org.test1.Person", "String", "name"), DataType.DataTypes.STRING, (Comparable)((Object)"Toni"));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "org.test2.Person", "String", "name"), DataType.DataTypes.STRING, (Comparable)((Object)"Toni"));
        Assert.assertFalse((boolean)a.isRedundant((Object)b));
        Assert.assertFalse((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy004() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Boolean", "isOldEnough"), DataType.DataTypes.BOOLEAN, Boolean.valueOf(true));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Boolean", "isOldEnough"), DataType.DataTypes.STRING, (Comparable)((Object)"true"));
        Assert.assertTrue((boolean)a.isRedundant((Object)b));
        Assert.assertTrue((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy005() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Boolean", "isOldEnough"), DataType.DataTypes.BOOLEAN, Boolean.valueOf(true));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Boolean", "isOldEnough"), DataType.DataTypes.STRING, (Comparable)((Object)"false"));
        Assert.assertFalse((boolean)a.isRedundant((Object)b));
        Assert.assertFalse((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy006() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "age"), DataType.DataTypes.NUMERIC_INTEGER, Integer.valueOf(20));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "age"), DataType.DataTypes.STRING, (Comparable)((Object)"20"));
        Assert.assertTrue((boolean)a.isRedundant((Object)b));
        Assert.assertTrue((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy007() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "age"), DataType.DataTypes.NUMERIC_INTEGER, Integer.valueOf(20));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "age"), DataType.DataTypes.STRING, (Comparable)((Object)"10"));
        Assert.assertFalse((boolean)a.isRedundant((Object)b));
        Assert.assertFalse((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy008() throws Exception {
        Date date = new Date();
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "birthDay"), DataType.DataTypes.DATE, date);
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "birthDay"), DataType.DataTypes.STRING, (Comparable)((Object)this.format(date)));
        Assert.assertTrue((boolean)a.isRedundant((Object)b));
        Assert.assertTrue((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testRedundancy009() throws Exception {
        Date value = new Date();
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "birthDay"), DataType.DataTypes.DATE, value);
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "birthDay"), DataType.DataTypes.STRING, (Comparable)((Object)"29-Dec-1981"));
        Assert.assertFalse((boolean)a.isRedundant((Object)b));
        Assert.assertFalse((boolean)b.isRedundant((Object)a));
    }

    @Test
    public void testConflict001() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name"), DataType.DataTypes.STRING, (Comparable)((Object)"Toni"));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name"), DataType.DataTypes.STRING, (Comparable)((Object)"Rambo"));
        Assert.assertTrue((boolean)a.conflicts((Object)b));
        Assert.assertTrue((boolean)b.conflicts((Object)a));
    }

    @Test
    public void testConflict002() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Boolean", "isOldEnough"), DataType.DataTypes.BOOLEAN, Boolean.valueOf(true));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Boolean", "isOldEnough"), DataType.DataTypes.STRING, (Comparable)((Object)"false"));
        Assert.assertTrue((boolean)a.conflicts((Object)b));
        Assert.assertTrue((boolean)b.conflicts((Object)a));
    }

    @Test
    public void testNoConflict001() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name"), DataType.DataTypes.STRING, (Comparable)((Object)"Toni"));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Address", "String", "street"), DataType.DataTypes.STRING, (Comparable)((Object)"Rambo"));
        Assert.assertFalse((boolean)a.conflicts((Object)b));
        Assert.assertFalse((boolean)b.conflicts((Object)a));
    }

    @Test
    public void testNoConflict002() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name"), DataType.DataTypes.STRING, (Comparable)((Object)"Toni"));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name"), DataType.DataTypes.STRING, (Comparable)((Object)"Toni"));
        Assert.assertFalse((boolean)a.conflicts((Object)b));
        Assert.assertFalse((boolean)b.conflicts((Object)a));
    }

    @Test
    public void testNoConflict003() throws Exception {
        ActionInspector a = this.createSetActionInspector((Action)new FieldAction(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name"), (Column)Mockito.mock(Column.class), DataType.DataTypes.BOOLEAN, new Values(new Comparable[]{Boolean.valueOf(true)})));
        ActionInspector b = this.createSetActionInspector((Action)new FieldAction(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name"), (Column)Mockito.mock(Column.class), DataType.DataTypes.STRING, new Values(new Comparable[]{Boolean.valueOf(true)})));
        Assert.assertFalse((boolean)a.conflicts((Object)b));
        Assert.assertFalse((boolean)b.conflicts((Object)a));
    }

    private ActionInspector createSetActionInspector(Field field, DataType.DataTypes dataType, Comparable comparable) {
        return new FieldActionInspector(new FieldAction(field, (Column)Mockito.mock(Column.class), dataType, new Values(new Comparable[]{comparable})));
    }

    private ActionInspector createSetActionInspector(Action action) {
        return new ActionInspector(action){

            protected String format(Date dateValue) {
                return ActionInspectorConflictResolverTest.this.format(dateValue);
            }
        };
    }

    private String format(Date dateValue) {
        return new SimpleDateFormat(ApplicationPreferences.getDroolsDateFormat()).format(dateValue);
    }
}

