/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition.NumericIntegerConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Column;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Field;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.FieldCondition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Values;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class NumericIntegerConditionInspectorSubsumptionResolverTest {
    private final Integer value1;
    private final Integer value2;
    private final String operator1;
    private final String operator2;
    private final boolean redundancyExpected;
    private final Field field = (Field)Mockito.mock(Field.class);

    @Test
    public void parametrizedTest() {
        NumericIntegerConditionInspector a = this.getCondition(this.value1, this.operator1);
        NumericIntegerConditionInspector b = this.getCondition(this.value2, this.operator2);
        Assert.assertEquals((String)this.getAssertDescription(a, b, this.redundancyExpected), (Object)this.redundancyExpected, (Object)a.isRedundant((Object)b));
        Assert.assertEquals((String)this.getAssertDescription(b, a, this.redundancyExpected), (Object)this.redundancyExpected, (Object)b.isRedundant((Object)a));
    }

    public NumericIntegerConditionInspectorSubsumptionResolverTest(String operator1, Integer value1, String operator2, Integer value2, boolean redundancyExpected) {
        this.value1 = value1;
        this.value2 = value2;
        this.operator1 = operator1;
        this.operator2 = operator2;
        this.redundancyExpected = redundancyExpected;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testData() {
        return Arrays.asList({"==", 0, "==", 0, true}, {"!=", 0, "!=", 0, true}, {">", 0, ">", 0, true}, {">=", 0, ">=", 0, true}, {"<", 0, "<", 0, true}, {"<=", 0, "<=", 0, true}, {"==", 0, "==", 1, false}, {"!=", 0, "!=", 1, false}, {">", 0, ">", 1, false}, {">=", 0, ">=", 1, false}, {"<", 0, "<", 1, false}, {"<=", 0, "<=", 1, false}, {"==", 0, "!=", 0, false}, {"==", 0, ">", 0, false}, {"==", 0, ">=", 0, false}, {"==", 0, "<", 0, false}, {"==", 0, "<=", 0, false}, {"!=", 0, ">", 0, false}, {"!=", 0, ">=", 0, false}, {"!=", 0, "<", 0, false}, {"!=", 0, "<=", 0, false}, {">", 0, ">=", 0, false}, {">", 0, "<", 0, false}, {">", 0, "<=", 0, false}, {">=", 0, "<", 0, false}, {">=", 0, "<=", 0, false}, {"<", 0, "<=", 0, false}, {"==", 0, "!=", 1, false}, {"==", 0, ">", 1, false}, {"==", 0, ">=", 1, false}, {"==", 0, "<", 1, false}, {"==", 0, "<=", 1, false}, {"!=", 0, ">", 1, false}, {"!=", 0, ">=", 1, false}, {"!=", 0, "<", 1, false}, {"!=", 0, "<=", 1, false}, {">", 0, ">=", 1, true}, {">", 0, "<", 1, false}, {">", 0, "<=", 1, false}, {">=", 0, "<", 1, false}, {">=", 0, "<=", 1, false}, {"<", 0, "<=", 1, false}, {">", 0, ">=", 1, true}, {"<", 1, "<=", 0, true});
    }

    private String getAssertDescription(NumericIntegerConditionInspector a, NumericIntegerConditionInspector b, boolean conflictExpected) {
        return String.format("Expected conditions '%s' and '%s' %sto be redundant:", a.toHumanReadableString(), b.toHumanReadableString(), conflictExpected ? "" : "not ");
    }

    private NumericIntegerConditionInspector getCondition(int value, String operator) {
        return new NumericIntegerConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), operator, new Values(new Comparable[]{Integer.valueOf(value)})));
    }
}

