/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition;

import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition.StringConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Column;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Field;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.FieldCondition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Values;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class StringConditionInspectorOverlapTest {
    @Mock
    private Field field;

    @Test
    public void test001() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{"Toni"}), "==");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{"Toni"}), "!=");
        Assert.assertFalse((boolean)a.overlaps((Object)b));
        Assert.assertFalse((boolean)b.overlaps((Object)a));
    }

    @Test
    public void test002() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{"Toni"}), "==");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{"Eder"}), "!=");
        Assert.assertTrue((boolean)a.overlaps((Object)b));
        Assert.assertTrue((boolean)b.overlaps((Object)a));
    }

    @Test
    public void test003() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{"Toni", "Michael", "Eder"}), "in");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{"Toni"}), "!=");
        Assert.assertTrue((boolean)a.overlaps((Object)b));
        Assert.assertTrue((boolean)b.overlaps((Object)a));
    }

    @Test
    public void test004() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{"Toni", "Michael", "Eder"}), "in");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{"Toni"}), "==");
        Assert.assertTrue((boolean)a.overlaps((Object)b));
        Assert.assertTrue((boolean)b.overlaps((Object)a));
    }

    @Test
    public void test005() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{"Toni", "Michael"}), "in");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{"Eder"}), "==");
        Assert.assertFalse((boolean)a.overlaps((Object)b));
        Assert.assertFalse((boolean)b.overlaps((Object)a));
    }

    @Test
    public void test006() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{"Toni", "Michael"}), "in");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{"Eder"}), "!=");
        Assert.assertTrue((boolean)a.overlaps((Object)b));
        Assert.assertTrue((boolean)b.overlaps((Object)a));
    }

    @Test
    public void test007() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{"Toni", "Michael"}), "in");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{"Eder", "John"}), "in");
        Assert.assertFalse((boolean)a.overlaps((Object)b));
        Assert.assertFalse((boolean)b.overlaps((Object)a));
    }

    @Test
    public void test008() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{"Toni", "Michael"}), "in");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{"Toni", "Eder"}), "in");
        Assert.assertTrue((boolean)a.overlaps((Object)b));
        Assert.assertTrue((boolean)b.overlaps((Object)a));
    }

    @Test
    public void test009() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{"Toni"}), "in");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{"Eder", "Toni"}), "in");
        Assert.assertTrue((boolean)a.overlaps((Object)b));
        Assert.assertTrue((boolean)b.overlaps((Object)a));
    }

    @Test
    public void test010() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{""}), "==");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{""}), "==");
        Assert.assertFalse((boolean)a.overlaps((Object)b));
        Assert.assertFalse((boolean)b.overlaps((Object)a));
    }

    @Test
    public void test011() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{"Toni"}), "==");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{"Toni"}), "==");
        Assert.assertTrue((boolean)a.overlaps((Object)b));
        Assert.assertTrue((boolean)b.overlaps((Object)a));
    }

    private StringConditionInspector getCondition(Values values, String operator) {
        return new StringConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), operator, values));
    }
}

