/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition.StringConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Column;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Field;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.FieldCondition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Values;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class StringConditionInspectorSubsumptionTest {
    private final Values value1;
    private final Values value2;
    private final String operator1;
    private final String operator2;
    private final boolean aSubsumesB;
    private final boolean bSubsumesA;
    private final Field field = (Field)Mockito.mock(Field.class);

    @Test
    public void testASubsumesB() {
        StringConditionInspector a = this.getCondition(this.value1, this.operator1);
        StringConditionInspector b = this.getCondition(this.value2, this.operator2);
        Assert.assertEquals((String)this.getAssertDescription(a, b, this.aSubsumesB), (Object)this.aSubsumesB, (Object)a.subsumes((Object)b));
    }

    @Test
    public void testBSubsumesA() {
        StringConditionInspector a = this.getCondition(this.value1, this.operator1);
        StringConditionInspector b = this.getCondition(this.value2, this.operator2);
        Assert.assertEquals((String)this.getAssertDescription(b, a, this.bSubsumesA), (Object)this.bSubsumesA, (Object)b.subsumes((Object)a));
    }

    public StringConditionInspectorSubsumptionTest(String operator1, Values value1, String operator2, Values value2, boolean aSubsumesB, boolean bSubsumesA) {
        this.value1 = value1;
        this.value2 = value2;
        this.operator1 = operator1;
        this.operator2 = operator2;
        this.aSubsumesB = aSubsumesB;
        this.bSubsumesA = bSubsumesA;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testData() {
        return Arrays.asList({"==", new Values(new Comparable[]{"a"}), "==", new Values(new Comparable[]{"a"}), true, true}, {"!=", new Values(new Comparable[]{"a"}), "!=", new Values(new Comparable[]{"a"}), true, true}, {">", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{"a"}), true, true}, {">=", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), true, true}, {"<", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), true, true}, {"<=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), true, true}, {"in", new Values(new Comparable[]{"a", "b"}), "in", new Values(new Comparable[]{"a", "b"}), true, true}, {"not in", new Values(new Comparable[]{"a", "b"}), "not in", new Values(new Comparable[]{"a", "b"}), true, true}, {"matches", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), true, true}, {"soundslike", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), true, true}, {"==", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), true, true}, {"matches", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), true, true}, {"==", new Values(new Comparable[]{"a"}), "==", new Values(new Comparable[]{"b"}), false, false}, {"==", new Values(new Comparable[]{"a"}), "!=", new Values(new Comparable[]{"a"}), false, false}, {"==", new Values(new Comparable[]{"a"}), "!=", new Values(new Comparable[]{"b"}), false, true}, {"==", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{"a"}), false, false}, {"==", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{" "}), false, false}, {"==", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"b"}), false, false}, {"==", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), false, true}, {"==", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{" "}), false, false}, {"==", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), false, false}, {"==", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"b"}), false, false}, {"==", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false, true}, {"==", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{" "}), false, false}, {"==", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"b"}), false, false}, {"==", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false, true}, {"==", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"b", "c"}), false, false}, {"==", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), false, false}, {"==", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"b", "c"}), false, true}, {"!=", new Values(new Comparable[]{"a"}), "!=", new Values(new Comparable[]{"b"}), false, false}, {"!=", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{" "}), false, false}, {"!=", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{"b"}), false, false}, {"!=", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{" "}), false, false}, {"!=", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), false, false}, {"!=", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"b"}), false, false}, {"!=", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"b"}), false, false}, {"!=", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{" "}), false, false}, {"!=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"b"}), false, false}, {"!=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false, false}, {"!=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{" "}), false, false}, {"!=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false, false}, {"!=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"b", "c"}), true, false}, {"!=", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), false, true}, {"!=", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"b", "c"}), false, false}, {">", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{"b"}), false, false}, {">", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), false, true}, {">", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"b"}), false, false}, {">", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{" "}), false, false}, {">", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"c"}), false, false}, {">", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{" "}), false, false}, {">", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"b"}), false, false}, {">", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false, false}, {">", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"b", "c"}), false, false}, {">", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), false, false}, {">", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"0", "1"}), false, false}, {">=", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"b"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{" "}), false, false}, {">=", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"b"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{" "}), false, false}, {">=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"c"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"0", "b"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"b", "c"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"0", "1"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"b"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{" "}), false, false}, {"<", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"c"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"0", "1"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"0", "1"}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"b"}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"0", "1"}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"b", "c"}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"0", "1"}), false, false}, {"in", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false, true}, {"in", new Values(new Comparable[]{"b", "a"}), "in", new Values(new Comparable[]{"a", "b"}), true, true}, {"in", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"0", "1"}), false, false}, {"in", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), false, false}, {"in", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"b", "c"}), false, true}, {"not in", new Values(new Comparable[]{"b", "a"}), "not in", new Values(new Comparable[]{"a", "b"}), true, true}, {"not in", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), false, true}, {"not in", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"b", "c"}), false, false});
    }

    private String getAssertDescription(StringConditionInspector a, StringConditionInspector b, boolean conflictExpected) {
        return String.format("Expected condition '%s' %sto subsume condition '%s':", a.toHumanReadableString(), conflictExpected ? "" : "not ", b.toHumanReadableString());
    }

    private StringConditionInspector getCondition(Values values, String operator) {
        return new StringConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), operator, values));
    }
}

