/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.drools.workbench.models.datamodel.oracle.OperatorsOracle;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition.StringConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Column;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Field;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.FieldCondition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.ObjectField;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Values;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class StringConditionInspectorToHumanReadableTest {
    private static final String FIELD_NAME = "name";
    private static final String VALUE = "someValue";
    private final String operator;

    @Test
    public void testToHumanReadableString() {
        StringConditionInspector inspector = this.getStringConditionInspector();
        if (this.operator.equals("!= null")) {
            Assert.assertEquals((Object)String.format("%s %s", FIELD_NAME, this.operator), (Object)inspector.toHumanReadableString());
        } else if (this.operator.equals("== null")) {
            Assert.assertEquals((Object)String.format("%s %s", FIELD_NAME, this.operator), (Object)inspector.toHumanReadableString());
        } else {
            Assert.assertEquals((Object)String.format("%s %s %s", FIELD_NAME, this.operator, VALUE), (Object)inspector.toHumanReadableString());
        }
    }

    private StringConditionInspector getStringConditionInspector() {
        if (this.operator.equals("!= null")) {
            return new StringConditionInspector(new FieldCondition(new Field((ObjectField)Mockito.mock(ObjectField.class), "Test", "String", FIELD_NAME), (Column)Mockito.mock(Column.class), "!=", Values.nullValue()));
        }
        if (this.operator.equals("== null")) {
            return new StringConditionInspector(new FieldCondition(new Field((ObjectField)Mockito.mock(ObjectField.class), "Test", "String", FIELD_NAME), (Column)Mockito.mock(Column.class), "==", Values.nullValue()));
        }
        return new StringConditionInspector(new FieldCondition(new Field((ObjectField)Mockito.mock(ObjectField.class), "Test", "String", FIELD_NAME), (Column)Mockito.mock(Column.class), this.operator, new Values(new Comparable[]{VALUE})));
    }

    public StringConditionInspectorToHumanReadableTest(String operator) {
        this.operator = operator;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testData() {
        ArrayList<String> data = new ArrayList<String>(Arrays.asList(OperatorsOracle.STRING_OPERATORS));
        data.addAll(Arrays.asList(OperatorsOracle.EXPLICIT_LIST_OPERATORS));
        ArrayList<Object[]> data2 = new ArrayList<Object[]>();
        for (String operator : data) {
            data2.add(new Object[]{operator});
        }
        return data2;
    }
}

