/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DataBuilderProvider;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.UpdateManager;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.CheckRunner;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil.AnalyzerProvider;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.data.Coordinate;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class UpdateManagerTest {
    private UpdateManager updateManager;
    private GuidedDecisionTable52 table52;
    @Spy
    private CheckRunner checkRunner;
    private AnalyzerProvider analyzerProvider;

    @Before
    public void setUp() throws Exception {
        this.analyzerProvider = new AnalyzerProvider();
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row((Object[])new Object[]{1, true}).row(new Object[]{null, null}).end()).buildTable();
        this.updateManager = this.analyzerProvider.getUpdateManager(this.checkRunner, this.table52);
    }

    @Test
    public void testDoNotUpdateWhenDescriptionChanges() throws Exception {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(new Coordinate(1, 1));
        this.updateManager.update(coordinates);
        ((CheckRunner)Mockito.verify((Object)this.checkRunner, (VerificationMode)Mockito.never())).addChecks((Set)Matchers.any(Set.class));
    }

    @Test
    public void testDoNotUpdateConditionWhenValueDidNotChange() throws Exception {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(new Coordinate(1, 2));
        this.updateManager.update(coordinates);
        ((CheckRunner)Mockito.verify((Object)this.checkRunner, (VerificationMode)Mockito.never())).addChecks(Mockito.anySet());
    }

    @Test
    public void testDoNotUpdateActionWhenValueDidNotChange() throws Exception {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(new Coordinate(0, 3));
        this.updateManager.update(coordinates);
        ((CheckRunner)Mockito.verify((Object)this.checkRunner, (VerificationMode)Mockito.never())).addChecks(Mockito.anySet());
    }

    @Test
    public void testSetIntegerConditionToNewInteger() throws Exception {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Coordinate coordinate = new Coordinate(0, 2);
        coordinates.add(coordinate);
        ((DTCellValue52)((List)this.table52.getData().get(0)).get(2)).setNumericValue(Integer.valueOf(123));
        this.updateManager.update(coordinates);
        ((CheckRunner)Mockito.verify((Object)this.checkRunner)).addChecks(Mockito.anySet());
    }

    @Test
    public void testSetBooleanActionToNewBoolean() throws Exception {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Coordinate coordinate = new Coordinate(0, 3);
        coordinates.add(coordinate);
        ((DTCellValue52)((List)this.table52.getData().get(0)).get(3)).setBooleanValue(Boolean.valueOf(false));
        this.updateManager.update(coordinates);
        ((CheckRunner)Mockito.verify((Object)this.checkRunner)).addChecks(Mockito.anySet());
    }

    @Test
    public void testSetActionToNull() throws Exception {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Coordinate coordinate = new Coordinate(0, 3);
        coordinates.add(coordinate);
        ((DTCellValue52)((List)this.table52.getData().get(0)).get(3)).setBooleanValue(null);
        this.updateManager.update(coordinates);
        ((CheckRunner)Mockito.verify((Object)this.checkRunner)).addChecks(Mockito.anySet());
    }

    @Test
    public void testSetConditionToNull() throws Exception {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Coordinate coordinate = new Coordinate(0, 2);
        coordinates.add(coordinate);
        ((DTCellValue52)((List)this.table52.getData().get(0)).get(2)).setNumericValue((Integer)null);
        this.updateManager.update(coordinates);
        ((CheckRunner)Mockito.verify((Object)this.checkRunner)).addChecks(Mockito.anySet());
    }

    @Test
    public void testFillNullCondition() throws Exception {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Coordinate coordinate = new Coordinate(1, 2);
        coordinates.add(coordinate);
        ((DTCellValue52)((List)this.table52.getData().get(1)).get(2)).setNumericValue(Integer.valueOf(123));
        this.updateManager.update(coordinates);
        ((CheckRunner)Mockito.verify((Object)this.checkRunner)).addChecks(Mockito.anySet());
    }

    @Test
    public void testFillNullAction() throws Exception {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Coordinate coordinate = new Coordinate(1, 3);
        coordinates.add(coordinate);
        ((DTCellValue52)((List)this.table52.getData().get(1)).get(3)).setBooleanValue(Boolean.valueOf(false));
        this.updateManager.update(coordinates);
        ((CheckRunner)Mockito.verify((Object)this.checkRunner)).addChecks(Mockito.anySet());
    }

    @Test
    public void testFillNullActionWithNull() throws Exception {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Coordinate coordinate = new Coordinate(1, 3);
        coordinates.add(coordinate);
        ((DTCellValue52)((List)this.table52.getData().get(1)).get(3)).setBooleanValue(null);
        this.updateManager.update(coordinates);
        ((CheckRunner)Mockito.verify((Object)this.checkRunner, (VerificationMode)Mockito.never())).addChecks(Mockito.anySet());
    }

    @Test
    public void testFillNullConditionWithNull() throws Exception {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Coordinate coordinate = new Coordinate(1, 2);
        coordinates.add(coordinate);
        ((DTCellValue52)((List)this.table52.getData().get(1)).get(2)).setNumericValue((Integer)null);
        this.updateManager.update(coordinates);
        ((CheckRunner)Mockito.verify((Object)this.checkRunner, (VerificationMode)Mockito.never())).addChecks(Mockito.anySet());
    }
}

