/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps;

import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.MultiMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.MultiMapChangeHandler;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.MultiMapFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Value;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChangeHandledMultiMapTest {
    private MultiMap<Value, String, List<String>> map;
    private MultiMapChangeHandler.ChangeSet<Value, String> changeSet;
    private int timesCalled = 0;

    @Before
    public void setUp() throws Exception {
        this.timesCalled = 0;
        this.map = MultiMapFactory.make((boolean)true);
        this.map.addChangeListener((MultiMapChangeHandler)new MultiMapChangeHandler<Value, String>(){

            public void onChange(MultiMapChangeHandler.ChangeSet<Value, String> changeSet) {
                ChangeHandledMultiMapTest.this.changeSet = changeSet;
                ChangeHandledMultiMapTest.this.timesCalled++;
            }
        });
    }

    @Test
    public void testSize() throws Exception {
        Assert.assertNull(this.changeSet);
        Assert.assertEquals((long)0L, (long)this.timesCalled);
    }

    @Test
    public void testPut() throws Exception {
        this.map.put((Comparable)new Value((Comparable)((Object)"hello")), (Object)"test");
        Assert.assertTrue((boolean)this.changeSet.getAdded().get((Comparable)new Value((Comparable)((Object)"hello"))).contains("test"));
        Assert.assertEquals((long)1L, (long)this.timesCalled);
    }

    @Test
    public void testAddAllValues() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        list.add("c");
        this.map.addAllValues((Comparable)new Value((Comparable)((Object)"hello")), list);
        Assert.assertEquals((long)3L, (long)this.changeSet.getAdded().get((Comparable)new Value((Comparable)((Object)"hello"))).size());
        Assert.assertTrue((boolean)this.changeSet.getAdded().get((Comparable)new Value((Comparable)((Object)"hello"))).contains("a"));
        Assert.assertTrue((boolean)this.changeSet.getAdded().get((Comparable)new Value((Comparable)((Object)"hello"))).contains("b"));
        Assert.assertTrue((boolean)this.changeSet.getAdded().get((Comparable)new Value((Comparable)((Object)"hello"))).contains("c"));
        Assert.assertEquals((long)1L, (long)this.timesCalled);
    }
}

