/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps;

import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasIndex;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasKeys;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.IndexedKeyTreeMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.KeyDefinition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.IndexKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Key;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.UUIDKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.UpdatableKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Value;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IndexedKeyTreeMapTest {
    private static final KeyDefinition NAME_KEY_DEFINITION = KeyDefinition.newKeyDefinition().withId("name").build();
    private static final KeyDefinition AGE_KEY_DEFINITION = KeyDefinition.newKeyDefinition().withId("age").updatable().build();
    private IndexedKeyTreeMap<Person> map;
    private Person toni;
    private Person eder;
    private Person michael;

    @Before
    public void setUp() throws Exception {
        this.map = new IndexedKeyTreeMap(new KeyDefinition[]{NAME_KEY_DEFINITION, AGE_KEY_DEFINITION});
        this.toni = new Person("Toni", 20);
        this.eder = new Person("Eder", 20);
        this.michael = new Person("Michael", 30);
        this.put(this.toni);
        this.put(this.eder);
        this.put(this.michael);
    }

    private void put(Person person) {
        this.map.put((HasIndex)person);
    }

    @Test
    public void testIndexOrder() throws Exception {
        Assert.assertEquals((Object)this.toni, this.map.get(IndexKey.INDEX_ID).get((Comparable)new Value((Comparable)Integer.valueOf(0))).iterator().next());
        Assert.assertEquals((Object)this.eder, this.map.get(IndexKey.INDEX_ID).get((Comparable)new Value((Comparable)Integer.valueOf(1))).iterator().next());
        Assert.assertEquals((Object)this.michael, this.map.get(IndexKey.INDEX_ID).get((Comparable)new Value((Comparable)Integer.valueOf(2))).iterator().next());
    }

    @Test
    public void testAddToMiddle() throws Exception {
        Person smurf = new Person("Smurf", 55);
        this.map.put((HasIndex)smurf, 1);
        Assert.assertEquals((long)4L, (long)this.map.get(IndexKey.INDEX_ID).size());
        Assert.assertEquals((Object)this.toni, this.map.get(IndexKey.INDEX_ID).get((Comparable)new Value((Comparable)Integer.valueOf(0))).iterator().next());
        Assert.assertEquals((Object)smurf, this.map.get(IndexKey.INDEX_ID).get((Comparable)new Value((Comparable)Integer.valueOf(1))).iterator().next());
        Assert.assertEquals((Object)this.eder, this.map.get(IndexKey.INDEX_ID).get((Comparable)new Value((Comparable)Integer.valueOf(2))).iterator().next());
        Assert.assertEquals((Object)this.michael, this.map.get(IndexKey.INDEX_ID).get((Comparable)new Value((Comparable)Integer.valueOf(3))).iterator().next());
    }

    @Test
    public void testRemove() throws Exception {
        this.toni.uuidKey.retract();
        Assert.assertEquals((Object)this.eder, this.map.get(IndexKey.INDEX_ID).get((Comparable)new Value((Comparable)Integer.valueOf(0))).iterator().next());
        Assert.assertEquals((Object)this.michael, this.map.get(IndexKey.INDEX_ID).get((Comparable)new Value((Comparable)Integer.valueOf(1))).iterator().next());
        this.eder.uuidKey.retract();
        Person next = (Person)this.map.get(IndexKey.INDEX_ID).get((Comparable)new Value((Comparable)Integer.valueOf(0))).iterator().next();
        Assert.assertEquals((Object)this.michael, (Object)next);
    }

    @Test
    public void testUpdateAge() throws Exception {
        this.toni.setAge(100);
        Assert.assertEquals((long)100L, (long)this.toni.getAge());
        Person person = (Person)this.map.get(AGE_KEY_DEFINITION).get((Comparable)new Value((Comparable)Integer.valueOf(100))).iterator().next();
        Assert.assertEquals((Object)this.toni, (Object)person);
        Assert.assertEquals((long)100L, (long)person.getAge());
    }

    class Person
    implements HasIndex,
    HasKeys {
        private final UUIDKey uuidKey = new UUIDKey((HasKeys)this);
        private UpdatableKey<Person> indexKey;
        final String name;
        private UpdatableKey<Person> ageKey;

        public Person(String name, int age) {
            this.name = name;
            this.ageKey = new UpdatableKey(AGE_KEY_DEFINITION, (Comparable)Integer.valueOf(age));
        }

        public Key[] keys() {
            return new Key[]{this.uuidKey, this.indexKey, new Key(NAME_KEY_DEFINITION, (Comparable)((Object)this.name)), this.ageKey};
        }

        public int getIndex() {
            return (Integer)this.indexKey.getSingleValueComparator();
        }

        public void setIndex(int index) {
            UpdatableKey newKey;
            UpdatableKey<Person> oldKey = this.indexKey;
            this.indexKey = newKey = new UpdatableKey(IndexKey.INDEX_ID, (Comparable)Integer.valueOf(index));
            if (oldKey != null) {
                oldKey.update(newKey, (Object)this);
            }
        }

        public int getAge() {
            return (Integer)this.ageKey.getSingleValueComparator();
        }

        public void setAge(int age) {
            UpdatableKey newKey;
            if (this.ageKey.getSingleValue().equals(age)) {
                return;
            }
            UpdatableKey<Person> oldKey = this.ageKey;
            this.ageKey = newKey = new UpdatableKey(AGE_KEY_DEFINITION, (Comparable)Integer.valueOf(age));
            oldKey.update(newKey, (Object)this);
        }

        public UUIDKey getUuidKey() {
            return this.uuidKey;
        }
    }
}

