/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps;

import java.util.Collection;
import java.util.Collections;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasKeys;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.KeyDefinition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.KeyTreeMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.MultiMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Key;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.UUIDKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.matchers.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KeyTreeMapMergeTest {
    private static final KeyDefinition NAME_KEY_DEFINITION = KeyDefinition.newKeyDefinition().withId("name").build();
    private static final KeyDefinition AGE_KEY_DEFINITION = KeyDefinition.newKeyDefinition().withId("age").build();
    private KeyTreeMap<Person> treeMap;
    private Person pat;
    private KeyTreeMap<Person> otherKeyTreeMap;
    private Person mat;
    private Matcher nameMatcher = new Matcher(NAME_KEY_DEFINITION);

    @Before
    public void setUp() throws Exception {
        this.treeMap = new KeyTreeMap(new KeyDefinition[]{NAME_KEY_DEFINITION, AGE_KEY_DEFINITION});
        this.pat = new Person("Pat", 10);
        this.add(this.treeMap, this.pat);
        this.otherKeyTreeMap = new KeyTreeMap(new KeyDefinition[]{NAME_KEY_DEFINITION, AGE_KEY_DEFINITION});
        this.mat = new Person("mat", 15);
        this.add(this.otherKeyTreeMap, this.mat);
    }

    private void add(KeyTreeMap<Person> treeMap, Person person) {
        treeMap.put((HasKeys)person);
    }

    @Test
    public void testMergeToEmptyMap() throws Exception {
        KeyTreeMap empty = new KeyTreeMap(new KeyDefinition[]{UUIDKey.UNIQUE_UUID, NAME_KEY_DEFINITION, AGE_KEY_DEFINITION});
        empty.merge(this.otherKeyTreeMap);
        Assert.assertEquals((long)1L, (long)empty.get(this.nameMatcher.getKeyDefinition()).allValues().size());
    }

    @Test
    public void testNames() throws Exception {
        this.treeMap.merge(this.otherKeyTreeMap);
        MultiMap multiMap = this.treeMap.get(this.nameMatcher.getKeyDefinition());
        Assert.assertEquals((long)2L, (long)multiMap.allValues().size());
    }

    @Test
    public void testAge() throws Exception {
        this.treeMap.merge(this.otherKeyTreeMap);
        Assert.assertEquals((long)2L, (long)this.allPersons(this.treeMap).size());
    }

    @Test
    public void testRetract() throws Exception {
        KeyTreeMap thirdKeyTreeMap = new KeyTreeMap(new KeyDefinition[]{NAME_KEY_DEFINITION, AGE_KEY_DEFINITION});
        thirdKeyTreeMap.merge(this.treeMap);
        thirdKeyTreeMap.merge(this.otherKeyTreeMap);
        Assert.assertEquals((long)2L, (long)this.allPersons((KeyTreeMap<Person>)thirdKeyTreeMap).size());
        Assert.assertEquals((long)1L, (long)this.allPersons(this.treeMap).size());
        Assert.assertEquals((long)1L, (long)this.allPersons(this.otherKeyTreeMap).size());
        this.pat.uuidKey.retract();
        Assert.assertEquals((long)1L, (long)this.allPersons((KeyTreeMap<Person>)thirdKeyTreeMap).size());
        Assert.assertEquals((long)0L, (long)this.allPersons(this.treeMap).size());
        Assert.assertEquals((long)1L, (long)this.allPersons(this.otherKeyTreeMap).size());
    }

    private Collection<Person> allPersons(KeyTreeMap<Person> personKeyTreeMap) {
        Matcher age = new Matcher(KeyDefinition.newKeyDefinition().withId("age").build());
        MultiMap personChangeHandledMultiMap = personKeyTreeMap.get(age.getKeyDefinition());
        if (personChangeHandledMultiMap != null) {
            return personChangeHandledMultiMap.allValues();
        }
        return Collections.emptyList();
    }

    private class Person
    implements HasKeys {
        private String name;
        private Integer age;
        private UUIDKey uuidKey = new UUIDKey((HasKeys)this);

        public Person(String name, Integer age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public Integer getAge() {
            return this.age;
        }

        public Key[] keys() {
            return new Key[]{this.uuidKey, new Key(NAME_KEY_DEFINITION, (Comparable)((Object)this.name)), new Key(AGE_KEY_DEFINITION, (Comparable)this.age)};
        }

        public UUIDKey getUuidKey() {
            return this.uuidKey;
        }
    }
}

