/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps;

import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.Util;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasKeys;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.KeyDefinition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.KeyTreeMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.MultiMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Key;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.UUIDKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.UpdatableKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Value;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Values;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KeyTreeMapMultiValueKeyTest {
    private KeyTreeMap<Country> map;
    private final KeyDefinition NAME = KeyDefinition.newKeyDefinition().withId("name").build();
    private final KeyDefinition AREA_CODE = KeyDefinition.newKeyDefinition().withId("areaCode").build();
    private Country norway;
    private Country finland;
    private Country sweden;

    @Before
    public void setUp() throws Exception {
        this.map = new KeyTreeMap(new KeyDefinition[]{this.NAME, this.AREA_CODE});
        this.finland = new Country("Finland", 48100);
        this.sweden = new Country("Sweden", 12345, 51000);
        this.norway = new Country("Norway", 0, 51000);
        this.map.put((HasKeys)this.finland);
        this.map.put((HasKeys)this.sweden);
        this.map.put((HasKeys)this.norway);
    }

    @Test
    public void testFindByUUID() throws Exception {
        Util.assertMapContent(this.map.get(UUIDKey.UNIQUE_UUID), new Comparable[]{this.finland.uuidKey, this.sweden.uuidKey, this.norway.uuidKey});
    }

    @Test
    public void testFindByAreaCodeKey() throws Exception {
        Util.assertMapContent(this.map.get(this.AREA_CODE), Integer.valueOf(48100), Integer.valueOf(12345), Integer.valueOf(51000), Integer.valueOf(0));
    }

    @Test
    public void testFindByAreaCode() throws Exception {
        MultiMap areaCode = this.map.get(this.AREA_CODE);
        Assert.assertEquals((long)1L, (long)areaCode.get((Comparable)new Value((Comparable)Integer.valueOf(48100))).size());
        Assert.assertTrue((boolean)areaCode.get((Comparable)new Value((Comparable)Integer.valueOf(48100))).contains(this.finland));
        Assert.assertEquals((long)1L, (long)areaCode.get((Comparable)new Value((Comparable)Integer.valueOf(12345))).size());
        Assert.assertTrue((boolean)areaCode.get((Comparable)new Value((Comparable)Integer.valueOf(12345))).contains(this.sweden));
        Assert.assertEquals((long)2L, (long)areaCode.get((Comparable)new Value((Comparable)Integer.valueOf(51000))).size());
        Assert.assertTrue((boolean)areaCode.get((Comparable)new Value((Comparable)Integer.valueOf(51000))).contains(this.sweden));
        Assert.assertTrue((boolean)areaCode.get((Comparable)new Value((Comparable)Integer.valueOf(51000))).contains(this.norway));
    }

    class Country
    implements HasKeys {
        private final UUIDKey uuidKey = new UUIDKey((HasKeys)this);
        final String name;
        private UpdatableKey areaCode;

        public Country(String name, Integer ... areaCodes) {
            this.name = name;
            this.areaCode = new UpdatableKey(KeyTreeMapMultiValueKeyTest.this.AREA_CODE, new Values((Comparable[])areaCodes));
        }

        public Key[] keys() {
            return new Key[]{this.uuidKey, new Key(KeyTreeMapMultiValueKeyTest.this.NAME, (Comparable)((Object)this.name)), this.areaCode};
        }

        public void setAge(Integer ... areaCodes) {
            UpdatableKey newKey;
            UpdatableKey oldKey = this.areaCode;
            this.areaCode = newKey = new UpdatableKey(KeyTreeMapMultiValueKeyTest.this.AREA_CODE, new Values((Comparable[])areaCodes));
            oldKey.update(newKey, (Object)this);
        }

        public UUIDKey getUuidKey() {
            return this.uuidKey;
        }
    }
}

