/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps;

import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.Util;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasKeys;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.ChangeHandledMultiMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.KeyDefinition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.KeyTreeMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.MultiMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.MultiMapChangeHandler;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Key;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.UUIDKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.UpdatableKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Value;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class KeyTreeMapTest {
    private final KeyDefinition AGE = KeyDefinition.newKeyDefinition().updatable().withId("age").build();
    private final KeyDefinition NAME = KeyDefinition.newKeyDefinition().withId("name").build();
    private KeyTreeMap<Person> map;
    private Person toni;
    private Person eder;
    private Person michael;

    @Before
    public void setUp() throws Exception {
        this.map = new KeyTreeMap(new KeyDefinition[]{this.AGE, this.NAME});
        this.toni = new Person("Toni", 20);
        this.eder = new Person("Eder", 20);
        this.michael = new Person("Michael", 30);
        this.put(this.toni);
        this.put(this.eder);
        this.put(this.michael);
    }

    @Test
    public void testFindByUUID() throws Exception {
        Util.assertMapContent(this.map.get(UUIDKey.UNIQUE_UUID), new Comparable[]{this.toni.uuidKey, this.eder.uuidKey, this.michael.uuidKey});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReAdd() throws Exception {
        this.put(this.toni);
    }

    @Test
    public void testFindByName() throws Exception {
        Util.assertMapContent(this.map.get(KeyDefinition.newKeyDefinition().withId("name").build()), new Comparable[]{"Toni", "Eder", "Michael"});
    }

    @Test
    public void testFindByAge() throws Exception {
        MultiMap age = this.map.get(KeyDefinition.newKeyDefinition().withId("age").build());
        Util.assertMapContent(age, Integer.valueOf(20), Integer.valueOf(20), Integer.valueOf(30));
        Assert.assertTrue((boolean)age.get((Comparable)new Value((Comparable)Integer.valueOf(20))).contains(this.toni));
        Assert.assertTrue((boolean)age.get((Comparable)new Value((Comparable)Integer.valueOf(20))).contains(this.eder));
    }

    @Test
    public void testUpdateAge() throws Exception {
        MultiMapChangeHandler changeHandler = (MultiMapChangeHandler)Mockito.mock(MultiMapChangeHandler.class);
        ((ChangeHandledMultiMap)this.map.get(this.AGE)).addChangeListener(changeHandler);
        this.toni.setAge(10);
        MultiMap age = this.map.get(this.AGE);
        Assert.assertFalse((boolean)age.get((Comparable)new Value((Comparable)Integer.valueOf(20))).contains(this.toni));
        Assert.assertTrue((boolean)age.get((Comparable)new Value((Comparable)Integer.valueOf(10))).contains(this.toni));
    }

    @Test
    public void testRetract() throws Exception {
        this.toni.uuidKey.retract();
        Util.assertMapContent(this.map.get(UUIDKey.UNIQUE_UUID), new Comparable[]{this.eder.uuidKey, this.michael.uuidKey});
        Util.assertMapContent(this.map.get(KeyDefinition.newKeyDefinition().withId("name").build()), new Comparable[]{"Eder", "Michael"});
        Util.assertMapContent(this.map.get(KeyDefinition.newKeyDefinition().withId("age").build()), Integer.valueOf(20), Integer.valueOf(30));
    }

    @Test
    public void testRemoveWhenItemDoesNotExist() throws Exception {
        UUIDKey uuidKey = (UUIDKey)Mockito.mock(UUIDKey.class);
        Mockito.when((Object)uuidKey.getKeyDefinition()).thenReturn((Object)UUIDKey.UNIQUE_UUID);
        Mockito.when((Object)uuidKey.getSingleValue()).thenReturn((Object)new Value((Comparable)((Object)"DoesNotExist")));
        Assert.assertNull((Object)this.map.remove(uuidKey));
        Assert.assertEquals((long)3L, (long)this.map.get(UUIDKey.UNIQUE_UUID).size());
    }

    private void put(Person person) {
        this.map.put((HasKeys)person);
    }

    class Person
    implements HasKeys {
        private final UUIDKey uuidKey = new UUIDKey((HasKeys)this);
        final String name;
        private UpdatableKey ageKey;

        public Person(String name, int age) {
            this.name = name;
            this.ageKey = new UpdatableKey(KeyTreeMapTest.this.AGE, (Comparable)Integer.valueOf(age));
        }

        public Key[] keys() {
            return new Key[]{this.uuidKey, new Key(KeyTreeMapTest.this.NAME, (Comparable)((Object)this.name)), this.ageKey};
        }

        public void setAge(int age) {
            UpdatableKey newKey;
            UpdatableKey oldKey = this.ageKey;
            this.ageKey = newKey = new UpdatableKey(KeyTreeMapTest.this.AGE, (Comparable)Integer.valueOf(age));
            oldKey.update(newKey, (Object)this);
        }

        public UUIDKey getUuidKey() {
            return this.uuidKey;
        }
    }
}

