/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps;

import java.util.ArrayList;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasKeys;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasUUID;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.InspectorFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.UpdatableInspectorList;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Key;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.UUIDKey;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class UpdatableInspectorListTest {
    private UpdatableInspectorList<HasUUID, Item> list;

    @Before
    public void setUp() throws Exception {
        this.list = new UpdatableInspectorList((InspectorFactory)new InspectorFactory<HasUUID, Item>(){

            public HasUUID make(Item item) {
                return new HasUUID(){

                    public UUIDKey getUuidKey() {
                        return (UUIDKey)Mockito.mock(UUIDKey.class);
                    }
                };
            }
        });
    }

    @Test
    public void add() throws Exception {
        ArrayList<Item> updates = new ArrayList<Item>();
        updates.add(new Item());
        this.list.update(updates);
        Assert.assertEquals((long)1L, (long)this.list.size());
    }

    @Test
    public void reAdd() throws Exception {
        ArrayList<Item> updates = new ArrayList<Item>();
        updates.add(new Item());
        this.list.update(updates);
        Assert.assertEquals((long)1L, (long)this.list.size());
        this.list.update(updates);
        Assert.assertEquals((long)1L, (long)this.list.size());
    }

    @Test
    public void reAddNew() throws Exception {
        ArrayList<Item> updates = new ArrayList<Item>();
        updates.add(new Item());
        this.list.update(updates);
        Assert.assertEquals((long)1L, (long)this.list.size());
        updates.add(new Item());
        this.list.update(updates);
        Assert.assertEquals((long)2L, (long)this.list.size());
    }

    @Test
    public void remove() throws Exception {
        ArrayList<Item> updates = new ArrayList<Item>();
        updates.add(new Item());
        Item removeMe = new Item();
        updates.add(removeMe);
        this.list.update(updates);
        Assert.assertEquals((long)2L, (long)this.list.size());
        updates.remove(removeMe);
        this.list.update(updates);
        Assert.assertEquals((long)1L, (long)this.list.size());
    }

    private class Item
    implements HasKeys {
        private UUIDKey uuidKey = new UUIDKey((HasKeys)this);

        private Item() {
        }

        public Key[] keys() {
            return new Key[]{this.uuidKey};
        }

        public UUIDKey getUuidKey() {
            return this.uuidKey;
        }
    }
}

