/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.CancellableRepeatingCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.RuleInspectorCache;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.RuleInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.Check;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.CheckManager;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.CheckRunner;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.SingleCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Rule;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.ExplanationProvider;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Severity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;

@RunWith(value=GwtMockitoTestRunner.class)
public class CheckRunnerTest {
    @Spy
    private CheckRunner checkRunner = new CheckRunner(){

        protected void doRun(CancellableRepeatingCommand command) {
            while (command.execute()) {
            }
        }
    };
    @Mock
    private RuleInspectorCache cache;
    private RuleInspector ruleInspector1;
    private RuleInspector ruleInspector2;
    private RuleInspector ruleInspector3;
    private ArrayList<RuleInspector> ruleInspectors;
    private CheckManager checkManager;

    @Before
    public void setUp() throws Exception {
        this.checkManager = new CheckManager(){

            public HashSet<Check> makeSingleChecks(RuleInspector ruleInspector) {
                HashSet<Check> result = new HashSet<Check>();
                result.add((Check)new MockSingleCheck(ruleInspector));
                return result;
            }
        };
        this.ruleInspectors = new ArrayList();
        Mockito.when((Object)this.cache.all()).thenReturn(this.ruleInspectors);
        this.ruleInspector1 = this.mockRowInspector(1);
        this.ruleInspectors.add(this.ruleInspector1);
        this.ruleInspector2 = this.mockRowInspector(2);
        this.ruleInspectors.add(this.ruleInspector2);
        this.ruleInspector3 = this.mockRowInspector(3);
        this.ruleInspectors.add(this.ruleInspector3);
        this.checkRunner.addChecks(this.ruleInspector1.getChecks());
        this.checkRunner.addChecks(this.ruleInspector2.getChecks());
        this.checkRunner.addChecks(this.ruleInspector3.getChecks());
    }

    @Test
    public void testChecksGetGenerated() throws Exception {
        Assert.assertEquals((long)5L, (long)this.ruleInspector1.getChecks().size());
        Assert.assertEquals((long)5L, (long)this.ruleInspector2.getChecks().size());
        Assert.assertEquals((long)5L, (long)this.ruleInspector3.getChecks().size());
    }

    @Test
    public void testRemove() throws Exception {
        this.checkRunner.remove(this.ruleInspector2);
        Set checks = this.ruleInspector1.getChecks();
        Assert.assertEquals((long)3L, (long)checks.size());
        Assert.assertTrue((boolean)this.ruleInspector2.getChecks().isEmpty());
        Assert.assertEquals((long)3L, (long)this.ruleInspector3.getChecks().size());
    }

    @Test
    public void testRunTests() throws Exception {
        for (RuleInspector ruleInspector : this.cache.all()) {
            this.assertNoIssues(ruleInspector);
        }
        this.checkRunner.run(null, null);
        for (RuleInspector ruleInspector : this.cache.all()) {
            this.assertHasIssues(ruleInspector);
        }
    }

    @Test
    public void testOnlyTestChanges() throws Exception {
        this.checkRunner.run(null, null);
        RuleInspector newRuleInspector = this.mockRowInspector(3);
        this.ruleInspectors.add(newRuleInspector);
        this.checkRunner.addChecks(newRuleInspector.getChecks());
        this.assertNoIssues(newRuleInspector);
        this.checkRunner.run(null, null);
        this.assertHasIssues(newRuleInspector);
        Assert.assertEquals((long)7L, (long)this.ruleInspector1.getChecks().size());
        Assert.assertEquals((long)7L, (long)newRuleInspector.getChecks().size());
    }

    private RuleInspector mockRowInspector(int rowNumber) {
        return new RuleInspector(new Rule(Integer.valueOf(rowNumber)), this.checkManager, this.cache);
    }

    private void assertHasIssues(RuleInspector ruleInspector) {
        for (Check check : ruleInspector.getChecks()) {
            Assert.assertTrue((boolean)check.hasIssues());
        }
    }

    private void assertNoIssues(RuleInspector ruleInspector) {
        for (Check check : ruleInspector.getChecks()) {
            Assert.assertFalse((boolean)check.hasIssues());
        }
    }

    private class MockSingleCheck
    extends SingleCheck {
        int runCount;

        public MockSingleCheck(RuleInspector ruleInspector) {
            super(ruleInspector);
            this.runCount = 0;
        }

        public void check() {
            this.hasIssues = true;
        }

        public Issue getIssue() {
            return new Issue(Severity.NOTE, ++this.runCount + "", (ExplanationProvider)Mockito.mock(ExplanationProvider.class), new RuleInspector[0]);
        }
    }
}

