/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base;

import java.util.Collection;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.RuleInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.PairCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.PairChecks;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PairChecksTest {
    private PairChecks pairChecks;
    @Mock
    private RuleInspector a;
    @Mock
    private RuleInspector b;
    @Mock
    private RuleInspector c;
    private PairCheck pairCheckOne;
    private PairCheck pairCheckTwo;

    @Before
    public void setUp() throws Exception {
        this.pairChecks = new PairChecks();
        this.pairCheckOne = new PairCheck(this.a, this.b);
        this.pairChecks.add(this.pairCheckOne);
        this.pairCheckTwo = new PairCheck(this.b, this.a);
        this.pairChecks.add(this.pairCheckTwo);
        this.pairChecks.add(new PairCheck(this.a, this.c));
        this.pairChecks.add(new PairCheck(this.c, this.a));
    }

    @Test
    public void getA() throws Exception {
        Collection pairChecks = this.pairChecks.get(this.a);
        Assert.assertEquals((long)4L, (long)pairChecks.size());
        Assert.assertTrue((boolean)pairChecks.contains(this.pairCheckOne));
        Assert.assertTrue((boolean)pairChecks.contains(this.pairCheckTwo));
    }

    @Test
    public void getB() throws Exception {
        Collection pairChecks = this.pairChecks.get(this.b);
        Assert.assertEquals((long)2L, (long)pairChecks.size());
        Assert.assertTrue((boolean)pairChecks.contains(this.pairCheckOne));
        Assert.assertTrue((boolean)pairChecks.contains(this.pairCheckTwo));
    }

    @Test
    public void removeB() throws Exception {
        Collection pairChecks = this.pairChecks.remove(this.b);
        Assert.assertEquals((long)2L, (long)pairChecks.size());
        Assert.assertTrue((boolean)pairChecks.contains(this.pairCheckOne));
        Assert.assertTrue((boolean)pairChecks.contains(this.pairCheckTwo));
        Assert.assertTrue((boolean)this.pairChecks.get(this.b).isEmpty());
        Collection pairChecksForA = this.pairChecks.get(this.a);
        Assert.assertEquals((long)2L, (long)pairChecksForA.size());
        Assert.assertFalse((boolean)pairChecksForA.contains(this.pairCheckOne));
        Assert.assertFalse((boolean)pairChecksForA.contains(this.pairCheckTwo));
    }

    @Test
    public void removeA() throws Exception {
        Collection pairChecks = this.pairChecks.remove(this.a);
        Assert.assertEquals((long)4L, (long)pairChecks.size());
        Assert.assertTrue((boolean)this.pairChecks.get(this.a).isEmpty());
        Assert.assertTrue((boolean)this.pairChecks.get(this.b).isEmpty());
        Assert.assertTrue((boolean)this.pairChecks.get(this.c).isEmpty());
    }
}

