/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util;

import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasKeys;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasUUID;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.InspectorList;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsConflicting;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.RelationResolver;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Key;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.UUIDKey;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RelationResolverConflictsTest {
    private RelationResolver relationResolver;
    private InspectorList a;
    private InspectorList b;
    private Person isConflicting;
    private Person firstItemInA;

    @Before
    public void setUp() throws Exception {
        this.a = new InspectorList();
        this.b = new InspectorList();
        this.firstItemInA = (Person)Mockito.spy((Object)new Person(10));
        this.isConflicting = (Person)Mockito.spy((Object)new Person(15));
        this.a.add((HasUUID)this.firstItemInA);
        this.a.add((HasUUID)this.isConflicting);
        this.b.add((HasUUID)new Person(10));
        this.relationResolver = new RelationResolver(this.a, true);
    }

    @Test
    public void empty() throws Exception {
        this.relationResolver = new RelationResolver(new InspectorList());
        Assert.assertFalse((boolean)this.relationResolver.isConflicting(new InspectorList()));
    }

    @Test
    public void recheck() throws Exception {
        Assert.assertTrue((boolean)this.relationResolver.isConflicting(this.b));
        ((Person)Mockito.verify((Object)this.firstItemInA)).conflicts(Mockito.any());
        Mockito.reset((Object[])new Person[]{this.firstItemInA});
        Assert.assertTrue((boolean)this.relationResolver.isConflicting(this.b));
        ((Person)Mockito.verify((Object)this.firstItemInA, (VerificationMode)Mockito.never())).conflicts(Mockito.any());
    }

    @Test
    public void recheckWithUpdate() throws Exception {
        Assert.assertTrue((boolean)this.relationResolver.isConflicting(this.b));
        Mockito.reset((Object[])new Person[]{this.firstItemInA});
        this.isConflicting.setAge(10);
        Assert.assertFalse((boolean)this.relationResolver.isConflicting(this.b));
        ((Person)Mockito.verify((Object)this.firstItemInA)).conflicts(Mockito.any());
    }

    @Test
    public void recheckConflictingItemRemoved() throws Exception {
        Assert.assertTrue((boolean)this.relationResolver.isConflicting(this.b));
        Mockito.reset((Object[])new Person[]{this.firstItemInA});
        this.a.remove((Object)this.isConflicting);
        Assert.assertFalse((boolean)this.relationResolver.isConflicting(this.b));
        ((Person)Mockito.verify((Object)this.firstItemInA)).conflicts(Mockito.any());
    }

    @Test
    public void recheckOtherListBecomesEmpty() throws Exception {
        Assert.assertTrue((boolean)this.relationResolver.isConflicting(this.b));
        Mockito.reset((Object[])new Person[]{this.firstItemInA, this.isConflicting});
        this.b.clear();
        Assert.assertFalse((boolean)this.relationResolver.isConflicting(this.b));
        ((Person)Mockito.verify((Object)this.firstItemInA, (VerificationMode)Mockito.never())).conflicts(Mockito.any());
        ((Person)Mockito.verify((Object)this.isConflicting, (VerificationMode)Mockito.never())).conflicts(Mockito.any());
    }

    public class Person
    implements IsConflicting,
    HasKeys {
        int age;
        private UUIDKey uuidKey = new UUIDKey((HasKeys)this);

        public Person(int age) {
            this.age = age;
        }

        public UUIDKey getUuidKey() {
            return this.uuidKey;
        }

        public Key[] keys() {
            return new Key[]{this.uuidKey};
        }

        public void setAge(int age) {
            this.age = age;
        }

        public boolean conflicts(Object other) {
            if (other instanceof Person) {
                return this.age != ((Person)other).age;
            }
            return false;
        }
    }
}

