/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util;

import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasKeys;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasUUID;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.InspectorList;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsSubsuming;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.RelationResolver;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Key;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.UUIDKey;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RelationResolverSubsumptionTest {
    private RelationResolver relationResolver;
    private InspectorList a;
    private InspectorList b;
    private Person firstItemInB;
    private Person blockingItem;

    @Before
    public void setUp() throws Exception {
        this.a = new InspectorList();
        this.b = new InspectorList();
        this.a.add((HasUUID)new Person(15));
        this.firstItemInB = (Person)Mockito.spy((Object)new Person(15));
        this.b.add((HasUUID)this.firstItemInB);
        this.blockingItem = (Person)Mockito.spy((Object)new Person(10));
        this.b.add((HasUUID)this.blockingItem);
        this.relationResolver = new RelationResolver(this.a, true);
    }

    @Test
    public void empty() throws Exception {
        this.relationResolver = new RelationResolver(new InspectorList());
        Assert.assertTrue((boolean)this.relationResolver.subsumes(new InspectorList()));
    }

    @Test
    public void emptyListWithItemsSubsumesEmptyLists() throws Exception {
        Assert.assertTrue((boolean)this.relationResolver.subsumes(new InspectorList()));
    }

    @Test
    public void recheck() throws Exception {
        Assert.assertFalse((boolean)this.relationResolver.subsumes(this.b));
        ((Person)Mockito.verify((Object)this.firstItemInB)).subsumes(Mockito.any());
        Mockito.reset((Object[])new Person[]{this.firstItemInB});
        Assert.assertFalse((boolean)this.relationResolver.subsumes(this.b));
        ((Person)Mockito.verify((Object)this.firstItemInB, (VerificationMode)Mockito.never())).subsumes(Mockito.any());
    }

    @Test
    public void recheckWithUpdate() throws Exception {
        Assert.assertFalse((boolean)this.relationResolver.subsumes(this.b));
        Mockito.reset((Object[])new Person[]{this.firstItemInB});
        this.blockingItem.setAge(15);
        Assert.assertTrue((boolean)this.relationResolver.subsumes(this.b));
        ((Person)Mockito.verify((Object)this.firstItemInB)).subsumes(Mockito.any());
    }

    @Test
    public void recheckConflictingItemRemoved() throws Exception {
        Assert.assertFalse((boolean)this.relationResolver.subsumes(this.b));
        Mockito.reset((Object[])new Person[]{this.firstItemInB});
        this.b.remove((Object)this.blockingItem);
        Assert.assertTrue((boolean)this.relationResolver.subsumes(this.b));
        ((Person)Mockito.verify((Object)this.firstItemInB)).subsumes(Mockito.any());
    }

    @Test
    public void recheckOtherListBecomesEmpty() throws Exception {
        Assert.assertFalse((boolean)this.relationResolver.subsumes(this.b));
        Mockito.reset((Object[])new Person[]{this.firstItemInB, this.blockingItem});
        this.b.clear();
        Assert.assertTrue((boolean)this.relationResolver.subsumes(this.b));
        ((Person)Mockito.verify((Object)this.firstItemInB, (VerificationMode)Mockito.never())).subsumes(Mockito.any());
        ((Person)Mockito.verify((Object)this.blockingItem, (VerificationMode)Mockito.never())).subsumes(Mockito.any());
    }

    public class Person
    implements IsSubsuming,
    HasKeys {
        int age;
        private UUIDKey uuidKey = new UUIDKey((HasKeys)this);

        public Person(int age) {
            this.age = age;
        }

        public UUIDKey getUuidKey() {
            return this.uuidKey;
        }

        public Key[] keys() {
            return new Key[]{this.uuidKey};
        }

        public void setAge(int age) {
            this.age = age;
        }

        public boolean subsumes(Object other) {
            if (other instanceof Person) {
                return this.age == ((Person)other).age;
            }
            return false;
        }
    }
}

