/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.select;

import java.util.Collection;
import java.util.List;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.KeyDefinition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.MultiMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.MultiMapFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Value;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.matchers.ExactMatcher;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.matchers.Matcher;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.select.AllListener;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.select.FirstListener;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.select.LastListener;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.select.Listen;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ListenAddTest {
    private Listen<Person> listen;
    private MultiMap<Value, Person, List<Person>> map;
    private Collection<Person> all;
    private Person first;
    private Person last;

    @Before
    public void setUp() throws Exception {
        this.map = MultiMapFactory.make((boolean)true);
        this.map.put((Comparable)new Value((Comparable)Integer.valueOf(10)), (Object)new Person(10, "Toni"));
        this.map.put((Comparable)new Value((Comparable)Integer.valueOf(20)), (Object)new Person(20, "Eder"));
        this.listen = new Listen(this.map, (Matcher)new ExactMatcher(KeyDefinition.newKeyDefinition().withId("ID").build(), (Comparable)((Object)"notInTheList"), true));
        this.listen.all((AllListener)new AllListener<Person>(){

            public void onAllChanged(Collection<Person> all) {
                ListenAddTest.this.all = all;
            }
        });
        this.listen.first((FirstListener)new FirstListener<Person>(){

            public void onFirstChanged(Person first) {
                ListenAddTest.this.first = first;
            }
        });
        this.listen.last((LastListener)new LastListener<Person>(){

            public void onLastChanged(Person last) {
                ListenAddTest.this.last = last;
            }
        });
    }

    @Test
    public void testEmpty() throws Exception {
        Assert.assertNull(this.all);
        Assert.assertNull((Object)this.first);
        Assert.assertNull((Object)this.last);
    }

    @Test
    public void testBeginning() throws Exception {
        Person baby = new Person(0, "baby");
        this.map.put((Comparable)new Value((Comparable)Integer.valueOf(0)), (Object)baby);
        Assert.assertEquals((Object)baby, (Object)this.first);
        Assert.assertNull((Object)this.last);
        Assert.assertEquals((long)3L, (long)this.all.size());
    }

    @Test
    public void testEnd() throws Exception {
        Person grandpa = new Person(100, "grandpa");
        this.map.put((Comparable)new Value((Comparable)Integer.valueOf(100)), (Object)grandpa);
        Assert.assertNull((Object)this.first);
        Assert.assertEquals((Object)grandpa, (Object)this.last);
        Assert.assertEquals((long)3L, (long)this.all.size());
    }

    @Test
    public void testMiddle() throws Exception {
        this.map.put((Comparable)new Value((Comparable)Integer.valueOf(15)), (Object)new Person(15, "teenager"));
        Assert.assertNull((Object)this.first);
        Assert.assertNull((Object)this.last);
        Assert.assertEquals((long)3L, (long)this.all.size());
    }

    class Person {
        int age;
        String name;

        public Person(int age, String name) {
            this.age = age;
            this.name = name;
        }
    }
}

