/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel;

import com.google.gwt.view.client.ListDataProvider;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashSet;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.Status;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.RuleInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReport;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReportScreen;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReportScreenView;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.Util;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.ExplanationProvider;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Severity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.ClosePlaceEvent;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class AnalysisReportScreenTest {
    private AnalysisReportScreen screen;
    @Mock
    private AnalysisReportScreenView view;
    @Mock
    private PlaceManager placeManager;
    private ListDataProvider dataProvider;

    @Before
    public void setUp() throws Exception {
        this.screen = new AnalysisReportScreen(this.view, this.placeManager);
        ArgumentCaptor listDataProviderArgumentCaptor = ArgumentCaptor.forClass(ListDataProvider.class);
        ((AnalysisReportScreenView)Mockito.verify((Object)this.view)).setPresenter(this.screen);
        ((AnalysisReportScreenView)Mockito.verify((Object)this.view)).setUpDataProvider((ListDataProvider)listDataProviderArgumentCaptor.capture());
        this.dataProvider = (ListDataProvider)listDataProviderArgumentCaptor.getValue();
    }

    @Test
    public void testShowReport() throws Exception {
        Issue issue1 = new Issue(Severity.WARNING, "something", (ExplanationProvider)Mockito.mock(ExplanationProvider.class), new RuleInspector[0]);
        this.screen.showReport(this.getAnalysis(issue1));
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((String)Mockito.eq((Object)"org.drools.workbench.AnalysisReportScreen"));
        Assert.assertEquals((long)1L, (long)this.dataProvider.getList().size());
        Assert.assertTrue((boolean)this.dataProvider.getList().contains(issue1));
        Issue issue2 = new Issue(Severity.ERROR, "something else 1", (ExplanationProvider)Mockito.mock(ExplanationProvider.class), new RuleInspector[0]);
        Issue issue3 = new Issue(Severity.WARNING, "something else 2", (ExplanationProvider)Mockito.mock(ExplanationProvider.class), new RuleInspector[0]);
        this.screen.showReport(this.getAnalysis(issue2, issue3));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)2))).goTo((String)Mockito.eq((Object)"org.drools.workbench.AnalysisReportScreen"));
        ((AnalysisReportScreenView)Mockito.verify((Object)this.view)).showIssue(issue1);
        Assert.assertEquals((long)2L, (long)this.dataProvider.getList().size());
        Assert.assertFalse((boolean)this.dataProvider.getList().contains(issue1));
        Assert.assertTrue((boolean)this.dataProvider.getList().contains(issue2));
        Assert.assertTrue((boolean)this.dataProvider.getList().contains(issue3));
    }

    @Test
    public void testDoNotShowIfThereAreNoIssues() throws Exception {
        this.screen.showReport(this.getAnalysis(new Issue[0]));
        Assert.assertEquals((long)0L, (long)this.dataProvider.getList().size());
        ((AnalysisReportScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showIssue((Issue)Mockito.any(Issue.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo((String)Mockito.eq((Object)"org.drools.workbench.AnalysisReportScreen"));
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).closePlace((String)Mockito.eq((Object)"org.drools.workbench.AnalysisReportScreen"));
    }

    @Test
    public void testShowEverythingOnce() throws Exception {
        Issue issue2 = new Issue(Severity.WARNING, "we are one", (ExplanationProvider)Mockito.mock(ExplanationProvider.class), new RuleInspector[0]);
        Issue issue3 = new Issue(Severity.WARNING, "we are one", (ExplanationProvider)Mockito.mock(ExplanationProvider.class), new RuleInspector[0]);
        Issue issue4 = new Issue(Severity.WARNING, "we are one", (ExplanationProvider)Mockito.mock(ExplanationProvider.class), new RuleInspector[]{Util.getMockRuleInspector(1), Util.getMockRuleInspector(2), Util.getMockRuleInspector(3)});
        Issue issue5 = new Issue(Severity.WARNING, "we are one", (ExplanationProvider)Mockito.mock(ExplanationProvider.class), new RuleInspector[]{Util.getMockRuleInspector(1), Util.getMockRuleInspector(2), Util.getMockRuleInspector(3)});
        this.screen.showReport(this.getAnalysis(issue2, issue3, issue4, issue5));
        Assert.assertEquals((long)2L, (long)this.dataProvider.getList().size());
    }

    @Test
    public void testOnSelect() throws Exception {
        Issue issue1 = new Issue(Severity.WARNING, "something", (ExplanationProvider)Mockito.mock(ExplanationProvider.class), new RuleInspector[0]);
        Issue issue2 = new Issue(Severity.WARNING, "something else", (ExplanationProvider)Mockito.mock(ExplanationProvider.class), new RuleInspector[0]);
        this.screen.showReport(this.getAnalysis(issue1, issue2));
        this.screen.onSelect(issue2);
        ((AnalysisReportScreenView)Mockito.verify((Object)this.view)).showIssue(issue2);
    }

    @Test
    public void testDTableCloses() throws Exception {
        Issue issue1 = new Issue(Severity.WARNING, "something", (ExplanationProvider)Mockito.mock(ExplanationProvider.class), new RuleInspector[0]);
        PlaceRequest thisPlace = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        PlaceRequest someOtherPlace = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        this.screen.showReport(this.getAnalysis(thisPlace, issue1));
        ((AnalysisReportScreenView)Mockito.verify((Object)this.view)).showStatusComplete();
        ((AnalysisReportScreenView)Mockito.verify((Object)this.view)).showIssue(issue1);
        this.screen.onDTableClose(new ClosePlaceEvent(someOtherPlace));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).closePlace((String)Mockito.eq((Object)"org.drools.workbench.AnalysisReportScreen"));
        this.screen.onDTableClose(new ClosePlaceEvent(thisPlace));
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).closePlace((String)Mockito.eq((Object)"org.drools.workbench.AnalysisReportScreen"));
    }

    @Test
    public void testShowStatus() throws Exception {
        this.screen.showStatus(new Status(1, 2, 3));
        ((AnalysisReportScreenView)Mockito.verify((Object)this.view)).showStatusTitle(1, 2, 3);
    }

    @Test
    public void testDTableClosesWhenThereIsNoReport() throws Exception {
        this.screen.onDTableClose(new ClosePlaceEvent((PlaceRequest)Mockito.mock(PlaceRequest.class)));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).closePlace((String)Mockito.eq((Object)"org.drools.workbench.AnalysisReportScreen"));
    }

    @Test
    public void testNoIssuesShowNothing() throws Exception {
        this.screen.showReport(this.getAnalysis(new Issue[0]));
        ((AnalysisReportScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showIssue((Issue)Mockito.any(Issue.class));
        ((AnalysisReportScreenView)Mockito.verify((Object)this.view)).clearIssue();
    }

    private AnalysisReport getAnalysis(Issue ... issues) {
        return this.getAnalysis((PlaceRequest)Mockito.mock(PlaceRequest.class), issues);
    }

    private AnalysisReport getAnalysis(PlaceRequest place, Issue ... issues) {
        AnalysisReport report = new AnalysisReport(place);
        HashSet<Issue> unorderedIssues = new HashSet<Issue>();
        for (Issue issue : issues) {
            unorderedIssues.add(issue);
        }
        report.setIssues(unorderedIssues);
        return report;
    }
}

