/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel;

import com.google.gwt.safehtml.shared.SafeHtml;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.RuleInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.IssuePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.IssuePresenterView;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.Util;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Explanation;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.ExplanationProvider;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Severity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class IssuePresenterTest {
    private IssuePresenter screen;
    private IssuePresenterView view;

    @Before
    public void setUp() throws Exception {
        this.view = (IssuePresenterView)Mockito.mock(IssuePresenterView.class);
        this.screen = new IssuePresenter(this.view);
    }

    @Test
    public void testShow() throws Exception {
        Issue issue = new Issue(Severity.WARNING, "some title", new ExplanationProvider(){

            public SafeHtml toHTML() {
                return new Explanation().addParagraph("explanation").toHTML();
            }
        }, new RuleInspector[]{Util.getMockRuleInspector(0), Util.getMockRuleInspector(1), Util.getMockRuleInspector(2)});
        this.screen.show(issue);
        ((IssuePresenterView)Mockito.verify((Object)this.view)).setIssueTitle("some title");
        ArgumentCaptor safeHtmlArgumentCaptor = ArgumentCaptor.forClass(SafeHtml.class);
        ((IssuePresenterView)Mockito.verify((Object)this.view)).setExplanation((SafeHtml)safeHtmlArgumentCaptor.capture());
        Assert.assertEquals((Object)"<p>explanation</p>", (Object)((SafeHtml)safeHtmlArgumentCaptor.getValue()).asString());
        ((IssuePresenterView)Mockito.verify((Object)this.view)).setLines("1, 2, 3");
    }

    @Test
    public void testClear() throws Exception {
        this.screen.clear();
        ((IssuePresenterView)Mockito.verify((Object)this.view)).setIssueTitle("");
        ArgumentCaptor safeHtmlArgumentCaptor = ArgumentCaptor.forClass(SafeHtml.class);
        ((IssuePresenterView)Mockito.verify((Object)this.view)).setExplanation((SafeHtml)safeHtmlArgumentCaptor.capture());
        Assert.assertEquals((Object)"", (Object)((SafeHtml)safeHtmlArgumentCaptor.getValue()).asString());
        ((IssuePresenterView)Mockito.verify((Object)this.view)).hideLines();
        ((IssuePresenterView)Mockito.verify((Object)this.view)).setLines("");
    }
}

