/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil;

import java.util.HashMap;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.AnalysisReporter;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.CancellableRepeatingCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzer;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzerBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.Status;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.RuleInspectorCache;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.UpdateManager;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.CheckRunner;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReport;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReportScreen;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.testutil.AnalyzerBuilder;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Mockito;
import org.uberfire.mvp.PlaceRequest;

public class AnalyzerProvider {
    private final AsyncPackageDataModelOracle oracle;
    private AnalysisReport analysisReport;
    private Status status;

    public AnalyzerProvider() {
        this((AsyncPackageDataModelOracle)Mockito.mock(AsyncPackageDataModelOracle.class));
    }

    public AnalyzerProvider(AsyncPackageDataModelOracle oracle) {
        this.oracle = oracle;
        Mockito.when((Object)oracle.getFieldType("Person", "age")).thenReturn((Object)"Integer");
        Mockito.when((Object)oracle.getFieldType("Person", "name")).thenReturn((Object)"String");
        Mockito.when((Object)oracle.getFieldType("Person", "lastName")).thenReturn((Object)"String");
        Mockito.when((Object)oracle.getFieldType("Person", "description")).thenReturn((Object)"String");
        Mockito.when((Object)oracle.getFieldType("Account", "deposit")).thenReturn((Object)"Double");
        Mockito.when((Object)oracle.getFieldType("Person", "approved")).thenReturn((Object)"Boolean");
        Mockito.when((Object)oracle.getFieldType("Person", "salary")).thenReturn((Object)"Integer");
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("drools.dateformat", "dd-MMM-yyyy");
        ApplicationPreferences.setUp(preferences);
    }

    public AsyncPackageDataModelOracle getOracle() {
        return this.oracle;
    }

    public AnalysisReport getAnalysisReport() {
        return this.analysisReport;
    }

    public Status getStatus() {
        return this.status;
    }

    public DecisionTableAnalyzer getAnalyser(GuidedDecisionTable52 table52) {
        DecisionTableAnalyzerBuilder builder = this.getDecisionTableAnalyzerBuilder().withPlaceRequest((PlaceRequest)Mockito.mock(PlaceRequest.class)).withReportScreen((AnalysisReportScreen)Mockito.mock(AnalysisReportScreen.class)).withOracle(this.oracle).withModel(table52);
        return builder.build();
    }

    public RuleInspectorCache getCache(GuidedDecisionTable52 table52) {
        return this.getDecisionTableAnalyzerBuilder().withModel(table52).withOracle(this.oracle).getCacheBuilder().buildCache();
    }

    public UpdateManager getUpdateManager(CheckRunner checkRunner, GuidedDecisionTable52 table52) {
        return this.getDecisionTableAnalyzerBuilder().withModel(table52).withOracle(this.oracle).getUpdateManagerBuilder(checkRunner).buildUpdateManager();
    }

    private DecisionTableAnalyzerBuilder getDecisionTableAnalyzerBuilder() {
        return new DecisionTableAnalyzerBuilder(){

            protected DecisionTableAnalyzerBuilder.InnerBuilder getInnerBuilder() {
                return new DecisionTableAnalyzerBuilder.InnerBuilder(AnalyzerProvider.this.getCheckRunner()){

                    protected AnalysisReporter getAnalysisReporter() {
                        return AnalyzerProvider.this.getAnalysisReporter(placeRequest, analysisReportScreen);
                    }
                };
            }
        };
    }

    private AnalysisReporter getAnalysisReporter(PlaceRequest placeRequest, AnalysisReportScreen analysisReportScreen) {
        return new AnalysisReporter(placeRequest, analysisReportScreen){

            public void sendReport(AnalysisReport report) {
                AnalyzerProvider.this.analysisReport = report;
            }

            public void sendStatus(Status _status) {
                AnalyzerProvider.this.status = _status;
            }
        };
    }

    private CheckRunner getCheckRunner() {
        return new CheckRunner(){

            protected void doRun(CancellableRepeatingCommand command) {
                while (command.execute()) {
                }
            }
        };
    }

    public AnalyzerBuilder makeAnalyser() {
        return new AnalyzerBuilder(this);
    }

    public DecisionTableAnalyzer makeAnalyser(GuidedDecisionTable52 table52) {
        return this.getAnalyser(table52);
    }

    public void clearAnalysisReport() {
        this.analysisReport = null;
    }
}

