/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import org.drools.workbench.screens.guided.dtable.client.widget.table.BoundaryTransformMediator;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseBounds;

@RunWith(value=LienzoMockitoTestRunner.class)
public class BoundaryTransformMediatorTest {
    @Mock
    private GuidedDecisionTableModellerView view;
    private BoundaryTransformMediator restriction;
    private final Bounds bounds = new BaseBounds(-1000.0, -1000.0, 2000.0, 2000.0);

    @Before
    public void setup() {
        Mockito.when((Object)this.view.getBounds()).thenReturn((Object)this.bounds);
        this.restriction = new BoundaryTransformMediator(this.view);
        ((GuidedDecisionTableModellerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getBounds();
    }

    @Test
    public void testLeftEdge() {
        BaseBounds visibleBounds = new BaseBounds(-500.0, -500.0, 1000.0, 1000.0);
        Transform test = new Transform().translate(1200.0, 0.0);
        Transform result = this.restriction.adjust(test, (Bounds)visibleBounds);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)1000.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)result.getTranslateY(), (double)0.0);
        ((GuidedDecisionTableModellerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).getBounds();
    }

    @Test
    public void testRightEdge() {
        BaseBounds visibleBounds = new BaseBounds(-500.0, -500.0, 1000.0, 1000.0);
        Transform test = new Transform().translate(-200.0, 0.0);
        Transform result = this.restriction.adjust(test, (Bounds)visibleBounds);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)0.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)result.getTranslateY(), (double)0.0);
        ((GuidedDecisionTableModellerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).getBounds();
    }

    @Test
    public void testTopEdge() {
        BaseBounds visibleBounds = new BaseBounds(-500.0, -500.0, 1000.0, 1000.0);
        Transform test = new Transform().translate(0.0, 1200.0);
        Transform result = this.restriction.adjust(test, (Bounds)visibleBounds);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)0.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)1000.0, (double)result.getTranslateY(), (double)0.0);
        ((GuidedDecisionTableModellerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).getBounds();
    }

    @Test
    public void testBottomEdge() {
        BaseBounds visibleBounds = new BaseBounds(-500.0, -500.0, 1000.0, 1000.0);
        Transform test = new Transform().translate(0.0, -200.0);
        Transform result = this.restriction.adjust(test, (Bounds)visibleBounds);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)0.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)result.getTranslateY(), (double)0.0);
        ((GuidedDecisionTableModellerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).getBounds();
    }
}

