/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.dom.client.MouseDownHandler;
import java.util.HashSet;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.CellContextMenu;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.RowContextMenu;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerContextMenuSupport;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerPresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.GridColumnRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionStrategy;

@RunWith(value=LienzoMockitoTestRunner.class)
public class GuidedDecisionTableModellerContextMenuSupportTest {
    @Mock
    private CellContextMenu cellContextMenu;
    @Mock
    private RowContextMenu rowContextMenu;
    @Mock
    private GuidedDecisionTableModellerPresenter modellerPresenter;
    @Mock
    private BaseGridRendererHelper.ColumnInformation columnInformation;
    @Mock
    private ContextMenuEvent event;
    @Mock
    private NativeEvent nativeEvent;
    @Mock
    private Element element;
    @Mock
    private Document document;
    @Mock
    private Viewport viewport;
    @Mock
    private Layer layer;
    private GridData uiModel;
    private GuidedDecisionTableModellerContextMenuSupport contextMenuSupport;

    @Before
    public void setup() {
        this.uiModel = (GridData)Mockito.spy((Object)new BaseGridData());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.contextMenuSupport = new GuidedDecisionTableModellerContextMenuSupport(this.cellContextMenu, this.rowContextMenu);
        Mockito.when((Object)this.event.getNativeEvent()).thenReturn((Object)this.nativeEvent);
        Mockito.when((Object)this.event.getRelativeElement()).thenReturn((Object)this.element);
        Mockito.when((Object)this.element.getAbsoluteLeft()).thenReturn((Object)0);
        Mockito.when((Object)this.element.getScrollLeft()).thenReturn((Object)0);
        Mockito.when((Object)this.element.getAbsoluteTop()).thenReturn((Object)0);
        Mockito.when((Object)this.element.getScrollTop()).thenReturn((Object)0);
        Mockito.when((Object)this.element.getOwnerDocument()).thenReturn((Object)this.document);
        Mockito.when((Object)this.document.getScrollLeft()).thenReturn((Object)0);
        Mockito.when((Object)this.document.getScrollTop()).thenReturn((Object)0);
        Mockito.when((Object)this.nativeEvent.getShiftKey()).thenReturn((Object)false);
        Mockito.when((Object)this.nativeEvent.getCtrlKey()).thenReturn((Object)false);
        Mockito.when((Object)this.nativeEvent.getClientX()).thenReturn((Object)50);
        Mockito.when((Object)this.nativeEvent.getClientY()).thenReturn((Object)50);
        final GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable();
        Mockito.when((Object)this.modellerPresenter.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter);
            }
        });
    }

    @Test
    public void getContextMenuHandler() {
        ContextMenuHandler handler = this.contextMenuSupport.getContextMenuHandler((GuidedDecisionTableModellerView.Presenter)this.modellerPresenter);
        Assert.assertNotNull((Object)handler);
    }

    @Test
    public void getContextMenuMouseDownHandler() {
        MouseDownHandler handler = this.contextMenuSupport.getContextMenuMouseDownHandler();
        Assert.assertNotNull((Object)handler);
    }

    @Test
    public void onContextMenu_RowContextMenu() {
        RowNumberColumn uiColumn = new RowNumberColumn();
        this.uiModel.appendColumn((GridColumn)uiColumn);
        Mockito.when((Object)this.columnInformation.getColumn()).thenReturn((Object)uiColumn);
        ContextMenuHandler handler = this.contextMenuSupport.getContextMenuHandler((GuidedDecisionTableModellerView.Presenter)this.modellerPresenter);
        handler.onContextMenu(this.event);
        ((RowContextMenu)Mockito.verify((Object)this.rowContextMenu, (VerificationMode)Mockito.times((int)1))).show(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue());
        ((CellContextMenu)Mockito.verify((Object)this.cellContextMenu, (VerificationMode)Mockito.never())).show(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void onContextMenu_CellContextMenu() {
        BaseGridColumn uiColumn = new BaseGridColumn((GridColumn.HeaderMetaData)Mockito.mock(GridColumn.HeaderMetaData.class), (GridColumnRenderer)Mockito.mock(GridColumnRenderer.class), 100.0);
        this.uiModel.appendColumn((GridColumn)uiColumn);
        Mockito.when((Object)this.columnInformation.getColumn()).thenReturn((Object)uiColumn);
        ContextMenuHandler handler = this.contextMenuSupport.getContextMenuHandler((GuidedDecisionTableModellerView.Presenter)this.modellerPresenter);
        handler.onContextMenu(this.event);
        ((RowContextMenu)Mockito.verify((Object)this.rowContextMenu, (VerificationMode)Mockito.never())).show(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue());
        ((CellContextMenu)Mockito.verify((Object)this.cellContextMenu, (VerificationMode)Mockito.times((int)1))).show(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void onContextMenuWithCellSelectionManagerWithChangeInSelection() {
        GridCell uiCell = (GridCell)Mockito.mock(GridCell.class);
        RowNumberColumn uiColumn = new RowNumberColumn();
        CellSelectionStrategy cellSelectionStrategy = (CellSelectionStrategy)Mockito.mock(CellSelectionStrategy.class);
        this.uiModel.appendColumn((GridColumn)uiColumn);
        Mockito.when((Object)this.columnInformation.getColumn()).thenReturn((Object)uiColumn);
        Mockito.when((Object)this.uiModel.getCell(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue())).thenReturn((Object)uiCell);
        Mockito.when((Object)uiCell.getSelectionManager()).thenReturn((Object)cellSelectionStrategy);
        Mockito.when((Object)cellSelectionStrategy.handleSelection((GridData)Mockito.any(GridData.class), ((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue())).thenReturn((Object)true);
        ContextMenuHandler handler = this.contextMenuSupport.getContextMenuHandler((GuidedDecisionTableModellerView.Presenter)this.modellerPresenter);
        handler.onContextMenu(this.event);
        ((CellSelectionStrategy)Mockito.verify((Object)cellSelectionStrategy, (VerificationMode)Mockito.times((int)1))).handleSelection((GridData)Mockito.eq((Object)this.uiModel), Mockito.eq((int)0), Mockito.eq((int)0), Mockito.eq((boolean)false), Mockito.eq((boolean)false));
        ((Layer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).batch();
    }

    @Test
    public void onContextMenuWithCellSelectionManagerWithoutChangeInSelection() {
        GridCell uiCell = (GridCell)Mockito.mock(GridCell.class);
        RowNumberColumn uiColumn = new RowNumberColumn();
        CellSelectionStrategy cellSelectionStrategy = (CellSelectionStrategy)Mockito.mock(CellSelectionStrategy.class);
        this.uiModel.appendColumn((GridColumn)uiColumn);
        Mockito.when((Object)this.columnInformation.getColumn()).thenReturn((Object)uiColumn);
        Mockito.when((Object)this.uiModel.getCell(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue())).thenReturn((Object)uiCell);
        Mockito.when((Object)uiCell.getSelectionManager()).thenReturn((Object)cellSelectionStrategy);
        ContextMenuHandler handler = this.contextMenuSupport.getContextMenuHandler((GuidedDecisionTableModellerView.Presenter)this.modellerPresenter);
        handler.onContextMenu(this.event);
        ((CellSelectionStrategy)Mockito.verify((Object)cellSelectionStrategy, (VerificationMode)Mockito.times((int)1))).handleSelection((GridData)Mockito.eq((Object)this.uiModel), Mockito.eq((int)0), Mockito.eq((int)0), Mockito.eq((boolean)false), Mockito.eq((boolean)false));
        ((Layer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.never())).batch();
    }

    @Test
    public void onContextMenuWithoutCellSelectionManager() {
        RowNumberColumn uiColumn = new RowNumberColumn();
        this.uiModel.appendColumn((GridColumn)uiColumn);
        Mockito.when((Object)this.columnInformation.getColumn()).thenReturn((Object)uiColumn);
        GridCell uiCell = (GridCell)Mockito.mock(GridCell.class);
        Mockito.when((Object)this.uiModel.getCell(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue())).thenReturn((Object)uiCell);
        Mockito.when((Object)uiCell.getSelectionManager()).thenReturn(null);
        ContextMenuHandler handler = this.contextMenuSupport.getContextMenuHandler((GuidedDecisionTableModellerView.Presenter)this.modellerPresenter);
        handler.onContextMenu(this.event);
        ((Layer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.never())).batch();
    }

    private GuidedDecisionTableView.Presenter makeDecisionTable() {
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        GuidedDecisionTableView dtView = (GuidedDecisionTableView)Mockito.mock(GuidedDecisionTableView.class);
        GridRenderer renderer = (GridRenderer)Mockito.mock(GridRenderer.class);
        BaseGridRendererHelper helper = (BaseGridRendererHelper)Mockito.mock(BaseGridRendererHelper.class);
        Mockito.when((Object)dtPresenter.getView()).thenReturn((Object)dtView);
        Mockito.when((Object)dtPresenter.getAccess()).thenReturn(Mockito.mock(GuidedDecisionTablePresenter.Access.class));
        Mockito.when((Object)dtPresenter.getModel()).thenReturn(Mockito.mock(GuidedDecisionTable52.class));
        Mockito.when((Object)dtView.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)dtView.getLayer()).thenReturn((Object)this.layer);
        Mockito.when((Object)dtView.getLocation()).thenReturn((Object)new Point2D(0.0, 0.0));
        Mockito.when((Object)dtView.getWidth()).thenReturn((Object)50.0);
        Mockito.when((Object)dtView.getHeight()).thenReturn((Object)52.0);
        Mockito.when((Object)dtView.getModel()).thenReturn((Object)this.uiModel);
        Mockito.when((Object)dtView.getRenderer()).thenReturn((Object)renderer);
        Mockito.when((Object)renderer.getHeaderHeight()).thenReturn((Object)32.0);
        Mockito.when((Object)dtView.getRendererHelper()).thenReturn((Object)helper);
        Mockito.when((Object)helper.getColumnInformation(((Double)Mockito.any(Double.class)).doubleValue())).thenReturn((Object)this.columnInformation);
        return dtPresenter;
    }
}

