/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.linkmanager.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionSetField;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.BaseMultipleDOMElementUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.linkmanager.impl.DefaultGuidedDecisionTableLinkManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultGuidedDecisionTableLinkManagerTest {
    @Captor
    private ArgumentCaptor<GridData> sourceUiModelArgumentCaptor;
    @Captor
    private ArgumentCaptor<GridData> targetUiModelArgumentCaptor;
    @Captor
    private ArgumentCaptor<Integer> sourceColumnIndexArgumentCaptor;
    @Captor
    private ArgumentCaptor<Integer> targetColumnIndexArgumentCaptor;
    private DefaultGuidedDecisionTableLinkManager manager;

    @Before
    public void setup() {
        DefaultGuidedDecisionTableLinkManager wrapped = new DefaultGuidedDecisionTableLinkManager();
        this.manager = (DefaultGuidedDecisionTableLinkManager)Mockito.spy((Object)wrapped);
    }

    private GuidedDecisionTableView.Presenter makeGuidedDecisionTablePresenter() {
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        GuidedDecisionTableView dtPresenterView = (GuidedDecisionTableView)Mockito.mock(GuidedDecisionTableView.class);
        BaseGridData uiModel = new BaseGridData();
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        Mockito.when((Object)dtPresenter.getView()).thenReturn((Object)dtPresenterView);
        Mockito.when((Object)dtPresenterView.getModel()).thenReturn((Object)uiModel);
        Mockito.when((Object)dtPresenter.getModel()).thenReturn((Object)model);
        return dtPresenter;
    }

    @Test
    public void onlyOneDecisionTableThereforeNoLinks() {
        this.manager.link(this.makeGuidedDecisionTablePresenter(), Collections.emptySet());
        ((DefaultGuidedDecisionTableLinkManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.never())).linkColumns((GridData)Mockito.any(GridData.class), (GridData)Mockito.any(GridData.class), ((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void fieldConstraintLinksToActionUpdateField() {
        GuidedDecisionTableView.Presenter dtPresenter1 = this.makeGuidedDecisionTablePresenter();
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("$f");
        p1.setFactType("Fact");
        ConditionCol52 p1c1 = new ConditionCol52();
        p1c1.setFactField("field");
        p1.getChildColumns().add(p1c1);
        dtPresenter1.getModel().getConditions().add(p1);
        ActionSetFieldCol52 asf = new ActionSetFieldCol52();
        asf.setBoundName("$f");
        asf.setFactField("field");
        dtPresenter1.getModel().getActionCols().add(asf);
        final GuidedDecisionTableView.Presenter dtPresenter2 = this.makeGuidedDecisionTablePresenter();
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("$f");
        p2.setFactType("Fact");
        ConditionCol52 p2c1 = new ConditionCol52();
        p2c1.setFactField("field");
        p2.getChildColumns().add(p2c1);
        dtPresenter2.getModel().getConditions().add(p2);
        GridData dtPresenter1UiModel = dtPresenter1.getView().getModel();
        dtPresenter1UiModel.appendColumn((GridColumn)Mockito.mock(BaseMultipleDOMElementUiColumn.class));
        dtPresenter1UiModel.appendColumn((GridColumn)Mockito.mock(BaseMultipleDOMElementUiColumn.class));
        dtPresenter1UiModel.appendColumn((GridColumn)Mockito.mock(BaseMultipleDOMElementUiColumn.class));
        dtPresenter1UiModel.appendColumn((GridColumn)Mockito.mock(BaseMultipleDOMElementUiColumn.class));
        GridData dtPresenter2UiModel = dtPresenter2.getView().getModel();
        dtPresenter2UiModel.appendColumn((GridColumn)Mockito.mock(BaseMultipleDOMElementUiColumn.class));
        dtPresenter2UiModel.appendColumn((GridColumn)Mockito.mock(BaseMultipleDOMElementUiColumn.class));
        dtPresenter2UiModel.appendColumn((GridColumn)Mockito.mock(BaseMultipleDOMElementUiColumn.class));
        this.manager.link(dtPresenter1, (Set)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter2);
            }
        });
        ((DefaultGuidedDecisionTableLinkManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.times((int)1))).linkColumns((GridData)this.sourceUiModelArgumentCaptor.capture(), (GridData)this.targetUiModelArgumentCaptor.capture(), ((Integer)this.sourceColumnIndexArgumentCaptor.capture()).intValue(), ((Integer)this.targetColumnIndexArgumentCaptor.capture()).intValue());
        GridData sourceUiModel = (GridData)this.sourceUiModelArgumentCaptor.getValue();
        GridData targetUiModel = (GridData)this.targetUiModelArgumentCaptor.getValue();
        int sourceColumnIndex = (Integer)this.sourceColumnIndexArgumentCaptor.getValue();
        int targetColumnIndex = (Integer)this.targetColumnIndexArgumentCaptor.getValue();
        Assert.assertEquals((Object)dtPresenter1UiModel, (Object)sourceUiModel);
        Assert.assertEquals((Object)dtPresenter2UiModel, (Object)targetUiModel);
        Assert.assertEquals((long)3L, (long)sourceColumnIndex);
        Assert.assertEquals((long)2L, (long)targetColumnIndex);
    }

    @Test
    public void fieldConstraintLinksToActionInsertFactField() {
        GuidedDecisionTableView.Presenter dtPresenter1 = this.makeGuidedDecisionTablePresenter();
        ActionInsertFactCol52 aif = new ActionInsertFactCol52();
        aif.setFactType("Fact");
        aif.setFactField("field");
        dtPresenter1.getModel().getActionCols().add(aif);
        final GuidedDecisionTableView.Presenter dtPresenter2 = this.makeGuidedDecisionTablePresenter();
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("$f");
        p2.setFactType("Fact");
        ConditionCol52 p2c1 = new ConditionCol52();
        p2c1.setFactField("field");
        p2.getChildColumns().add(p2c1);
        dtPresenter2.getModel().getConditions().add(p2);
        GridData dtPresenter1UiModel = dtPresenter1.getView().getModel();
        dtPresenter1UiModel.appendColumn((GridColumn)Mockito.mock(BaseMultipleDOMElementUiColumn.class));
        dtPresenter1UiModel.appendColumn((GridColumn)Mockito.mock(BaseMultipleDOMElementUiColumn.class));
        dtPresenter1UiModel.appendColumn((GridColumn)Mockito.mock(BaseMultipleDOMElementUiColumn.class));
        GridData dtPresenter2UiModel = dtPresenter2.getView().getModel();
        dtPresenter2UiModel.appendColumn((GridColumn)Mockito.mock(BaseMultipleDOMElementUiColumn.class));
        dtPresenter2UiModel.appendColumn((GridColumn)Mockito.mock(BaseMultipleDOMElementUiColumn.class));
        dtPresenter2UiModel.appendColumn((GridColumn)Mockito.mock(BaseMultipleDOMElementUiColumn.class));
        this.manager.link(dtPresenter1, (Set)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter2);
            }
        });
        ((DefaultGuidedDecisionTableLinkManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.times((int)1))).linkColumns((GridData)this.sourceUiModelArgumentCaptor.capture(), (GridData)this.targetUiModelArgumentCaptor.capture(), ((Integer)this.sourceColumnIndexArgumentCaptor.capture()).intValue(), ((Integer)this.targetColumnIndexArgumentCaptor.capture()).intValue());
        GridData sourceUiModel = (GridData)this.sourceUiModelArgumentCaptor.getValue();
        GridData targetUiModel = (GridData)this.targetUiModelArgumentCaptor.getValue();
        int sourceColumnIndex = (Integer)this.sourceColumnIndexArgumentCaptor.getValue();
        int targetColumnIndex = (Integer)this.targetColumnIndexArgumentCaptor.getValue();
        Assert.assertEquals((Object)dtPresenter1UiModel, (Object)sourceUiModel);
        Assert.assertEquals((Object)dtPresenter2UiModel, (Object)targetUiModel);
        Assert.assertEquals((long)2L, (long)sourceColumnIndex);
        Assert.assertEquals((long)2L, (long)targetColumnIndex);
    }

    @Test
    public void fieldConstraintWithActionBRLFragmentFieldWithBoolean() {
        GuidedDecisionTableView.Presenter dtPresenter1 = this.makeGuidedDecisionTablePresenter();
        BRLActionColumn brl = new BRLActionColumn();
        final ActionSetField asf = new ActionSetField();
        asf.setVariable("$f");
        asf.addFieldValue(new ActionFieldValue(){
            {
                this.setField("field");
                this.setValue("10");
                this.setNature(1);
            }
        });
        brl.setDefinition((List)new ArrayList<IAction>(){
            {
                this.add(asf);
            }
        });
        brl.getChildColumns().add(new BRLActionVariableColumn("", "Boolean"));
        dtPresenter1.getModel().getActionCols().add(brl);
        final GuidedDecisionTableView.Presenter dtPresenter2 = this.makeGuidedDecisionTablePresenter();
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("$f");
        p2.setFactType("Fact");
        ConditionCol52 p2c1 = new ConditionCol52();
        p2c1.setFactField("field");
        p2.getChildColumns().add(p2c1);
        dtPresenter2.getModel().getConditions().add(p2);
        GridData dtPresenter1UiModel = dtPresenter1.getView().getModel();
        dtPresenter1UiModel.appendColumn((GridColumn)Mockito.mock(BaseMultipleDOMElementUiColumn.class));
        dtPresenter1UiModel.appendColumn((GridColumn)Mockito.mock(BaseMultipleDOMElementUiColumn.class));
        dtPresenter1UiModel.appendColumn((GridColumn)Mockito.mock(BaseMultipleDOMElementUiColumn.class));
        GridData dtPresenter2UiModel = dtPresenter2.getView().getModel();
        dtPresenter2UiModel.appendColumn((GridColumn)Mockito.mock(BaseMultipleDOMElementUiColumn.class));
        dtPresenter2UiModel.appendColumn((GridColumn)Mockito.mock(BaseMultipleDOMElementUiColumn.class));
        dtPresenter2UiModel.appendColumn((GridColumn)Mockito.mock(BaseMultipleDOMElementUiColumn.class));
        this.manager.link(dtPresenter1, (Set)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter2);
            }
        });
        ((DefaultGuidedDecisionTableLinkManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.never())).linkColumns((GridData)Mockito.any(GridData.class), (GridData)Mockito.any(GridData.class), ((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue());
    }
}

