/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.EditMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.InsertMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.RadarMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.ViewMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.type.GuidedDTableResourceType;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.AddDecisionTableToEditorEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorContent;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.kie.workbench.common.widgets.metadata.client.KieMultipleDocumentEditor;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="GuidedDecisionTableEditor", supportedTypes={GuidedDTableResourceType.class}, lockingStrategy=WorkbenchEditor.LockingStrategy.EDITOR_PROVIDED)
public class GuidedDecisionTableEditorPresenter
extends KieMultipleDocumentEditor<GuidedDecisionTableView.Presenter> {
    private View view;
    private Caller<GuidedDecisionTableEditorService> service;
    private Event<NotificationEvent> notification;
    private Event<DecisionTableSelectedEvent> decisionTableSelectedEvent;
    private GuidedDTableResourceType type;
    private EditMenuBuilder editMenuBuilder;
    private ViewMenuBuilder viewMenuBuilder;
    private InsertMenuBuilder insertMenuBuilder;
    private RadarMenuBuilder radarMenuBuilder;
    private GuidedDecisionTableModellerView.Presenter modeller;
    private ObservablePath rootPath;
    private PlaceRequest rootPlaceRequest;
    private MenuItem editMenuItem;
    private MenuItem viewMenuItem;
    private MenuItem insertMenuItem;
    private MenuItem radarMenuItem;
    private SyncBeanManager beanManager;
    private PlaceManager placeManager;

    @Inject
    public GuidedDecisionTableEditorPresenter(View view, Caller<GuidedDecisionTableEditorService> service, Event<NotificationEvent> notification, Event<DecisionTableSelectedEvent> decisionTableSelectedEvent, GuidedDTableResourceType type, EditMenuBuilder editMenuBuilder, ViewMenuBuilder viewMenuBuilder, InsertMenuBuilder insertMenuBuilder, RadarMenuBuilder radarMenuBuilder, GuidedDecisionTableModellerView.Presenter modeller, SyncBeanManager beanManager, PlaceManager placeManager) {
        super((KieEditorView)view);
        this.view = view;
        this.service = service;
        this.notification = notification;
        this.decisionTableSelectedEvent = decisionTableSelectedEvent;
        this.type = type;
        this.editMenuBuilder = editMenuBuilder;
        this.viewMenuBuilder = viewMenuBuilder;
        this.insertMenuBuilder = insertMenuBuilder;
        this.radarMenuBuilder = radarMenuBuilder;
        this.modeller = modeller;
        this.beanManager = beanManager;
        this.placeManager = placeManager;
    }

    @PostConstruct
    public void init() {
        this.viewMenuBuilder.setModeller(this.modeller);
        this.insertMenuBuilder.setModeller(this.modeller);
        this.radarMenuBuilder.setModeller(this.modeller);
        this.view.setModellerView(this.modeller.getView());
        this.registeredDocumentsMenuBuilder.setActivateDocumentCommand(document -> {
            GuidedDecisionTablePresenter dtPresenter = (GuidedDecisionTablePresenter)document;
            this.decisionTableSelectedEvent.fire((Object)new DecisionTableSelectedEvent(dtPresenter));
        });
        this.registeredDocumentsMenuBuilder.setRemoveDocumentCommand(document -> {
            GuidedDecisionTablePresenter dtPresenter = (GuidedDecisionTablePresenter)document;
            if (this.mayClose(dtPresenter)) {
                this.removeDocument(dtPresenter);
            }
        });
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest placeRequest) {
        this.loadDocument(path, placeRequest);
        this.rootPath = path;
        this.rootPlaceRequest = placeRequest;
    }

    void onAddDecisionTableToEditor(@Observes AddDecisionTableToEditorEvent event) {
        if (event == null) {
            return;
        }
        PathPlaceRequest existingEditorPlaceRequest = event.getExistingEditorPlaceRequest();
        ObservablePath newDecisionTablePath = event.getNewDecisionTablePath();
        if (existingEditorPlaceRequest == null) {
            return;
        }
        if (newDecisionTablePath == null) {
            return;
        }
        if (!existingEditorPlaceRequest.equals((Object)this.rootPlaceRequest)) {
            return;
        }
        this.loadDocument(newDecisionTablePath, (PlaceRequest)existingEditorPlaceRequest);
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return this.type.getDescription();
    }

    public String getDocumentTitle(GuidedDecisionTableView.Presenter dtPresenter) {
        return dtPresenter.getCurrentPath().getFileName() + " - " + this.type.getDescription();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitleWidget() {
        return null;
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return super.getMenus();
    }

    @OnMayClose
    public boolean mayClose() {
        for (GuidedDecisionTableView.Presenter dtPresenter : this.modeller.getAvailableDecisionTables()) {
            if (this.mayClose(dtPresenter)) continue;
            return false;
        }
        return true;
    }

    private boolean mayClose(GuidedDecisionTableView.Presenter dtPresenter) {
        Integer originalHashCode = dtPresenter.getOriginalHashCode();
        Integer currentHashCode = dtPresenter.getModel().hashCode();
        return this.mayClose(originalHashCode, currentHashCode);
    }

    @OnClose
    public void onClose() {
        this.modeller.onClose();
        super.onClose();
    }

    public void loadDocument(ObservablePath path, PlaceRequest placeRequest) {
        this.view.showLoading();
        ((GuidedDecisionTableEditorService)this.service.call(this.getLoadContentSuccessCallback(path, placeRequest), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)path);
    }

    private RemoteCallback<GuidedDecisionTableEditorContent> getLoadContentSuccessCallback(final ObservablePath path, final PlaceRequest placeRequest) {
        return new RemoteCallback<GuidedDecisionTableEditorContent>(){

            public void callback(GuidedDecisionTableEditorContent content) {
                if (path == null) {
                    return;
                }
                GuidedDecisionTableView.Presenter dtPresenter = GuidedDecisionTableEditorPresenter.this.modeller.addDecisionTable(path, placeRequest, content, placeRequest.getParameter("readOnly", null) != null);
                GuidedDecisionTableEditorPresenter.this.registerDocument(dtPresenter);
                GuidedDecisionTableEditorPresenter.this.decisionTableSelectedEvent.fire((Object)new DecisionTableSelectedEvent(dtPresenter));
                GuidedDecisionTableEditorPresenter.this.view.hideBusyIndicator();
            }
        };
    }

    void onDecisionTableSelected(@Observes DecisionTableSelectedEvent event) {
        GuidedDecisionTableView.Presenter dtPresenter = event.getPresenter();
        if (dtPresenter == null) {
            return;
        }
        if (!this.modeller.isDecisionTableAvailable(dtPresenter)) {
            return;
        }
        if (dtPresenter.equals(this.getActiveDocument())) {
            return;
        }
        this.activateDocument(dtPresenter);
    }

    private void activateDocument(GuidedDecisionTableView.Presenter dtPresenter) {
        this.enableMenus(true);
        dtPresenter.activate();
        this.activateDocument(dtPresenter, dtPresenter.getOverview(), dtPresenter.getDataModelOracle(), dtPresenter.getModel().getImports(), !dtPresenter.getAccess().isEditable());
    }

    public void refreshDocument(GuidedDecisionTableView.Presenter dtPresenter) {
        ObservablePath versionPath = dtPresenter.getCurrentPath();
        this.view.showLoading();
        ((GuidedDecisionTableEditorService)this.service.call(this.getRefreshContentSuccessCallback(dtPresenter), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)versionPath);
    }

    private RemoteCallback<GuidedDecisionTableEditorContent> getRefreshContentSuccessCallback(final GuidedDecisionTableView.Presenter dtPresenter) {
        final ObservablePath path = dtPresenter.getLatestPath();
        final PlaceRequest place = dtPresenter.getPlaceRequest();
        final boolean isReadOnly = dtPresenter.isReadOnly();
        return new RemoteCallback<GuidedDecisionTableEditorContent>(){

            public void callback(GuidedDecisionTableEditorContent content) {
                GuidedDecisionTableEditorPresenter.this.modeller.refreshDecisionTable(dtPresenter, path, place, content, isReadOnly);
                GuidedDecisionTableEditorPresenter.this.decisionTableSelectedEvent.fire((Object)new DecisionTableSelectedEvent(dtPresenter));
                GuidedDecisionTableEditorPresenter.this.view.hideBusyIndicator();
            }
        };
    }

    public void removeDocument(GuidedDecisionTableView.Presenter dtPresenter) {
        this.modeller.removeDecisionTable(dtPresenter);
        this.deregisterDocument(dtPresenter);
        dtPresenter.onClose();
        this.openOtherDecisionTable();
    }

    void openOtherDecisionTable() {
        Set<GuidedDecisionTableView.Presenter> availableDecisionTables = this.modeller.getAvailableDecisionTables();
        if (availableDecisionTables == null || availableDecisionTables.isEmpty()) {
            this.placeManager.forceClosePlace(this.rootPlaceRequest);
        } else {
            GuidedDecisionTableView.Presenter dtPresenter = availableDecisionTables.iterator().next();
            this.decisionTableSelectedEvent.fire((Object)new DecisionTableSelectedEvent(dtPresenter));
        }
    }

    public void onValidate(GuidedDecisionTableView.Presenter dtPresenter) {
        ObservablePath path = dtPresenter.getCurrentPath();
        GuidedDecisionTable52 model = dtPresenter.getModel();
        ((GuidedDecisionTableEditorService)this.service.call((RemoteCallback)new RemoteCallback<List<ValidationMessage>>(){

            public void callback(List<ValidationMessage> results) {
                if (results == null || results.isEmpty()) {
                    GuidedDecisionTableEditorPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemValidatedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
                } else {
                    ValidationPopup.showMessages(results);
                }
            }
        })).validate((Path)path, (Object)model);
    }

    public void onSave(GuidedDecisionTableView.Presenter dtPresenter, String commitMessage) {
        ObservablePath path = dtPresenter.getCurrentPath();
        GuidedDecisionTable52 model = dtPresenter.getModel();
        Metadata metadata = dtPresenter.getOverview().getMetadata();
        ((GuidedDecisionTableEditorService)this.service.call(this.getSaveSuccessCallback(dtPresenter, model.hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).save((Path)path, (Object)model, metadata, commitMessage);
    }

    public void onSourceTabSelected(GuidedDecisionTableView.Presenter dtPresenter) {
        ObservablePath path = dtPresenter.getCurrentPath();
        GuidedDecisionTable52 model = dtPresenter.getModel();
        ((GuidedDecisionTableEditorService)this.service.call((RemoteCallback)new RemoteCallback<String>(){

            public void callback(String source) {
                GuidedDecisionTableEditorPresenter.this.updateSource(source);
            }
        }, (ErrorCallback)this.getCouldNotGenerateSourceErrorCallback())).toSource((Path)path, (Object)model);
    }

    public void makeMenuBar() {
        this.menus = this.fileMenuBuilder.addSave(this.getSaveMenuItem()).addCopy(() -> ((GuidedDecisionTableView.Presenter)this.getActiveDocument()).getCurrentPath(), (Validator)this.fileNameValidator).addRename(() -> ((GuidedDecisionTableView.Presenter)this.getActiveDocument()).getLatestPath(), (Validator)this.fileNameValidator).addDelete(() -> ((GuidedDecisionTableView.Presenter)this.getActiveDocument()).getLatestPath()).addValidate(() -> this.onValidate((GuidedDecisionTableView.Presenter)this.getActiveDocument())).addNewTopLevelMenu(this.getEditMenuItem()).addNewTopLevelMenu(this.getViewMenuItem()).addNewTopLevelMenu(this.getInsertMenuItem()).addNewTopLevelMenu(this.getRadarMenuItem()).addNewTopLevelMenu(this.getRegisteredDocumentsMenuItem()).addNewTopLevelMenu(this.getVersionManagerMenuItem()).build();
    }

    private MenuItem getEditMenuItem() {
        if (this.editMenuItem == null) {
            this.editMenuItem = this.editMenuBuilder.build();
        }
        return this.editMenuItem;
    }

    private MenuItem getViewMenuItem() {
        if (this.viewMenuItem == null) {
            this.viewMenuItem = this.viewMenuBuilder.build();
        }
        return this.viewMenuItem;
    }

    private MenuItem getInsertMenuItem() {
        if (this.insertMenuItem == null) {
            this.insertMenuItem = this.insertMenuBuilder.build();
        }
        return this.insertMenuItem;
    }

    private MenuItem getRadarMenuItem() {
        if (this.radarMenuItem == null) {
            this.radarMenuItem = this.radarMenuBuilder.build();
        }
        return this.radarMenuItem;
    }

    protected void enableMenus(boolean enabled) {
        super.enableMenus(enabled);
        this.getEditMenuItem().setEnabled(enabled);
        this.getViewMenuItem().setEnabled(enabled);
        this.getInsertMenuItem().setEnabled(enabled);
        this.getRadarMenuItem().setEnabled(enabled);
    }

    public void getAvailableDocumentPaths(final Callback<List<Path>> callback) {
        this.view.showLoading();
        ((GuidedDecisionTableEditorService)this.service.call((RemoteCallback)new RemoteCallback<List<Path>>(){

            public void callback(List<Path> paths) {
                GuidedDecisionTableEditorPresenter.this.view.hideBusyIndicator();
                callback.callback(paths);
            }
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).listDecisionTablesInProject((Path)this.rootPath);
    }

    public void onOpenDocumentsInEditor(List<Path> selectedDocumentPaths) {
        for (Path path : selectedDocumentPaths) {
            ObservablePath oPath = (ObservablePath)this.beanManager.lookupBean(ObservablePath.class, new Annotation[0]).newInstance();
            this.loadDocument(oPath.wrap(path), this.rootPlaceRequest);
        }
    }

    public static interface View
    extends RequiresResize,
    ProvidesResize,
    KieEditorView,
    IsWidget {
        public void setModellerView(GuidedDecisionTableModellerView var1);
    }
}

