/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.menu;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DescriptionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.screens.guided.dtable.client.editor.clipboard.Clipboard;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.BaseMenu;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.EditMenuView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectionsChangedEvent;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@ApplicationScoped
public class EditMenuBuilder
extends BaseMenu
implements MenuFactory.CustomMenuBuilder,
EditMenuView.Presenter {
    private EditMenuView view;
    private Clipboard clipboard;

    @Inject
    public EditMenuBuilder(EditMenuView view, Clipboard clipboard) {
        this.view = view;
        this.clipboard = clipboard;
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
    }

    public void push(MenuFactory.CustomMenuBuilder element) {
    }

    public MenuItem build() {
        return new BaseMenuCustom<IsWidget>(){

            public IsWidget build() {
                return EditMenuBuilder.this.view;
            }

            public boolean isEnabled() {
                return EditMenuBuilder.this.view.isEnabled();
            }

            public void setEnabled(boolean enabled) {
                EditMenuBuilder.this.view.setEnabled(enabled);
            }
        };
    }

    @Override
    public void onDecisionTableSelectedEvent(@Observes DecisionTableSelectedEvent event) {
        super.onDecisionTableSelectedEvent(event);
    }

    @Override
    public void onDecisionTableSelectionsChangedEvent(@Observes DecisionTableSelectionsChangedEvent event) {
        super.onDecisionTableSelectionsChangedEvent(event);
    }

    @Override
    public void initialise() {
        if (this.activeDecisionTable == null || !this.activeDecisionTable.getAccess().isEditable()) {
            this.disableMenuItems();
            return;
        }
        List selections = this.activeDecisionTable.getView().getModel().getSelectedCells();
        if (selections == null || selections.isEmpty()) {
            this.disableMenuItems();
            return;
        }
        this.enableMenuItems(selections);
        this.setupOtherwiseCellEntry(selections);
    }

    @Override
    public void onCut() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onCut();
        }
    }

    @Override
    public void onCopy() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onCopy();
        }
    }

    @Override
    public void onPaste() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onPaste();
        }
    }

    @Override
    public void onDeleteSelectedCells() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onDeleteSelectedCells();
        }
    }

    @Override
    public void onDeleteSelectedColumns() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onDeleteSelectedColumns();
        }
    }

    @Override
    public void onDeleteSelectedRows() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onDeleteSelectedRows();
        }
    }

    @Override
    public void onOtherwiseCell() {
        if (this.activeDecisionTable != null) {
            this.view.setOtherwiseCell(true);
            this.activeDecisionTable.onOtherwiseCell();
        }
    }

    private void disableMenuItems() {
        this.view.enableCutMenuItem(false);
        this.view.enableCopyMenuItem(false);
        this.view.enablePasteMenuItem(false);
        this.view.enableDeleteCellMenuItem(false);
        this.view.enableDeleteColumnMenuItem(false);
        this.view.enableDeleteRowMenuItem(false);
        this.view.enableOtherwiseCellMenuItem(false);
    }

    private void enableMenuItems(List<GridData.SelectedCell> selections) {
        boolean enabled = selections.size() > 0;
        boolean isOtherwiseEnabled = this.isOtherwiseEnabled(selections);
        boolean isOnlyMandatoryColumnSelected = this.isOnlyMandatoryColumnSelected(selections);
        this.view.enableCutMenuItem(enabled);
        this.view.enableCopyMenuItem(enabled);
        this.view.enablePasteMenuItem(this.clipboard.hasData());
        this.view.enableDeleteCellMenuItem(enabled);
        this.view.enableDeleteColumnMenuItem(enabled && !isOnlyMandatoryColumnSelected);
        this.view.enableDeleteRowMenuItem(enabled);
        this.view.enableOtherwiseCellMenuItem(isOtherwiseEnabled);
    }

    private void setupOtherwiseCellEntry(List<GridData.SelectedCell> selections) {
        if (selections.size() != 1) {
            this.view.setOtherwiseCell(false);
            return;
        }
        GridData.SelectedCell selection = selections.get(0);
        int rowIndex = selection.getRowIndex();
        int columnIndex = this.findUiColumnIndex(selection.getColumnIndex());
        boolean isOtherwiseCell = ((DTCellValue52)((List)this.activeDecisionTable.getModel().getData().get(rowIndex)).get(columnIndex)).isOtherwise();
        this.view.setOtherwiseCell(isOtherwiseCell);
    }

    private boolean isOtherwiseEnabled(List<GridData.SelectedCell> selections) {
        if (selections.size() != 1) {
            return false;
        }
        boolean isOtherwiseEnabled = true;
        GridData.SelectedCell selection = selections.get(0);
        int columnIndex = this.findUiColumnIndex(selection.getColumnIndex());
        BaseColumn column = (BaseColumn)this.activeDecisionTable.getModel().getExpandedColumns().get(columnIndex);
        isOtherwiseEnabled = isOtherwiseEnabled && this.canAcceptOtherwiseValues(column);
        return isOtherwiseEnabled;
    }

    private boolean isOnlyMandatoryColumnSelected(List<GridData.SelectedCell> selections) {
        boolean isOnlyMandatoryColumnSelected = true;
        for (GridData.SelectedCell sc : selections) {
            int columnIndex = this.findUiColumnIndex(sc.getColumnIndex());
            BaseColumn column = (BaseColumn)this.activeDecisionTable.getModel().getExpandedColumns().get(columnIndex);
            if (column instanceof RowNumberCol52 || column instanceof DescriptionCol52) continue;
            isOnlyMandatoryColumnSelected = false;
        }
        return isOnlyMandatoryColumnSelected;
    }

    private int findUiColumnIndex(int modelColumnIndex) {
        List columns = this.activeDecisionTable.getView().getModel().getColumns();
        for (int uiColumnIndex = 0; uiColumnIndex < columns.size(); ++uiColumnIndex) {
            GridColumn c = (GridColumn)columns.get(uiColumnIndex);
            if (c.getIndex() != modelColumnIndex) continue;
            return uiColumnIndex;
        }
        throw new IllegalStateException("Column was not found!");
    }

    private boolean canAcceptOtherwiseValues(BaseColumn column) {
        if (!(column instanceof ConditionCol52)) {
            return false;
        }
        ConditionCol52 cc = (ConditionCol52)column;
        if (cc.getConstraintValueType() != 1) {
            return false;
        }
        if (cc.getOperator() == null) {
            return false;
        }
        if (cc.getOperator().equals("==")) {
            return true;
        }
        return cc.getOperator().equals("!=");
    }

    public static interface SupportsEditMenu {
        public void onCut();

        public void onCopy();

        public void onPaste();

        public void onDeleteSelectedCells();

        public void onDeleteSelectedColumns();

        public void onDeleteSelectedRows();

        public void onOtherwiseCell();
    }
}

