/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.menu;

import com.ait.lienzo.client.core.event.NodeDragMoveEvent;
import com.ait.lienzo.client.core.event.NodeDragMoveHandler;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.client.widget.DragConstraintEnforcer;
import com.ait.lienzo.client.widget.DragContext;
import com.ait.lienzo.client.widget.LienzoPanel;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.IColor;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.ButtonElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.RadarMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.RadarMenuView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;

@Dependent
@Templated
public class RadarMenuViewImpl
extends Composite
implements RadarMenuView {
    private static final int RADAR_WIDTH = 200;
    private static final int RADAR_HEIGHT = 200;
    private RadarMenuBuilder presenter;
    private TranslationService translationService;
    @DataField(value="radarMenuDropdown")
    ButtonElement radarMenuDropdown = Document.get().createPushButtonElement();
    @DataField(value="radarMenu")
    LIElement radarMenu = Document.get().createLIElement();
    @DataField(value="radarCanvas")
    LienzoPanel radarCanvas = new LienzoPanel(200, 200);
    Layer radarLayer = new Layer();
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private final Rectangle visibleBounds = new Rectangle(0.0, 0.0){

        public DragConstraintEnforcer getDragConstraints() {
            return new DragConstraintEnforcer(){
                private Point2D start;

                public void startDrag(DragContext dragContext) {
                    this.start = new Point2D(RadarMenuViewImpl.this.visibleBounds.getLocation());
                }

                public boolean adjust(Point2D dxy) {
                    boolean adjusted = false;
                    Point2D newPoint = new Point2D(this.start).add(dxy);
                    if (newPoint.getX() < RadarMenuViewImpl.this.minX) {
                        dxy.setX(RadarMenuViewImpl.this.minX - this.start.getX());
                        adjusted = true;
                    }
                    if (newPoint.getX() + RadarMenuViewImpl.this.visibleBounds.getWidth() > RadarMenuViewImpl.this.maxX) {
                        dxy.setX(RadarMenuViewImpl.this.maxX - this.start.getX() - RadarMenuViewImpl.this.visibleBounds.getWidth());
                        adjusted = true;
                    }
                    if (newPoint.getY() < RadarMenuViewImpl.this.minY) {
                        dxy.setY(RadarMenuViewImpl.this.minY - this.start.getY());
                        adjusted = true;
                    }
                    if (newPoint.getY() + RadarMenuViewImpl.this.visibleBounds.getHeight() > RadarMenuViewImpl.this.maxY) {
                        dxy.setY(RadarMenuViewImpl.this.maxY - this.start.getY() - RadarMenuViewImpl.this.visibleBounds.getHeight());
                        adjusted = true;
                    }
                    return adjusted;
                }
            };
        }
    };

    @Inject
    public RadarMenuViewImpl(TranslationService translationService) {
        this.translationService = translationService;
    }

    @PostConstruct
    public void setup() {
        this.radarCanvas.add(this.radarLayer);
        this.radarMenuDropdown.setTitle(this.translationService.getTranslation("RowContextMenuViewImpl.title"));
        this.visibleBounds.setDraggable(true);
        this.visibleBounds.addNodeDragMoveHandler(new NodeDragMoveHandler(){

            public void onNodeDragMove(NodeDragMoveEvent event) {
                RadarMenuViewImpl.this.presenter.onDragVisibleBounds(RadarMenuViewImpl.this.visibleBounds.getX(), RadarMenuViewImpl.this.visibleBounds.getY());
            }
        });
        this.visibleBounds.setFillColor((IColor)ColorName.GRAY);
        this.visibleBounds.setAlpha(0.25);
        this.visibleBounds.setLocation(new Point2D((200.0 - this.visibleBounds.getWidth()) / 2.0, (200.0 - this.visibleBounds.getHeight()) / 2.0));
        this.radarLayer.add((IPrimitive)this.visibleBounds);
        this.radarCanvas.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (this.eventTargetsPopup(event.getNativeEvent(), (Element)RadarMenuViewImpl.this.radarMenu)) {
                    event.stopPropagation();
                    event.preventDefault();
                }
            }

            private boolean eventTargetsPopup(NativeEvent event, Element element) {
                EventTarget target = event.getEventTarget();
                if (Element.is((JavaScriptObject)target)) {
                    return element.isOrHasChild((Node)Element.as((JavaScriptObject)target));
                }
                return false;
            }
        });
    }

    public void init(RadarMenuBuilder presenter) {
        this.presenter = presenter;
    }

    public boolean isEnabled() {
        return !this.radarMenuDropdown.isDisabled();
    }

    public void setEnabled(boolean enabled) {
        this.radarMenuDropdown.setDisabled(!enabled);
    }

    @Override
    public void reset() {
        this.radarLayer.removeAll();
    }

    @Override
    public void setModellerBounds(Bounds bounds) {
        this.minX = bounds.getX();
        this.maxX = this.minX + bounds.getWidth();
        this.minY = bounds.getY();
        this.maxY = this.minY + bounds.getHeight();
        this.radarLayer.getViewport().setTransform(this.getTransform(bounds));
    }

    @Override
    public void setAvailableDecisionTables(Set<GuidedDecisionTableView.Presenter> dtPresenters) {
        for (GuidedDecisionTableView.Presenter dtPresenter : dtPresenters) {
            GuidedDecisionTableView view = dtPresenter.getView();
            this.radarLayer.add((IPrimitive)this.makeDecisionTableGlyph(view));
        }
        this.radarLayer.batch();
    }

    private Transform getTransform(Bounds bounds) {
        Transform t = new Transform();
        t.scale(200.0 / bounds.getWidth(), 200.0 / bounds.getHeight()).translate(-bounds.getX(), -bounds.getY());
        return t;
    }

    private Group makeDecisionTableGlyph(GuidedDecisionTableView view) {
        Group g = new Group();
        Rectangle r = new Rectangle(view.getWidth(), view.getHeight());
        r.setFillColor((IColor)ColorName.LIGHTGRAY);
        r.setLocation(view.getLocation());
        g.setListening(false);
        g.add((IPrimitive)r);
        return g;
    }

    @Override
    public void setVisibleBounds(Bounds bounds) {
        this.radarLayer.remove((IPrimitive)this.visibleBounds);
        this.visibleBounds.setLocation(new Point2D(bounds.getX(), bounds.getY()));
        this.visibleBounds.setHeight(bounds.getHeight());
        this.visibleBounds.setWidth(bounds.getWidth());
        this.radarLayer.add((IPrimitive)this.visibleBounds);
        this.visibleBounds.moveToTop();
        this.radarLayer.batch();
    }

    @Override
    public void enableDrag(boolean enabled) {
        this.visibleBounds.setDraggable(enabled);
    }

    @EventHandler(value={"radarMenuDropdown"})
    public void onClickRadarMenuDropdown(ClickEvent e) {
        this.presenter.onClick();
    }
}

