/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.menu;

import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.BaseMenu;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.ViewMenuView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTablePinnedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@ApplicationScoped
public class ViewMenuBuilder
extends BaseMenu
implements MenuFactory.CustomMenuBuilder,
ViewMenuView.Presenter {
    private ViewMenuView view;
    private GuidedDecisionTableModellerView.Presenter modeller;

    @Inject
    public ViewMenuBuilder(ViewMenuView view) {
        this.view = view;
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
        this.view.setZoom125(false);
        this.view.setZoom100(true);
        this.view.setZoom75(false);
        this.view.setZoom50(false);
        this.view.enableToggleMergedStateMenuItem(false);
        this.view.enableViewAuditLogMenuItem(false);
    }

    @Override
    public void setModeller(GuidedDecisionTableModellerView.Presenter modeller) {
        this.modeller = modeller;
    }

    public void push(MenuFactory.CustomMenuBuilder element) {
    }

    public MenuItem build() {
        return new BaseMenuCustom<IsWidget>(){

            public IsWidget build() {
                return ViewMenuBuilder.this.view;
            }

            public boolean isEnabled() {
                return ViewMenuBuilder.this.view.isEnabled();
            }

            public void setEnabled(boolean enabled) {
                ViewMenuBuilder.this.view.setEnabled(enabled);
            }
        };
    }

    @Override
    public void onDecisionTableSelectedEvent(@Observes DecisionTableSelectedEvent event) {
        super.onDecisionTableSelectedEvent(event);
    }

    @Override
    public void initialise() {
        if (this.activeDecisionTable == null || !this.activeDecisionTable.getAccess().isEditable()) {
            this.view.enableToggleMergedStateMenuItem(false);
            this.view.enableViewAuditLogMenuItem(false);
            this.view.setMerged(false);
        } else {
            this.view.enableToggleMergedStateMenuItem(true);
            this.view.enableViewAuditLogMenuItem(true);
            this.view.setMerged(this.activeDecisionTable.isMerged());
        }
    }

    public void onDecisionTablePinnedEvent(@Observes DecisionTablePinnedEvent event) {
        GuidedDecisionTableModellerView.Presenter modeller = event.getPresenter();
        if (modeller == null) {
            return;
        }
        if (!modeller.equals(this.modeller)) {
            return;
        }
        this.view.enableZoom(!event.isPinned());
    }

    @Override
    public void onZoom(int zoom) {
        this.modeller.setZoom(zoom);
        this.view.setZoom125(false);
        this.view.setZoom100(false);
        this.view.setZoom75(false);
        this.view.setZoom50(false);
        switch (zoom) {
            case 125: {
                this.view.setZoom125(true);
                break;
            }
            case 100: {
                this.view.setZoom100(true);
                break;
            }
            case 75: {
                this.view.setZoom75(true);
                break;
            }
            case 50: {
                this.view.setZoom50(true);
            }
        }
    }

    @Override
    public void onToggleMergeState() {
        if (this.activeDecisionTable != null) {
            boolean newMergeState = !this.activeDecisionTable.isMerged();
            this.activeDecisionTable.setMerged(newMergeState);
            this.view.setMerged(newMergeState);
        }
    }

    @Override
    public void onViewAuditLog() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.showAuditLog();
        }
    }

    public static interface HasAuditLog {
        public void showAuditLog();
    }

    public static interface HasMergedView {
        public void setMerged(boolean var1);

        public boolean isMerged();
    }

    public static interface SupportsZoom {
        public void setZoom(int var1);
    }
}

