/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.handlers;

import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.handlers.GuidedDecisionTableOptions;
import org.drools.workbench.screens.guided.dtable.client.resources.GuidedDecisionTableResources;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.type.GuidedDTableResourceType;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.AddDecisionTableToEditorEvent;
import org.drools.workbench.screens.guided.dtable.client.wizard.NewGuidedDecisionTableWizard;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.kie.workbench.common.widgets.client.handlers.DefaultNewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class NewGuidedDecisionTableHandler
extends DefaultNewResourceHandler {
    private PlaceManager placeManager;
    private Caller<GuidedDecisionTableEditorService> service;
    private Event<AddDecisionTableToEditorEvent> addDecisionTableToEditorEvent;
    private GuidedDTableResourceType resourceType;
    private GuidedDecisionTableOptions options;
    private BusyIndicatorView busyIndicatorView;
    private AsyncPackageDataModelOracleFactory oracleFactory;
    private SyncBeanManager iocManager;
    private NewGuidedDecisionTableWizard wizard;
    private AsyncPackageDataModelOracle oracle;
    private NewResourcePresenter newResourcePresenter;

    public NewGuidedDecisionTableHandler() {
    }

    @Inject
    public NewGuidedDecisionTableHandler(PlaceManager placeManager, Caller<GuidedDecisionTableEditorService> service, Event<AddDecisionTableToEditorEvent> addDecisionTableToEditorEvent, GuidedDTableResourceType resourceType, GuidedDecisionTableOptions options, BusyIndicatorView busyIndicatorView, AsyncPackageDataModelOracleFactory oracleFactory, SyncBeanManager iocManager) {
        this.placeManager = placeManager;
        this.service = service;
        this.addDecisionTableToEditorEvent = addDecisionTableToEditorEvent;
        this.resourceType = resourceType;
        this.options = options;
        this.busyIndicatorView = busyIndicatorView;
        this.oracleFactory = oracleFactory;
        this.iocManager = iocManager;
    }

    @PostConstruct
    private void setupExtensions() {
        this.extensions.add(new Pair((Object)GuidedDecisionTableConstants.INSTANCE.Options(), (Object)this.options));
    }

    public String getDescription() {
        return GuidedDecisionTableConstants.INSTANCE.NewGuidedDecisionTableDescription();
    }

    public IsWidget getIcon() {
        return new Image(GuidedDecisionTableResources.INSTANCE.images().typeGuidedDecisionTable());
    }

    public List<Pair<String, ? extends IsWidget>> getExtensions() {
        boolean enableOpenInExistingEditor = this.getTargetEditorPlaceRequest() != null;
        this.options.enableOpenInExistingEditor(enableOpenInExistingEditor);
        this.options.setOpenInExistingEditor(false);
        return super.getExtensions();
    }

    public ResourceTypeDefinition getResourceType() {
        return this.resourceType;
    }

    public void create(Package pkg, String baseFileName, NewResourcePresenter presenter) {
        this.newResourcePresenter = presenter;
        if (!this.options.isUsingWizard()) {
            this.createEmptyDecisionTable(pkg.getPackageMainResourcesPath(), baseFileName, this.options.getTableFormat());
        } else {
            this.createDecisionTableWithWizard(pkg.getPackageMainResourcesPath(), baseFileName, this.options.getTableFormat());
        }
    }

    private void createEmptyDecisionTable(Path contextPath, String baseFileName, GuidedDecisionTable52.TableFormat tableFormat) {
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        model.setTableFormat(tableFormat);
        model.setTableName(baseFileName);
        this.save(contextPath, baseFileName, model);
    }

    private void createDecisionTableWithWizard(final Path contextPath, final String baseFileName, final GuidedDecisionTable52.TableFormat tableFormat) {
        ((GuidedDecisionTableEditorService)this.service.call((RemoteCallback)new RemoteCallback<PackageDataModelOracleBaselinePayload>(){

            public void callback(PackageDataModelOracleBaselinePayload dataModel) {
                NewGuidedDecisionTableHandler.this.newResourcePresenter.complete();
                NewGuidedDecisionTableHandler.this.oracle = NewGuidedDecisionTableHandler.this.oracleFactory.makeAsyncPackageDataModelOracle(contextPath, dataModel);
                NewGuidedDecisionTableHandler.this.wizard = (NewGuidedDecisionTableWizard)((Object)NewGuidedDecisionTableHandler.this.iocManager.lookupBean(NewGuidedDecisionTableWizard.class, new Annotation[0]).getInstance());
                NewGuidedDecisionTableHandler.this.wizard.setContent(contextPath, baseFileName, tableFormat, NewGuidedDecisionTableHandler.this.oracle, NewGuidedDecisionTableHandler.this);
                NewGuidedDecisionTableHandler.this.wizard.start();
            }
        })).loadDataModel(contextPath);
    }

    public void destroyWizard() {
        if (this.wizard != null) {
            this.iocManager.destroyBean((Object)this.wizard);
            this.wizard = null;
        }
    }

    public void save(Path contextPath, String baseFileName, GuidedDecisionTable52 model) {
        this.destroyWizard();
        this.oracleFactory.destroy(this.oracle);
        this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Saving());
        ((GuidedDecisionTableEditorService)this.service.call(this.getSuccessCallback(this.newResourcePresenter), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView))).create(contextPath, this.buildFileName(baseFileName, (ResourceTypeDefinition)this.resourceType), (Object)model, "");
    }

    protected RemoteCallback<Path> getSuccessCallback(final NewResourcePresenter presenter) {
        return new RemoteCallback<Path>(){

            public void callback(Path path) {
                NewGuidedDecisionTableHandler.this.busyIndicatorView.hideBusyIndicator();
                presenter.complete();
                NewGuidedDecisionTableHandler.this.notifySuccess();
                NewGuidedDecisionTableHandler.this.openInEditor(path);
            }
        };
    }

    private void openInEditor(Path path) {
        if (this.options.isOpenInExistingEditor()) {
            this.addDecisionTableToEditorEvent.fire((Object)new AddDecisionTableToEditorEvent(this.getTargetEditorPlaceRequest(), this.getObservablePath(path)));
        } else {
            this.placeManager.goTo(path);
        }
    }

    private PathPlaceRequest getTargetEditorPlaceRequest() {
        Collection openEditors = this.placeManager.getActivitiesForResourceType((ResourceTypeDefinition)this.resourceType);
        if (openEditors.size() != 1) {
            return null;
        }
        return (PathPlaceRequest)openEditors.iterator().next();
    }

    private ObservablePath getObservablePath(Path path) {
        ObservablePath observablePath = (ObservablePath)this.iocManager.lookupBean(ObservablePath.class, new Annotation[0]).getInstance();
        observablePath.wrap(path);
        return observablePath;
    }
}

