/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryCol;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.resources.images.GuidedDecisionTableImageResources508;
import org.drools.workbench.screens.guided.dtable.client.widget.ActionColumnCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.DTCellValueWidgetFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.ModalFooterChangePattern;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.CellUtilities;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.drools.workbench.screens.guided.rule.client.editor.BindingTextBox;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.ImageButton;
import org.uberfire.ext.widgets.common.client.common.InfoPopup;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class ActionInsertFactPopup
extends FormStylePopup {
    private SmallLabel patternLabel = new SmallLabel();
    private TextBox fieldLabel = this.getFieldLabel();
    private SimplePanel limitedEntryValueWidgetContainer = new SimplePanel();
    private int limitedEntryValueAttributeIndex = -1;
    private TextBox valueListWidget = null;
    private SimplePanel defaultValueWidgetContainer = new SimplePanel();
    private int defaultValueWidgetContainerIndex = -1;
    private final GuidedDecisionTable52 model;
    private final AsyncPackageDataModelOracle oracle;
    private final GuidedDecisionTableView.Presenter presenter;
    private final DTCellValueWidgetFactory factory;
    private final BRLRuleModel validator;
    private final CellUtilities cellUtilities;
    private final ColumnUtilities columnUtilities;
    private final ActionInsertFactCol52 editingCol;
    private final ActionColumnCommand refreshGrid;
    private final ActionInsertFactCol52 originalCol;
    private final boolean isNew;
    private final boolean isReadOnly;
    private final Command cmdOK = new Command(){

        public void execute() {
            ActionInsertFactPopup.this.applyChanges();
        }
    };
    private final Command cmdCancel = new Command(){

        public void execute() {
            ActionInsertFactPopup.this.hide();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.cmdOK, this.cmdCancel);

    public ActionInsertFactPopup(GuidedDecisionTable52 model, AsyncPackageDataModelOracle oracle, GuidedDecisionTableView.Presenter presenter, ActionColumnCommand refreshGrid, ActionInsertFactCol52 column, boolean isNew, boolean isReadOnly) {
        super(GuidedDecisionTableConstants.INSTANCE.ActionColumnConfigurationInsertingANewFact());
        this.validator = new BRLRuleModel(model);
        this.editingCol = this.cloneActionInsertColumn(column);
        this.model = model;
        this.oracle = oracle;
        this.presenter = presenter;
        this.refreshGrid = refreshGrid;
        this.originalCol = column;
        this.isNew = isNew;
        this.isReadOnly = isReadOnly;
        this.cellUtilities = new CellUtilities();
        this.columnUtilities = new ColumnUtilities(model, oracle);
        this.factory = DTCellValueWidgetFactory.getInstance(model, oracle, isReadOnly, this.allowEmptyValues());
        HorizontalPanel pattern = new HorizontalPanel();
        pattern.add((Widget)this.patternLabel);
        this.doPatternLabel();
        ImageButton changePattern = this.createChangePatternButton();
        changePattern.setEnabled(!isReadOnly);
        pattern.add((Widget)changePattern);
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.Pattern(), (IsWidget)pattern);
        HorizontalPanel field = new HorizontalPanel();
        this.fieldLabel.setEnabled(!isReadOnly);
        field.add((Widget)this.fieldLabel);
        ImageButton editField = this.createEditFieldButton();
        editField.setEnabled(!isReadOnly);
        field.add((Widget)editField);
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.Field() + ":", (IsWidget)field);
        this.doFieldLabel();
        final TextBox header = new TextBox();
        header.setText(column.getHeader());
        header.setEnabled(!isReadOnly);
        if (!isReadOnly) {
            header.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ActionInsertFactPopup.this.editingCol.setHeader(header.getText());
                }
            });
        }
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.ColumnHeaderDescription(), (IsWidget)header);
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY) {
            this.valueListWidget = new TextBox();
            this.valueListWidget.setText(this.editingCol.getValueList());
            this.valueListWidget.setEnabled(!isReadOnly);
            if (!isReadOnly) {
                this.valueListWidget.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        ActionInsertFactPopup.this.editingCol.setValueList(ActionInsertFactPopup.this.valueListWidget.getText());
                    }
                });
                this.valueListWidget.addBlurHandler(new BlurHandler(){

                    public void onBlur(BlurEvent event) {
                        this.assertDefaultValue();
                        ActionInsertFactPopup.this.makeDefaultValueWidget();
                    }

                    private void assertDefaultValue() {
                        List<String> valueList = Arrays.asList(ActionInsertFactPopup.this.columnUtilities.getValueList((BaseColumn)ActionInsertFactPopup.this.editingCol));
                        if (valueList.size() > 0) {
                            String defaultValue = ActionInsertFactPopup.this.cellUtilities.asString(ActionInsertFactPopup.this.editingCol.getDefaultValue());
                            if (!valueList.contains(defaultValue)) {
                                ActionInsertFactPopup.this.editingCol.getDefaultValue().clearValues();
                            }
                        } else {
                            DTCellValue52 defaultValue = ActionInsertFactPopup.this.editingCol.getDefaultValue();
                            DataType.DataTypes dataType = ActionInsertFactPopup.this.columnUtilities.getDataType((BaseColumn)ActionInsertFactPopup.this.editingCol);
                            ActionInsertFactPopup.this.cellUtilities.convertDTCellValueType(dataType, defaultValue);
                        }
                    }
                });
            }
            HorizontalPanel vl = new HorizontalPanel();
            vl.add((Widget)this.valueListWidget);
            vl.add((IsWidget)new InfoPopup(GuidedDecisionTableConstants.INSTANCE.ValueList(), GuidedDecisionTableConstants.INSTANCE.ValueListsExplanation()));
            this.addAttribute(GuidedDecisionTableConstants.INSTANCE.optionalValueList(), (IsWidget)vl);
        }
        this.doValueList();
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY) {
            this.defaultValueWidgetContainerIndex = this.addAttribute(GuidedDecisionTableConstants.INSTANCE.DefaultValue() + ":", (IsWidget)this.defaultValueWidgetContainer).getIndex();
            this.makeDefaultValueWidget();
        }
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            this.limitedEntryValueAttributeIndex = this.addAttribute(GuidedDecisionTableConstants.INSTANCE.LimitedEntryValue(), (IsWidget)this.limitedEntryValueWidgetContainer).getIndex();
            this.makeLimitedValueWidget();
        }
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.LogicallyInsert() + ":", (IsWidget)this.doInsertLogical());
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.HideThisColumn() + ":", (IsWidget)DTCellValueWidgetFactory.getHideColumnIndicator((DTColumnConfig52)this.editingCol));
        this.footer.enableOkButton(!isReadOnly);
        this.add((Widget)this.footer);
    }

    private void applyChanges() {
        if (!this.isValidFactType()) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.YouMustEnterAColumnPattern());
            return;
        }
        if (!this.isValidFactField()) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.YouMustEnterAColumnField());
            return;
        }
        if (null == this.editingCol.getHeader() || "".equals(this.editingCol.getHeader())) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.YouMustEnterAColumnHeaderValueDescription());
            return;
        }
        if (this.isNew) {
            if (!this.unique(this.editingCol.getHeader())) {
                Window.alert((String)GuidedDecisionTableConstants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
                return;
            }
        } else if (!this.originalCol.getHeader().equals(this.editingCol.getHeader()) && !this.unique(this.editingCol.getHeader())) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
            return;
        }
        this.refreshGrid.execute((ActionCol52)this.editingCol);
        this.hide();
    }

    private ImageButton createEditFieldButton() {
        Image edit = GuidedDecisionTableImageResources508.INSTANCE.Edit();
        edit.setAltText(GuidedDecisionTableConstants.INSTANCE.EditTheFieldThatThisColumnOperatesOn());
        Image editDisabled = GuidedDecisionTableImageResources508.INSTANCE.EditDisabled();
        editDisabled.setAltText(GuidedDecisionTableConstants.INSTANCE.EditTheFieldThatThisColumnOperatesOn());
        return new ImageButton(edit, editDisabled, GuidedDecisionTableConstants.INSTANCE.EditTheFieldThatThisColumnOperatesOn(), new ClickHandler(){

            public void onClick(ClickEvent w) {
                ActionInsertFactPopup.this.showFieldChange();
            }
        });
    }

    private ImageButton createChangePatternButton() {
        Image edit = GuidedDecisionTableImageResources508.INSTANCE.Edit();
        edit.setAltText(GuidedDecisionTableConstants.INSTANCE.ChooseAPatternThatThisColumnAddsDataTo());
        Image editDisabled = GuidedDecisionTableImageResources508.INSTANCE.EditDisabled();
        editDisabled.setAltText(GuidedDecisionTableConstants.INSTANCE.ChooseAPatternThatThisColumnAddsDataTo());
        return new ImageButton(edit, editDisabled, GuidedDecisionTableConstants.INSTANCE.ChooseAPatternThatThisColumnAddsDataTo(), new ClickHandler(){

            public void onClick(ClickEvent w) {
                ActionInsertFactPopup.this.showChangePattern(w);
            }
        });
    }

    private boolean allowEmptyValues() {
        return this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY;
    }

    private ActionInsertFactCol52 cloneActionInsertColumn(ActionInsertFactCol52 col) {
        LimitedEntryActionInsertFactCol52 clone = null;
        if (col instanceof LimitedEntryActionInsertFactCol52) {
            clone = new LimitedEntryActionInsertFactCol52();
            DTCellValue52 dcv = this.cloneDTCellValue(((LimitedEntryCol)col).getValue());
            ((LimitedEntryCol)clone).setValue(dcv);
        } else {
            clone = new ActionInsertFactCol52();
        }
        clone.setBoundName(col.getBoundName());
        clone.setType(col.getType());
        clone.setFactField(col.getFactField());
        clone.setFactType(col.getFactType());
        clone.setHeader(col.getHeader());
        clone.setValueList(col.getValueList());
        clone.setDefaultValue(this.cloneDTCellValue(col.getDefaultValue()));
        clone.setHideColumn(col.isHideColumn());
        clone.setInsertLogical(col.isInsertLogical());
        return clone;
    }

    private DTCellValue52 cloneDTCellValue(DTCellValue52 dcv) {
        if (dcv == null) {
            return null;
        }
        DTCellValue52 clone = new DTCellValue52(dcv);
        return clone;
    }

    private void makeLimitedValueWidget() {
        if (!(this.editingCol instanceof LimitedEntryActionInsertFactCol52)) {
            return;
        }
        if (this.nil(this.editingCol.getFactField())) {
            this.setAttributeVisibility(this.limitedEntryValueAttributeIndex, false);
            return;
        }
        LimitedEntryActionInsertFactCol52 lea = (LimitedEntryActionInsertFactCol52)this.editingCol;
        this.setAttributeVisibility(this.limitedEntryValueAttributeIndex, true);
        if (lea.getValue() == null) {
            lea.setValue(this.factory.makeNewValue((DTColumnConfig52)this.editingCol));
        }
        this.limitedEntryValueWidgetContainer.setWidget(this.factory.getWidget(this.editingCol, lea.getValue()));
    }

    private void makeDefaultValueWidget() {
        if (this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            return;
        }
        if (this.nil(this.editingCol.getFactField())) {
            this.setAttributeVisibility(this.defaultValueWidgetContainerIndex, false);
            return;
        }
        this.setAttributeVisibility(this.defaultValueWidgetContainerIndex, true);
        if (this.editingCol.getDefaultValue() == null) {
            this.editingCol.setDefaultValue(this.factory.makeNewValue((DTColumnConfig52)this.editingCol));
        }
        DTCellValue52 defaultValue = this.editingCol.getDefaultValue();
        DataType.DataTypes dataType = this.columnUtilities.getDataType((BaseColumn)this.editingCol);
        this.cellUtilities.convertDTCellValueType(dataType, defaultValue);
        this.defaultValueWidgetContainer.setWidget(this.factory.getWidget(this.editingCol, defaultValue));
    }

    void doFieldLabel() {
        if (!this.nil(this.editingCol.getFactField())) {
            this.setFieldLabelToFieldName(this.editingCol.getFactField());
        } else if (!this.nil(this.editingCol.getBoundName())) {
            this.setFieldLabelPleaseSelectAField();
        } else {
            this.setFieldLabelPleaseChooseFactType();
        }
    }

    void setFieldLabelToFieldName(String fieldName) {
        this.fieldLabel.setText(fieldName);
    }

    void setFieldLabelPleaseSelectAField() {
        this.fieldLabel.setText(GuidedDecisionTableConstants.INSTANCE.pleaseSelectAField());
    }

    void setFieldLabelPleaseChooseFactType() {
        this.fieldLabel.setText(GuidedDecisionTableConstants.INSTANCE.pleaseChooseFactType());
    }

    private void doPatternLabel() {
        if (this.editingCol.getFactType() != null) {
            this.patternLabel.setText(this.editingCol.getFactType() + " [" + this.editingCol.getBoundName() + "]");
        }
    }

    private void doValueList() {
        boolean enableValueList;
        if (this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            return;
        }
        String factType = this.editingCol.getFactType();
        String factField = this.editingCol.getFactField();
        boolean bl = enableValueList = !this.isReadOnly && factType != null && !"".equals(factType) && factField != null && !"".equals(factField);
        if (enableValueList) {
            enableValueList = !this.oracle.hasEnums(factType, factField);
        }
        this.valueListWidget.setEnabled(enableValueList);
        if (!enableValueList) {
            this.valueListWidget.setText("");
        }
    }

    private TextBox getFieldLabel() {
        final TextBox box = new TextBox();
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ActionInsertFactPopup.this.editingCol.setFactField(box.getText());
            }
        });
        return box;
    }

    private ListBox loadPatterns() {
        HashSet<String> vars = new HashSet<String>();
        ListBox patterns = new ListBox();
        for (Object o : this.model.getActionCols()) {
            ActionInsertFactCol52 c;
            ActionCol52 col = (ActionCol52)o;
            if (!(col instanceof ActionInsertFactCol52) || vars.contains((c = (ActionInsertFactCol52)col).getBoundName())) continue;
            patterns.addItem(c.getFactType() + " [" + c.getBoundName() + "]", c.getFactType() + " " + c.getBoundName());
            vars.add(c.getBoundName());
        }
        return patterns;
    }

    private boolean nil(String s) {
        return s == null || s.equals("");
    }

    private void showFieldChange() {
        final FormStylePopup pop = new FormStylePopup(GuidedDecisionTableConstants.INSTANCE.Field());
        final ListBox box = new ListBox();
        this.oracle.getFieldCompletions(this.editingCol.getFactType(), FieldAccessorsAndMutators.MUTATOR, (Callback)new Callback<ModelField[]>(){

            public void callback(ModelField[] fields) {
                for (int i = 0; i < fields.length; ++i) {
                    box.addItem(fields[i].getName());
                }
            }
        });
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.Field() + ":", (IsWidget)box);
        pop.add((Widget)new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                ActionInsertFactPopup.this.editingCol.setFactField(box.getItemText(box.getSelectedIndex()));
                ActionInsertFactPopup.this.editingCol.setType(ActionInsertFactPopup.this.oracle.getFieldType(ActionInsertFactPopup.this.editingCol.getFactType(), ActionInsertFactPopup.this.editingCol.getFactField()));
                ActionInsertFactPopup.this.makeLimitedValueWidget();
                ActionInsertFactPopup.this.makeDefaultValueWidget();
                ActionInsertFactPopup.this.doValueList();
                ActionInsertFactPopup.this.doFieldLabel();
                pop.hide();
                ActionInsertFactPopup.this.enableFooter(true);
            }
        }, new Command(){

            public void execute() {
                pop.hide();
                ActionInsertFactPopup.this.enableFooter(true);
            }
        }));
        this.enableFooter(false);
        pop.show();
    }

    private boolean unique(String header) {
        for (ActionCol52 o : this.model.getActionCols()) {
            if (!o.getHeader().equals(header)) continue;
            return false;
        }
        return true;
    }

    protected void showChangePattern(ClickEvent w) {
        final ListBox pats = this.loadPatterns();
        if (pats.getItemCount() == 0) {
            this.showNewPatternDialog();
            return;
        }
        final FormStylePopup pop = new FormStylePopup(GuidedDecisionTableConstants.INSTANCE.FactType());
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.ChooseExistingPatternToAddColumnTo(), (IsWidget)pats);
        pop.add((Widget)new ModalFooterChangePattern(new Command(){

            public void execute() {
                String[] val = pats.getValue(pats.getSelectedIndex()).split("\\s");
                ActionInsertFactPopup.this.editingCol.setFactType(val[0]);
                ActionInsertFactPopup.this.editingCol.setBoundName(val[1]);
                ActionInsertFactPopup.this.editingCol.setFactField(null);
                ActionInsertFactPopup.this.makeLimitedValueWidget();
                ActionInsertFactPopup.this.makeDefaultValueWidget();
                ActionInsertFactPopup.this.doPatternLabel();
                ActionInsertFactPopup.this.doFieldLabel();
                ActionInsertFactPopup.this.doValueList();
                pop.hide();
                ActionInsertFactPopup.this.enableFooter(true);
            }
        }, new Command(){

            public void execute() {
                pop.hide();
                ActionInsertFactPopup.this.showNewPatternDialog();
            }
        }, new Command(){

            public void execute() {
                pop.hide();
                ActionInsertFactPopup.this.enableFooter(true);
            }
        }));
        this.enableFooter(false);
        pop.show();
    }

    protected void showNewPatternDialog() {
        final FormStylePopup pop = new FormStylePopup(GuidedDecisionTableConstants.INSTANCE.FactType());
        pop.setTitle(GuidedDecisionTableConstants.INSTANCE.NewFactSelectTheType());
        final ListBox types = new ListBox();
        for (int i = 0; i < this.oracle.getFactTypes().length; ++i) {
            types.addItem(this.oracle.getFactTypes()[i]);
        }
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.FactType(), (IsWidget)types);
        BindingTextBox binding = new BindingTextBox();
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.Binding() + ":", (IsWidget)binding);
        pop.add((Widget)new ModalFooterOKCancelButtons(new Command((TextBox)binding, pop){
            final /* synthetic */ TextBox val$binding;
            final /* synthetic */ FormStylePopup val$pop;
            {
                this.val$binding = textBox;
                this.val$pop = formStylePopup;
            }

            public void execute() {
                String ft = types.getItemText(types.getSelectedIndex());
                String fn = this.val$binding.getText();
                if (fn.equals("")) {
                    Window.alert((String)GuidedDecisionTableConstants.INSTANCE.PleaseEnterANameForFact());
                    return;
                }
                if (fn.equals(ft)) {
                    Window.alert((String)GuidedDecisionTableConstants.INSTANCE.PleaseEnterANameThatIsNotTheSameAsTheFactType());
                    return;
                }
                if (!ActionInsertFactPopup.this.isBindingUnique(fn)) {
                    Window.alert((String)GuidedDecisionTableConstants.INSTANCE.PleaseEnterANameThatIsNotAlreadyUsedByAnotherPattern());
                    return;
                }
                ActionInsertFactPopup.this.editingCol.setBoundName(this.val$binding.getText());
                ActionInsertFactPopup.this.editingCol.setFactType(types.getItemText(types.getSelectedIndex()));
                ActionInsertFactPopup.this.editingCol.setFactField(null);
                ActionInsertFactPopup.this.makeLimitedValueWidget();
                ActionInsertFactPopup.this.makeDefaultValueWidget();
                ActionInsertFactPopup.this.doPatternLabel();
                ActionInsertFactPopup.this.doFieldLabel();
                ActionInsertFactPopup.this.doValueList();
                this.val$pop.hide();
                ActionInsertFactPopup.this.enableFooter(true);
            }
        }, new Command(){

            public void execute() {
                pop.hide();
                ActionInsertFactPopup.this.enableFooter(true);
            }
        }));
        this.enableFooter(false);
        pop.show();
    }

    private boolean isBindingUnique(String binding) {
        return !this.validator.isVariableNameUsed(binding);
    }

    private boolean isValidFactType() {
        return this.editingCol.getFactType() != null && !"".equals(this.editingCol.getFactType());
    }

    private boolean isValidFactField() {
        return this.editingCol.getFactField() != null && !"".equals(this.editingCol.getFactField());
    }

    private Widget doInsertLogical() {
        HorizontalPanel hp = new HorizontalPanel();
        final CheckBox cb = new CheckBox();
        cb.setValue(Boolean.valueOf(this.editingCol.isInsertLogical()));
        cb.setText("");
        cb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            cb.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent arg0) {
                    if (ActionInsertFactPopup.this.oracle.isGlobalVariable(ActionInsertFactPopup.this.editingCol.getBoundName())) {
                        cb.setEnabled(false);
                        ActionInsertFactPopup.this.editingCol.setInsertLogical(false);
                    } else {
                        ActionInsertFactPopup.this.editingCol.setInsertLogical(cb.getValue().booleanValue());
                    }
                }
            });
        }
        hp.add((Widget)cb);
        hp.add((IsWidget)new InfoPopup(GuidedDecisionTableConstants.INSTANCE.LogicallyInsertANewFact(), GuidedDecisionTableConstants.INSTANCE.LogicallyAssertAFactTheFactWillBeDeletedWhenTheSupportingEvidenceIsRemoved()));
        return hp;
    }

    private void enableFooter(boolean enabled) {
        if (this.footer == null) {
            return;
        }
        this.footer.enableOkButton(enabled);
        this.footer.enableCancelButton(enabled);
    }
}

