/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.workbench.models.datamodel.workitems.PortableBooleanParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableEnumParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableFloatParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableIntegerParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableListParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableObjectParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableStringParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableWorkDefinition;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.ActionColumnCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.DTCellValueWidgetFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.workbench.common.widgets.client.workitems.IBindingProvider;
import org.kie.workbench.common.widgets.client.workitems.WorkItemParametersWidget;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class ActionWorkItemPopup
extends FormStylePopup {
    private final GuidedDecisionTable52 model;
    private final WorkItemParametersWidget workItemInputParameters;
    private final GuidedDecisionTableView.Presenter presenter;
    private final ActionWorkItemCol52 editingCol;
    private final ActionColumnCommand refreshGrid;
    private final ActionWorkItemCol52 originalCol;
    private final boolean isNew;
    private final boolean isReadOnly;
    private final Command cmdOK = new Command(){

        public void execute() {
            ActionWorkItemPopup.this.applyChanges();
        }
    };
    private final Command cmdCancel = new Command(){

        public void execute() {
            ActionWorkItemPopup.this.hide();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.cmdOK, this.cmdCancel);
    private Map<String, PortableWorkDefinition> workItemDefinitionsMap;
    private int workItemInputParametersIndex;

    public ActionWorkItemPopup(GuidedDecisionTable52 model, GuidedDecisionTableView.Presenter presenter, ActionColumnCommand refreshGrid, ActionWorkItemCol52 column, Set<PortableWorkDefinition> workItemDefinitions, boolean isNew, boolean isReadOnly) {
        super(GuidedDecisionTableConstants.INSTANCE.ColumnConfigurationWorkItem());
        this.model = model;
        this.presenter = presenter;
        this.editingCol = this.cloneActionWorkItemColumn(column);
        this.refreshGrid = refreshGrid;
        this.originalCol = column;
        this.isNew = isNew;
        this.isReadOnly = isReadOnly;
        this.workItemInputParameters = new WorkItemParametersWidget((IBindingProvider)presenter, isReadOnly);
        final TextBox header = new TextBox();
        header.setText(column.getHeader());
        header.setEnabled(!isReadOnly);
        if (!isReadOnly) {
            header.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ActionWorkItemPopup.this.editingCol.setHeader(header.getText());
                }
            });
        }
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.ColumnHeaderDescription(), (IsWidget)header);
        final ListBox workItemsListBox = new ListBox();
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.WorkItemNameColon(), (IsWidget)workItemsListBox);
        workItemsListBox.setEnabled(!isReadOnly);
        if (!isReadOnly) {
            workItemsListBox.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    int index = workItemsListBox.getSelectedIndex();
                    if (index >= 0) {
                        String selectedWorkItemName = workItemsListBox.getValue(index);
                        ActionWorkItemPopup.this.editingCol.setWorkItemDefinition((PortableWorkDefinition)ActionWorkItemPopup.this.workItemDefinitionsMap.get(selectedWorkItemName));
                        ActionWorkItemPopup.this.showWorkItemParameters();
                    }
                }
            });
        }
        this.workItemInputParametersIndex = this.addAttribute(GuidedDecisionTableConstants.INSTANCE.WorkItemInputParameters(), (IsWidget)this.workItemInputParameters, false).getIndex();
        this.setupWorkItems(workItemsListBox, workItemDefinitions);
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.HideThisColumn() + ":", (IsWidget)DTCellValueWidgetFactory.getHideColumnIndicator((DTColumnConfig52)this.editingCol));
        this.footer.enableOkButton(!isReadOnly);
        this.add((Widget)this.footer);
    }

    private void applyChanges() {
        if (null == this.editingCol.getHeader() || "".equals(this.editingCol.getHeader())) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.YouMustEnterAColumnHeaderValueDescription());
            return;
        }
        if (this.isNew) {
            if (!this.unique(this.editingCol.getHeader())) {
                Window.alert((String)GuidedDecisionTableConstants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
                return;
            }
        } else if (!this.originalCol.getHeader().equals(this.editingCol.getHeader()) && !this.unique(this.editingCol.getHeader())) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
            return;
        }
        this.refreshGrid.execute((ActionCol52)this.editingCol);
        this.hide();
    }

    private boolean unique(String header) {
        for (ActionCol52 o : this.model.getActionCols()) {
            if (!o.getHeader().equals(header)) continue;
            return false;
        }
        return true;
    }

    private ActionWorkItemCol52 cloneActionWorkItemColumn(ActionWorkItemCol52 col) {
        ActionWorkItemCol52 clone = new ActionWorkItemCol52();
        clone.setHeader(col.getHeader());
        clone.setHideColumn(col.isHideColumn());
        clone.setWorkItemDefinition(this.cloneWorkItemDefinition(col.getWorkItemDefinition()));
        return clone;
    }

    private PortableWorkDefinition cloneWorkItemDefinition(PortableWorkDefinition pwd) {
        if (pwd == null) {
            return null;
        }
        PortableWorkDefinition clone = new PortableWorkDefinition();
        clone.setName(pwd.getName());
        clone.setDisplayName(pwd.getDisplayName());
        clone.setParameters(this.cloneParameters(pwd.getParameters()));
        clone.setResults(this.cloneParameters(pwd.getResults()));
        return clone;
    }

    private Set<PortableParameterDefinition> cloneParameters(Collection<PortableParameterDefinition> parameters) {
        HashSet<PortableParameterDefinition> clone = new HashSet<PortableParameterDefinition>();
        for (PortableParameterDefinition ppd : parameters) {
            clone.add(this.cloneParameter(ppd));
        }
        return clone;
    }

    private PortableParameterDefinition cloneParameter(PortableParameterDefinition ppd) {
        PortableBooleanParameterDefinition clone = null;
        if (ppd instanceof PortableBooleanParameterDefinition) {
            clone = new PortableBooleanParameterDefinition();
            clone.setName(ppd.getName());
            clone.setBinding(((PortableBooleanParameterDefinition)ppd).getBinding());
            clone.setValue(((PortableBooleanParameterDefinition)ppd).getValue());
            return clone;
        }
        if (ppd instanceof PortableEnumParameterDefinition) {
            clone = new PortableEnumParameterDefinition();
            clone.setName(ppd.getName());
            ((PortableEnumParameterDefinition)clone).setClassName(ppd.getClassName());
            ((PortableEnumParameterDefinition)clone).setBinding(((PortableEnumParameterDefinition)ppd).getBinding());
            ((PortableEnumParameterDefinition)clone).setValues(((PortableEnumParameterDefinition)ppd).getValues());
            ((PortableEnumParameterDefinition)clone).setValue(((PortableEnumParameterDefinition)ppd).getValue());
            return clone;
        }
        if (ppd instanceof PortableFloatParameterDefinition) {
            clone = new PortableFloatParameterDefinition();
            clone.setName(ppd.getName());
            ((PortableFloatParameterDefinition)clone).setBinding(((PortableFloatParameterDefinition)ppd).getBinding());
            ((PortableFloatParameterDefinition)clone).setValue(((PortableFloatParameterDefinition)ppd).getValue());
            return clone;
        }
        if (ppd instanceof PortableIntegerParameterDefinition) {
            clone = new PortableIntegerParameterDefinition();
            clone.setName(ppd.getName());
            ((PortableIntegerParameterDefinition)clone).setBinding(((PortableIntegerParameterDefinition)ppd).getBinding());
            ((PortableIntegerParameterDefinition)clone).setValue(((PortableIntegerParameterDefinition)ppd).getValue());
            return clone;
        }
        if (ppd instanceof PortableListParameterDefinition) {
            clone = new PortableListParameterDefinition();
            clone.setName(ppd.getName());
            ((PortableListParameterDefinition)clone).setClassName(ppd.getClassName());
            ((PortableListParameterDefinition)clone).setBinding(((PortableListParameterDefinition)ppd).getBinding());
            return clone;
        }
        if (ppd instanceof PortableObjectParameterDefinition) {
            clone = new PortableObjectParameterDefinition();
            clone.setName(ppd.getName());
            ((PortableObjectParameterDefinition)clone).setClassName(ppd.getClassName());
            ((PortableObjectParameterDefinition)clone).setBinding(((PortableObjectParameterDefinition)ppd).getBinding());
            return clone;
        }
        if (ppd instanceof PortableStringParameterDefinition) {
            clone = new PortableStringParameterDefinition();
            clone.setName(ppd.getName());
            ((PortableStringParameterDefinition)clone).setBinding(((PortableStringParameterDefinition)ppd).getBinding());
            ((PortableStringParameterDefinition)clone).setValue(((PortableStringParameterDefinition)ppd).getValue());
            return clone;
        }
        throw new IllegalArgumentException("Unrecognized PortableParameterDefinition");
    }

    private void setupWorkItems(ListBox workItemsListBox, Set<PortableWorkDefinition> workItemDefinitions) {
        workItemsListBox.clear();
        workItemsListBox.addItem(GuidedDecisionTableConstants.INSTANCE.NoWorkItemsAvailable());
        workItemsListBox.setEnabled(false);
        if (workItemDefinitions.size() > 0) {
            workItemsListBox.clear();
            workItemsListBox.setEnabled(!this.isReadOnly);
            workItemsListBox.addItem(GuidedDecisionTableConstants.INSTANCE.Choose(), "");
            this.workItemDefinitionsMap = new HashMap<String, PortableWorkDefinition>();
            String selectedName = null;
            boolean isWorkItemSelected = false;
            if (this.editingCol.getWorkItemDefinition() != null) {
                selectedName = this.editingCol.getWorkItemDefinition().getName();
            }
            int i = 0;
            for (PortableWorkDefinition wid : workItemDefinitions) {
                workItemsListBox.addItem(wid.getDisplayName(), wid.getName());
                this.workItemDefinitionsMap.put(wid.getName(), wid);
                if (wid.getName().equals(selectedName)) {
                    workItemsListBox.setSelectedIndex(i + 1);
                    isWorkItemSelected = true;
                }
                ++i;
            }
            this.setAttributeVisibility(this.workItemInputParametersIndex, isWorkItemSelected);
            this.showWorkItemParameters();
        }
    }

    private void showWorkItemParameters() {
        PortableWorkDefinition wid = this.editingCol.getWorkItemDefinition();
        if (wid == null) {
            this.setAttributeVisibility(this.workItemInputParametersIndex, false);
            return;
        }
        this.setAttributeVisibility(this.workItemInputParametersIndex, true);
        this.workItemInputParameters.setParameters(wid.getParameters());
    }
}

