/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.rule.HasCEPWindow;
import org.drools.workbench.models.datamodel.rule.HasParameterizedOperator;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryCol;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.resources.images.GuidedDecisionTableImageResources508;
import org.drools.workbench.screens.guided.dtable.client.widget.ConditionColumnCommand;
import org.drools.workbench.screens.guided.dtable.client.widget.DTCellValueWidgetFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.ModalFooterChangePattern;
import org.drools.workbench.screens.guided.dtable.client.widget.Validator;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.CellUtilities;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.drools.workbench.screens.guided.rule.client.editor.BindingTextBox;
import org.drools.workbench.screens.guided.rule.client.editor.CEPOperatorsDropdown;
import org.drools.workbench.screens.guided.rule.client.editor.CEPWindowOperatorsDropdown;
import org.drools.workbench.screens.guided.rule.client.editor.OperatorSelection;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.InlineRadio;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.resources.HumanReadable;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.ImageButton;
import org.uberfire.ext.widgets.common.client.common.InfoPopup;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;
import org.uberfire.ext.widgets.common.client.common.popups.FormStylePopup;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class ConditionPopup
extends FormStylePopup {
    private SmallLabel patternLabel = new SmallLabel();
    private TextBox fieldLabel = this.getFieldLabel();
    private TextBox binding = new BindingTextBox();
    private SmallLabel operatorLabel = new SmallLabel();
    private SimplePanel limitedEntryValueWidgetContainer = new SimplePanel();
    private int limitedEntryValueAttributeIndex = -1;
    private TextBox valueListWidget = null;
    private SimplePanel defaultValueWidgetContainer = new SimplePanel();
    private int defaultValueWidgetContainerIndex = -1;
    private ImageButton editField;
    private ImageButton editOp;
    private InlineRadio literal = new InlineRadio("constraintValueType", GuidedDecisionTableConstants.INSTANCE.LiteralValue());
    private InlineRadio formula = new InlineRadio("constraintValueType", GuidedDecisionTableConstants.INSTANCE.Formula());
    private InlineRadio predicate = new InlineRadio("constraintValueType", GuidedDecisionTableConstants.INSTANCE.Predicate());
    private CEPWindowOperatorsDropdown cwo;
    private TextBox entryPointName;
    private int cepWindowRowIndex;
    private final AsyncPackageDataModelOracle oracle;
    private final GuidedDecisionTableView.Presenter presenter;
    private final DTCellValueWidgetFactory factory;
    private final Validator validator;
    private final BRLRuleModel rm;
    private final CellUtilities cellUtilities;
    private final ColumnUtilities columnUtilities;
    private final GuidedDecisionTable52 model;
    private Pattern52 editingPattern;
    private ConditionCol52 editingCol;
    private final ConditionColumnCommand refreshGrid;
    private final ConditionCol52 originalCol;
    private final boolean isNew;
    private final boolean isReadOnly;
    private InfoPopup fieldLabelInterpolationInfo = this.getPredicateHint();
    private final Command cmdOK = new Command(){

        public void execute() {
            ConditionPopup.this.applyChanges();
        }
    };
    private final Command cmdCancel = new Command(){

        public void execute() {
            ConditionPopup.this.hide();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.cmdOK, this.cmdCancel);

    public ConditionPopup(GuidedDecisionTable52 model, AsyncPackageDataModelOracle oracle, GuidedDecisionTableView.Presenter presenter, ConditionColumnCommand refreshGrid, ConditionCol52 col, boolean isNew, boolean isReadOnly) {
        this(model, oracle, presenter, refreshGrid, new Pattern52(), col, isNew, isReadOnly);
    }

    public ConditionPopup(GuidedDecisionTable52 model, AsyncPackageDataModelOracle oracle, GuidedDecisionTableView.Presenter presenter, ConditionColumnCommand refreshGrid, Pattern52 pattern, ConditionCol52 column, boolean isNew, boolean isReadOnly) {
        super(GuidedDecisionTableConstants.INSTANCE.ConditionColumnConfiguration());
        this.rm = new BRLRuleModel(model);
        this.editingPattern = pattern != null ? pattern.clonePattern() : null;
        this.editingCol = this.cloneConditionColumn(column);
        this.model = model;
        this.oracle = oracle;
        this.presenter = presenter;
        this.refreshGrid = refreshGrid;
        this.originalCol = column;
        this.isNew = isNew;
        this.isReadOnly = isReadOnly;
        this.validator = new Validator(model.getConditions());
        this.cellUtilities = new CellUtilities();
        this.columnUtilities = new ColumnUtilities(model, oracle);
        this.factory = DTCellValueWidgetFactory.getInstance(model, oracle, isReadOnly, this.allowEmptyValues());
        HorizontalPanel patternWidget = new HorizontalPanel();
        patternWidget.add((Widget)this.patternLabel);
        this.doPatternLabel();
        ImageButton changePattern = new ImageButton(GuidedDecisionTableImageResources508.INSTANCE.Edit(), GuidedDecisionTableImageResources508.INSTANCE.EditDisabled(), GuidedDecisionTableConstants.INSTANCE.ChooseAnExistingPatternThatThisColumnAddsTo(), new ClickHandler(){

            public void onClick(ClickEvent w) {
                ConditionPopup.this.showChangePattern(w);
            }
        });
        changePattern.setEnabled(!isReadOnly);
        patternWidget.add((Widget)changePattern);
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.Pattern(), (IsWidget)patternWidget);
        switch (model.getTableFormat()) {
            case EXTENDED_ENTRY: {
                HorizontalPanel valueTypes = new HorizontalPanel();
                valueTypes.add((Widget)this.literal);
                valueTypes.add((Widget)this.formula);
                valueTypes.add((Widget)this.predicate);
                this.addAttribute(GuidedDecisionTableConstants.INSTANCE.CalculationType() + ":", (IsWidget)valueTypes);
                switch (this.editingCol.getConstraintValueType()) {
                    case 1: {
                        this.literal.setValue(Boolean.valueOf(true));
                        break;
                    }
                    case 3: {
                        this.formula.setValue(Boolean.valueOf(true));
                        break;
                    }
                    case 5: {
                        this.predicate.setValue(Boolean.valueOf(true));
                    }
                }
                if (!isReadOnly) {
                    this.literal.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent w) {
                            ConditionPopup.this.editingCol.setFactField(null);
                            ConditionPopup.this.applyConsTypeChange(1);
                        }
                    });
                }
                if (!isReadOnly) {
                    this.formula.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent w) {
                            ConditionPopup.this.editingCol.setFactField(null);
                            ConditionPopup.this.applyConsTypeChange(3);
                        }
                    });
                }
                if (isReadOnly) break;
                this.predicate.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent w) {
                        ConditionPopup.this.editingCol.setFactField(null);
                        ConditionPopup.this.applyConsTypeChange(5);
                    }
                });
                break;
            }
            case LIMITED_ENTRY: {
                this.binding.setEnabled(!isReadOnly);
            }
        }
        HorizontalPanel field = new HorizontalPanel();
        this.fieldLabel.setEnabled(!isReadOnly);
        field.add((Widget)this.fieldLabel);
        field.add((IsWidget)this.fieldLabelInterpolationInfo);
        this.editField = new ImageButton(GuidedDecisionTableImageResources508.INSTANCE.Edit(), GuidedDecisionTableImageResources508.INSTANCE.EditDisabled(), GuidedDecisionTableConstants.INSTANCE.EditTheFieldThatThisColumnOperatesOn(), new ClickHandler(){

            public void onClick(ClickEvent w) {
                ConditionPopup.this.showFieldChange();
            }
        });
        this.editField.setEnabled(!isReadOnly);
        field.add((Widget)this.editField);
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.Field() + ":", (IsWidget)field);
        this.doFieldLabel();
        HorizontalPanel operator = new HorizontalPanel();
        operator.add((Widget)this.operatorLabel);
        this.editOp = new ImageButton(GuidedDecisionTableImageResources508.INSTANCE.Edit(), GuidedDecisionTableImageResources508.INSTANCE.EditDisabled(), GuidedDecisionTableConstants.INSTANCE.EditTheOperatorThatIsUsedToCompareDataWithThisField(), new ClickHandler(){

            public void onClick(ClickEvent w) {
                ConditionPopup.this.showOperatorChange();
            }
        });
        this.editOp.setEnabled(!isReadOnly);
        operator.add((Widget)this.editOp);
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.Operator(), (IsWidget)operator);
        this.doOperatorLabel();
        this.doImageButtons();
        this.cepWindowRowIndex = this.addAttribute(GuidedDecisionTableConstants.INSTANCE.DTLabelOverCEPWindow(), this.createCEPWindowWidget((HasCEPWindow)this.editingPattern)).getIndex();
        this.displayCEPOperators();
        this.entryPointName = new TextBox();
        this.entryPointName.setText(this.editingPattern.getEntryPointName());
        this.entryPointName.setEnabled(!isReadOnly);
        if (!isReadOnly) {
            this.entryPointName.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ConditionPopup.this.editingPattern.setEntryPointName(ConditionPopup.this.entryPointName.getText());
                }
            });
        }
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.DTLabelFromEntryPoint() + ":", (IsWidget)this.entryPointName);
        final TextBox header = new TextBox();
        header.setText(column.getHeader());
        header.setEnabled(!isReadOnly);
        if (!isReadOnly) {
            header.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ConditionPopup.this.editingCol.setHeader(header.getText());
                }
            });
        }
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.ColumnHeaderDescription(), (IsWidget)header);
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY) {
            this.valueListWidget = new TextBox();
            this.valueListWidget.setText(this.editingCol.getValueList());
            this.valueListWidget.setEnabled(!isReadOnly);
            if (!isReadOnly) {
                this.valueListWidget.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        ConditionPopup.this.editingCol.setValueList(ConditionPopup.this.valueListWidget.getText());
                    }
                });
                this.valueListWidget.addBlurHandler(new BlurHandler(){

                    public void onBlur(BlurEvent event) {
                        this.assertDefaultValue();
                        ConditionPopup.this.makeDefaultValueWidget();
                    }

                    private void assertDefaultValue() {
                        List<String> valueList = Arrays.asList(ConditionPopup.this.columnUtilities.getValueList((BaseColumn)ConditionPopup.this.editingCol));
                        if (valueList.size() > 0) {
                            String defaultValue = ConditionPopup.this.cellUtilities.asString(ConditionPopup.this.editingCol.getDefaultValue());
                            if (!valueList.contains(defaultValue)) {
                                ConditionPopup.this.editingCol.getDefaultValue().clearValues();
                            }
                        } else {
                            DTCellValue52 defaultValue = ConditionPopup.this.editingCol.getDefaultValue();
                            DataType.DataTypes dataType = ConditionPopup.this.columnUtilities.getDataType(ConditionPopup.this.editingPattern, ConditionPopup.this.editingCol);
                            ConditionPopup.this.cellUtilities.convertDTCellValueType(dataType, defaultValue);
                        }
                    }
                });
            }
            HorizontalPanel vl = new HorizontalPanel();
            vl.add((Widget)this.valueListWidget);
            vl.add((IsWidget)new InfoPopup(GuidedDecisionTableConstants.INSTANCE.ValueList(), GuidedDecisionTableConstants.INSTANCE.ValueListsExplanation()));
            this.addAttribute(GuidedDecisionTableConstants.INSTANCE.optionalValueList(), (IsWidget)vl);
        }
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY) {
            this.defaultValueWidgetContainerIndex = this.addAttribute(GuidedDecisionTableConstants.INSTANCE.DefaultValue() + ":", (IsWidget)this.defaultValueWidgetContainer).getIndex();
            this.makeDefaultValueWidget();
        }
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            this.limitedEntryValueAttributeIndex = this.addAttribute(GuidedDecisionTableConstants.INSTANCE.LimitedEntryValue(), (IsWidget)this.limitedEntryValueWidgetContainer).getIndex();
            this.makeLimitedValueWidget();
        }
        this.binding.setText(column.getBinding());
        if (!isReadOnly) {
            this.binding.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ConditionPopup.this.editingCol.setBinding(ConditionPopup.this.binding.getText());
                }
            });
        }
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.Binding() + ":", (IsWidget)this.binding);
        this.addAttribute(GuidedDecisionTableConstants.INSTANCE.HideThisColumn() + ":", (IsWidget)DTCellValueWidgetFactory.getHideColumnIndicator((DTColumnConfig52)this.editingCol));
        this.doValueList();
        this.doCalculationType();
        this.initialiseViewForConstraintValueType(this.editingCol.getConstraintValueType());
        this.footer.enableOkButton(!isReadOnly);
        this.add((Widget)this.footer);
    }

    private void applyChanges() {
        if (null == this.editingCol.getHeader() || "".equals(this.editingCol.getHeader())) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.YouMustEnterAColumnHeaderValueDescription());
            return;
        }
        if (this.editingCol.getConstraintValueType() != 5) {
            if (null == this.editingCol.getFactField() || "".equals(this.editingCol.getFactField())) {
                Window.alert((String)GuidedDecisionTableConstants.INSTANCE.PleaseSelectOrEnterField());
                return;
            }
            if (this.editingCol.getOperator() == null) {
                Window.alert((String)GuidedDecisionTableConstants.INSTANCE.NotifyNoSelectedOperator());
                return;
            }
        } else {
            this.editingCol.setOperator(null);
        }
        if (this.isNew) {
            if (this.editingCol.isBound() && !this.isBindingUnique(this.editingCol.getBinding())) {
                Window.alert((String)GuidedDecisionTableConstants.INSTANCE.PleaseEnterANameThatIsNotAlreadyUsedByAnotherPattern());
                return;
            }
        } else if (this.originalCol.isBound() && this.editingCol.isBound() && !this.originalCol.getBinding().equals(this.editingCol.getBinding()) && this.editingCol.isBound() && !this.isBindingUnique(this.editingCol.getBinding())) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.PleaseEnterANameThatIsNotAlreadyUsedByAnotherPattern());
            return;
        }
        if (this.isNew) {
            if (!this.unique(this.editingCol.getHeader())) {
                Window.alert((String)GuidedDecisionTableConstants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
                return;
            }
        } else if (!this.originalCol.getHeader().equals(this.editingCol.getHeader()) && !this.unique(this.editingCol.getHeader())) {
            Window.alert((String)GuidedDecisionTableConstants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
            return;
        }
        if (this.editingCol.getConstraintValueType() != 1) {
            this.editingCol.setBinding(null);
        }
        this.refreshGrid.execute(this.editingPattern, this.editingCol);
        this.hide();
    }

    private boolean allowEmptyValues() {
        return this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY;
    }

    private ConditionCol52 cloneConditionColumn(ConditionCol52 col) {
        LimitedEntryConditionCol52 clone = null;
        if (col instanceof LimitedEntryConditionCol52) {
            clone = new LimitedEntryConditionCol52();
            DTCellValue52 dcv = this.cloneDTCellValue(((LimitedEntryCol)col).getValue());
            ((LimitedEntryCol)clone).setValue(dcv);
        } else {
            clone = new ConditionCol52();
        }
        clone.setConstraintValueType(col.getConstraintValueType());
        clone.setFactField(col.getFactField());
        clone.setFieldType(col.getFieldType());
        clone.setHeader(col.getHeader());
        clone.setOperator(col.getOperator());
        clone.setValueList(col.getValueList());
        clone.setDefaultValue(this.cloneDTCellValue(col.getDefaultValue()));
        clone.setHideColumn(col.isHideColumn());
        clone.setParameters(col.getParameters());
        clone.setWidth(col.getWidth());
        clone.setBinding(col.getBinding());
        return clone;
    }

    private DTCellValue52 cloneDTCellValue(DTCellValue52 dcv) {
        if (dcv == null) {
            return null;
        }
        DTCellValue52 clone = new DTCellValue52(dcv);
        return clone;
    }

    private void makeLimitedValueWidget() {
        if (!(this.editingCol instanceof LimitedEntryConditionCol52)) {
            return;
        }
        LimitedEntryConditionCol52 lec = (LimitedEntryConditionCol52)this.editingCol;
        boolean doesOperatorNeedValue = this.validator.doesOperatorNeedValue(this.editingCol);
        if (!doesOperatorNeedValue) {
            this.setAttributeVisibility(this.limitedEntryValueAttributeIndex, false);
            lec.setValue(null);
            return;
        }
        this.setAttributeVisibility(this.limitedEntryValueAttributeIndex, true);
        if (lec.getValue() == null) {
            lec.setValue(this.factory.makeNewValue(this.editingPattern, this.editingCol));
        }
        this.limitedEntryValueWidgetContainer.setWidget(this.factory.getWidget(this.editingPattern, this.editingCol, lec.getValue()));
    }

    private void makeDefaultValueWidget() {
        if (this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            return;
        }
        if (this.nil(this.editingCol.getFactField())) {
            this.setAttributeVisibility(this.defaultValueWidgetContainerIndex, false);
            return;
        }
        if (!this.validator.doesOperatorNeedValue(this.editingCol)) {
            this.setAttributeVisibility(this.defaultValueWidgetContainerIndex, false);
            return;
        }
        this.setAttributeVisibility(this.defaultValueWidgetContainerIndex, true);
        if (this.editingCol.getDefaultValue() == null) {
            this.editingCol.setDefaultValue(this.factory.makeNewValue(this.editingPattern, this.editingCol));
        }
        DTCellValue52 defaultValue = this.editingCol.getDefaultValue();
        DataType.DataTypes dataType = this.columnUtilities.getDataType(this.editingPattern, this.editingCol);
        this.cellUtilities.convertDTCellValueType(dataType, defaultValue);
        if (!this.validator.doesOperatorAcceptCommaSeparatedValues(this.editingCol)) {
            this.cellUtilities.removeCommaSeparatedValue(defaultValue);
        }
        this.defaultValueWidgetContainer.setWidget(this.factory.getWidget(this.editingPattern, this.editingCol, defaultValue));
    }

    private void applyConsTypeChange(int newConstraintValueType) {
        this.editingCol.setConstraintValueType(newConstraintValueType);
        this.initialiseViewForConstraintValueType(newConstraintValueType);
    }

    private void initialiseViewForConstraintValueType(int constraintValueType) {
        this.binding.setEnabled(constraintValueType == 1 && !this.isReadOnly);
        this.doFieldLabel();
        this.doValueList();
        this.doOperatorLabel();
        this.doImageButtons();
        this.makeDefaultValueWidget();
    }

    private void doImageButtons() {
        int constraintType = this.editingCol.getConstraintValueType();
        boolean enableField = !this.nil(this.editingPattern.getFactType()) && constraintType != 5 && !this.isReadOnly;
        boolean enableOp = !this.nil(this.editingCol.getFactField()) && constraintType != 5 && !this.isReadOnly;
        this.editField.setEnabled(enableField);
        this.editOp.setEnabled(enableOp);
    }

    private boolean isBindingUnique(String binding) {
        return !this.rm.isVariableNameUsed(binding);
    }

    private void doFieldLabel() {
        if (this.editingCol.getConstraintValueType() == 5) {
            if (this.editingCol.getFactField() == null || this.editingCol.getFactField().equals("")) {
                this.fieldLabel.setText(GuidedDecisionTableConstants.INSTANCE.notNeededForPredicate());
            } else {
                this.fieldLabel.setText(this.editingCol.getFactField());
            }
            this.fieldLabelInterpolationInfo.getWidget().getElement().getStyle().setDisplay(Style.Display.INLINE);
        } else if (this.nil(this.editingPattern.getFactType())) {
            this.fieldLabel.setText(GuidedDecisionTableConstants.INSTANCE.pleaseSelectAPatternFirst());
            this.fieldLabelInterpolationInfo.getWidget().getElement().getStyle().setDisplay(Style.Display.NONE);
        } else if (this.nil(this.editingCol.getFactField())) {
            this.fieldLabel.setText(GuidedDecisionTableConstants.INSTANCE.pleaseSelectAField());
            this.fieldLabelInterpolationInfo.getWidget().getElement().getStyle().setDisplay(Style.Display.NONE);
        } else {
            this.fieldLabel.setText(this.editingCol.getFactField());
        }
    }

    private void doOperatorLabel() {
        if (this.editingCol.getConstraintValueType() == 5) {
            this.operatorLabel.setText(GuidedDecisionTableConstants.INSTANCE.notNeededForPredicate());
        } else if (this.nil(this.editingPattern.getFactType())) {
            this.operatorLabel.setText(GuidedDecisionTableConstants.INSTANCE.pleaseSelectAPatternFirst());
        } else if (this.nil(this.editingCol.getFactField())) {
            this.operatorLabel.setText(GuidedDecisionTableConstants.INSTANCE.pleaseChooseAFieldFirst());
        } else if (this.nil(this.editingCol.getOperator())) {
            this.operatorLabel.setText(GuidedDecisionTableConstants.INSTANCE.pleaseSelectAnOperator());
        } else {
            this.operatorLabel.setText(HumanReadable.getOperatorDisplayName((String)this.editingCol.getOperator()));
        }
    }

    private void doPatternLabel() {
        if (this.editingPattern.getFactType() != null) {
            StringBuilder patternLabel = new StringBuilder();
            String factType = this.editingPattern.getFactType();
            String boundName = this.editingPattern.getBoundName();
            if (factType != null && factType.length() > 0) {
                if (this.editingPattern.isNegated()) {
                    patternLabel.append(GuidedDecisionTableConstants.INSTANCE.negatedPattern()).append(" ").append(factType);
                } else {
                    patternLabel.append(factType).append(" [").append(boundName).append("]");
                }
            }
            this.patternLabel.setText(patternLabel.toString());
        }
        this.doFieldLabel();
        this.doOperatorLabel();
    }

    private TextBox getFieldLabel() {
        final TextBox box = new TextBox();
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ConditionPopup.this.editingCol.setFactField(box.getText());
            }
        });
        return box;
    }

    private InfoPopup getPredicateHint() {
        return new InfoPopup(GuidedDecisionTableConstants.INSTANCE.Predicates(), GuidedDecisionTableConstants.INSTANCE.PredicatesInfo());
    }

    private void doValueList() {
        boolean enableValueList;
        if (this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            return;
        }
        String factType = this.editingPattern.getFactType();
        String factField = this.editingCol.getFactField();
        boolean bl = enableValueList = !this.isReadOnly && factType != null && !"".equals(factType) && factField != null && !"".equals(factField);
        if (enableValueList) {
            enableValueList = this.validator.doesOperatorAcceptValueList(this.editingCol);
        }
        if (enableValueList) {
            enableValueList = !this.oracle.hasEnums(factType, factField);
        }
        this.valueListWidget.setEnabled(enableValueList);
        if (!enableValueList) {
            this.valueListWidget.setText("");
        } else {
            this.valueListWidget.setText(this.editingCol.getValueList());
        }
    }

    private void doCalculationType() {
        String factField;
        if (this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            return;
        }
        String factType = this.editingPattern.getFactType();
        boolean hasEnums = this.oracle.hasEnums(factType, factField = this.editingCol.getFactField());
        this.literal.setEnabled(hasEnums || !this.isReadOnly);
        this.formula.setEnabled(!hasEnums && !this.isReadOnly);
        this.predicate.setEnabled(!hasEnums && !this.isReadOnly);
        if (hasEnums) {
            this.editingCol.setConstraintValueType(1);
        }
    }

    ListBox loadPatterns() {
        HashSet<String> vars = new HashSet<String>();
        ListBox patterns = new ListBox();
        int selectedIndex = -1;
        List availablePatterns = this.model.getPatterns();
        String editingPatternBinding = this.editingPattern == null ? null : this.editingPattern.getBoundName();
        for (int i = 0; i < availablePatterns.size(); ++i) {
            Pattern52 p = (Pattern52)availablePatterns.get(i);
            if (p.getBoundName().equals(editingPatternBinding)) {
                selectedIndex = i;
            }
            if (vars.contains(p.getBoundName())) continue;
            patterns.addItem((p.isNegated() ? GuidedDecisionTableConstants.INSTANCE.negatedPattern() + " " : "") + p.getFactType() + " [" + p.getBoundName() + "]", p.getFactType() + " " + p.getBoundName() + " " + p.isNegated());
            vars.add(p.getBoundName());
        }
        if (selectedIndex >= 0) {
            this.selectListBoxItem(patterns, selectedIndex);
        }
        return patterns;
    }

    void selectListBoxItem(ListBox listBox, int index) {
        listBox.setSelectedIndex(index);
    }

    private boolean nil(String s) {
        return s == null || s.equals("");
    }

    private void showOperatorChange() {
        final String factType = this.editingPattern.getFactType();
        final String factField = this.editingCol.getFactField();
        this.oracle.getOperatorCompletions(factType, factField, (Callback)new Callback<String[]>(){

            public void callback(String[] ops) {
                ConditionPopup.this.doShowOperatorChange(factType, factField, ops);
            }
        });
    }

    private void doShowOperatorChange(String factType, String factField, String[] ops) {
        final FormStylePopup pop = new FormStylePopup(GuidedDecisionTableConstants.INSTANCE.SetTheOperator());
        ArrayList<String> filteredOps = new ArrayList<String>();
        for (String op : ops) {
            filteredOps.add(op);
        }
        if (1 != this.editingCol.getConstraintValueType()) {
            filteredOps.remove("in");
            filteredOps.remove("not in");
        }
        String[] displayOps = new String[filteredOps.size()];
        filteredOps.toArray(displayOps);
        final CEPOperatorsDropdown box = new CEPOperatorsDropdown(displayOps, (HasParameterizedOperator)this.editingCol);
        box.insertItem(GuidedDecisionTableConstants.INSTANCE.noOperator(), "", 1);
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.Operator(), (IsWidget)box);
        pop.add((Widget)new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                ConditionPopup.this.editingCol.setOperator(box.getValue(box.getSelectedIndex()));
                ConditionPopup.this.makeLimitedValueWidget();
                ConditionPopup.this.makeDefaultValueWidget();
                ConditionPopup.this.doOperatorLabel();
                ConditionPopup.this.doValueList();
                pop.hide();
                ConditionPopup.this.enableFooter(true);
            }
        }, new Command(){

            public void execute() {
                pop.hide();
                ConditionPopup.this.enableFooter(true);
            }
        }));
        this.enableFooter(false);
        pop.show();
    }

    private boolean unique(String header) {
        for (CompositeColumn cc : this.model.getConditions()) {
            for (int iChild = 0; iChild < cc.getChildColumns().size(); ++iChild) {
                if (!((BaseColumn)cc.getChildColumns().get(iChild)).getHeader().equals(header)) continue;
                return false;
            }
        }
        return true;
    }

    protected void showChangePattern(ClickEvent w) {
        final ListBox pats = this.loadPatterns();
        if (pats.getItemCount() == 0) {
            this.showNewPatternDialog();
            return;
        }
        final FormStylePopup pop = new FormStylePopup(GuidedDecisionTableConstants.INSTANCE.FactType());
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.ChooseExistingPatternToAddColumnTo(), (IsWidget)pats);
        pop.add((Widget)new ModalFooterChangePattern(new Command(){

            public void execute() {
                String[] val = pats.getValue(pats.getSelectedIndex()).split("\\s");
                ConditionPopup.this.editingPattern = ConditionPopup.this.model.getConditionPattern(val[1]);
                ConditionPopup.this.editingCol.setFactField(null);
                ConditionPopup.this.editingCol.setOperator(null);
                ConditionPopup.this.entryPointName.setText(ConditionPopup.this.editingPattern.getEntryPointName());
                ConditionPopup.this.cwo.selectItem(ConditionPopup.this.editingPattern.getWindow().getOperator());
                ConditionPopup.this.makeLimitedValueWidget();
                ConditionPopup.this.makeDefaultValueWidget();
                ConditionPopup.this.displayCEPOperators();
                ConditionPopup.this.doPatternLabel();
                ConditionPopup.this.doValueList();
                ConditionPopup.this.doCalculationType();
                ConditionPopup.this.doImageButtons();
                pop.hide();
                ConditionPopup.this.enableFooter(true);
            }
        }, new Command(){

            public void execute() {
                pop.hide();
                ConditionPopup.this.showNewPatternDialog();
            }
        }, new Command(){

            public void execute() {
                pop.hide();
                ConditionPopup.this.enableFooter(true);
            }
        }));
        this.enableFooter(false);
        pop.show();
    }

    protected void showFieldChange() {
        FormStylePopup pop = new FormStylePopup(GuidedDecisionTableConstants.INSTANCE.Field());
        ListBox box = this.loadFields();
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.Field() + ":", (IsWidget)box);
        pop.add((Widget)new ModalFooterOKCancelButtons(() -> {
            this.editingCol.setFactField(box.getItemText(box.getSelectedIndex()));
            this.editingCol.setFieldType(this.oracle.getFieldType(this.editingPattern.getFactType(), this.editingCol.getFactField()));
            this.editingCol.setOperator(null);
            this.editingCol.setValueList(null);
            this.doFieldLabel();
            this.doValueList();
            this.doCalculationType();
            this.makeLimitedValueWidget();
            this.makeDefaultValueWidget();
            this.doOperatorLabel();
            this.doImageButtons();
            pop.hide();
            this.enableFooter(true);
        }, () -> {
            pop.hide();
            this.enableFooter(true);
        }));
        this.enableFooter(false);
        pop.show();
    }

    ListBox loadFields() {
        ListBox box = new ListBox();
        this.oracle.getFieldCompletions(this.editingPattern.getFactType(), FieldAccessorsAndMutators.ACCESSOR, fields -> {
            switch (this.editingCol.getConstraintValueType()) {
                case 1: {
                    int selectedIndex = -1;
                    for (int i = 0; i < ((ModelField[])fields).length; ++i) {
                        String fieldName = fields[i].getName();
                        if (fieldName.equals(this.editingCol.getFactField())) {
                            selectedIndex = i;
                        }
                        box.addItem(fields[i].getName());
                    }
                    if (selectedIndex < 0) break;
                    this.selectListBoxItem(box, selectedIndex);
                    break;
                }
                case 3: {
                    for (int i = 0; i < ((ModelField[])fields).length; ++i) {
                        String fieldName = fields[i].getName();
                        if (this.oracle.hasEnums(this.editingPattern.getFactType(), fieldName)) continue;
                        box.addItem(fieldName);
                    }
                    break;
                }
            }
        });
        return box;
    }

    protected void showNewPatternDialog() {
        final FormStylePopup pop = new FormStylePopup(GuidedDecisionTableConstants.INSTANCE.FactType());
        pop.setTitle(GuidedDecisionTableConstants.INSTANCE.CreateANewFactPattern());
        final ListBox types = new ListBox();
        for (int i = 0; i < this.oracle.getFactTypes().length; ++i) {
            types.addItem(this.oracle.getFactTypes()[i]);
        }
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.FactType(), (IsWidget)types);
        BindingTextBox binding = new BindingTextBox();
        binding.addChangeHandler(new ChangeHandler((TextBox)binding){
            final /* synthetic */ TextBox val$binding;
            {
                this.val$binding = textBox;
            }

            public void onChange(ChangeEvent event) {
                this.val$binding.setText(this.val$binding.getText().replace(" ", ""));
            }
        });
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.Binding() + ":", (IsWidget)binding);
        final CheckBox chkNegated = new CheckBox();
        chkNegated.addClickHandler(new ClickHandler((TextBox)binding){
            final /* synthetic */ TextBox val$binding;
            {
                this.val$binding = textBox;
            }

            public void onClick(ClickEvent event) {
                boolean isPatternNegated = chkNegated.getValue();
                this.val$binding.setEnabled(!isPatternNegated);
            }
        });
        pop.addAttribute(GuidedDecisionTableConstants.INSTANCE.negatePattern(), (IsWidget)chkNegated);
        pop.add((Widget)new ModalFooterOKCancelButtons(new Command((TextBox)binding, pop){
            final /* synthetic */ TextBox val$binding;
            final /* synthetic */ FormStylePopup val$pop;
            {
                this.val$binding = textBox;
                this.val$pop = formStylePopup;
            }

            public void execute() {
                String fn;
                boolean isPatternNegated = chkNegated.getValue();
                String ft = types.getItemText(types.getSelectedIndex());
                String string = fn = isPatternNegated ? "" : this.val$binding.getText();
                if (!isPatternNegated) {
                    if (fn.equals("")) {
                        Window.alert((String)GuidedDecisionTableConstants.INSTANCE.PleaseEnterANameForFact());
                        return;
                    }
                    if (fn.equals(ft)) {
                        Window.alert((String)GuidedDecisionTableConstants.INSTANCE.PleaseEnterANameThatIsNotTheSameAsTheFactType());
                        return;
                    }
                    if (!ConditionPopup.this.isBindingUnique(fn)) {
                        Window.alert((String)GuidedDecisionTableConstants.INSTANCE.PleaseEnterANameThatIsNotAlreadyUsedByAnotherPattern());
                        return;
                    }
                }
                ConditionPopup.this.editingPattern = new Pattern52();
                ConditionPopup.this.editingPattern.setFactType(ft);
                ConditionPopup.this.editingPattern.setBoundName(fn);
                ConditionPopup.this.editingPattern.setNegated(isPatternNegated);
                ConditionPopup.this.editingCol.setFactField(null);
                ConditionPopup.this.editingCol.setOperator(null);
                ConditionPopup.this.entryPointName.setText(ConditionPopup.this.editingPattern.getEntryPointName());
                ConditionPopup.this.cwo.selectItem(ConditionPopup.this.editingPattern.getWindow().getOperator());
                ConditionPopup.this.makeLimitedValueWidget();
                ConditionPopup.this.makeDefaultValueWidget();
                ConditionPopup.this.displayCEPOperators();
                ConditionPopup.this.doPatternLabel();
                ConditionPopup.this.doValueList();
                ConditionPopup.this.doCalculationType();
                ConditionPopup.this.doOperatorLabel();
                ConditionPopup.this.doImageButtons();
                this.val$pop.hide();
                ConditionPopup.this.enableFooter(true);
            }
        }, new Command(){

            public void execute() {
                pop.hide();
                ConditionPopup.this.enableFooter(true);
            }
        }));
        this.enableFooter(false);
        pop.show();
    }

    private IsWidget createCEPWindowWidget(final HasCEPWindow c) {
        HorizontalPanel hp = new HorizontalPanel();
        Label lbl = new Label(GuidedDecisionTableConstants.INSTANCE.OverCEPWindow());
        lbl.setStyleName("paddedLabel");
        hp.add((Widget)lbl);
        this.cwo = new CEPWindowOperatorsDropdown(c, this.isReadOnly);
        if (!this.isReadOnly) {
            this.cwo.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<OperatorSelection>(){

                public void onValueChange(ValueChangeEvent<OperatorSelection> event) {
                    OperatorSelection selection = (OperatorSelection)event.getValue();
                    String selected = selection.getValue();
                    c.getWindow().setOperator(selected);
                }
            });
        }
        hp.add((Widget)this.cwo);
        return hp;
    }

    private void displayCEPOperators() {
        this.oracle.isFactTypeAnEvent(this.editingPattern.getFactType(), (Callback)new Callback<Boolean>(){

            public void callback(Boolean result) {
                ConditionPopup.this.setAttributeVisibility(ConditionPopup.this.cepWindowRowIndex, Boolean.TRUE.equals(result));
            }
        });
    }

    private void enableFooter(boolean enabled) {
        if (this.footer == null) {
            return;
        }
        this.footer.enableOkButton(enabled);
        this.footer.enableCancelButton(enabled);
    }
}

