/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.AnalysisReporter;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.Status;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.RuleInspectorCache;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.UpdateManager;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.RuleInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.Check;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.CheckRunner;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.data.Coordinate;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

public class DecisionTableAnalyzer {
    private final UpdateManager updateManager;
    private final CheckRunner checkRunner;
    private final AnalysisReporter reporter;
    private final RuleInspectorCache cache;
    private final GuidedDecisionTable52 model;
    private final EventManager eventManager = new EventManager();
    private final ParameterizedCommand<Status> onStatus = this.getOnStatusCommand();
    private final Command onCompletion = this.getOnCompletionCommand();

    public DecisionTableAnalyzer(AnalysisReporter reporter, GuidedDecisionTable52 model, RuleInspectorCache cache, UpdateManager updateManager, CheckRunner checkRunner) {
        this.reporter = (AnalysisReporter)PortablePreconditions.checkNotNull((String)"reporter", (Object)reporter);
        this.model = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"model", (Object)model);
        this.cache = (RuleInspectorCache)PortablePreconditions.checkNotNull((String)"cache", (Object)cache);
        this.updateManager = (UpdateManager)PortablePreconditions.checkNotNull((String)"updateManager", (Object)updateManager);
        this.checkRunner = (CheckRunner)PortablePreconditions.checkNotNull((String)"checkRunner", (Object)checkRunner);
    }

    public void resetChecks() {
        for (RuleInspector ruleInspector : this.cache.all()) {
            this.checkRunner.addChecks(ruleInspector.getChecks());
        }
    }

    protected ParameterizedCommand<Status> getOnStatusCommand() {
        return new ParameterizedCommand<Status>(){

            public void execute(Status status) {
                DecisionTableAnalyzer.this.reporter.sendStatus(status);
            }
        };
    }

    protected Command getOnCompletionCommand() {
        return new Command(){

            public void execute() {
                DecisionTableAnalyzer.this.reporter.sendReport(DecisionTableAnalyzer.this.getIssues());
            }
        };
    }

    public void analyze() {
        this.checkRunner.run(this.onStatus, this.onCompletion);
    }

    protected Set<Issue> getIssues() {
        HashSet<Issue> unorderedIssues = new HashSet<Issue>();
        for (RuleInspector ruleInspector : this.cache.allRuleInspectors()) {
            for (Check check : ruleInspector.getChecks()) {
                if (!check.hasIssues()) continue;
                unorderedIssues.add(check.getIssue());
            }
        }
        return unorderedIssues;
    }

    public void analyze(List<Coordinate> updates) {
        if (updates.isEmpty()) {
            this.resetChecks();
            this.analyze();
        } else if (this.updateManager.update(updates)) {
            this.analyze();
        }
    }

    public void deleteColumns(int firstColumnIndex, int numberOfColumns) {
        this.cache.deleteColumns(firstColumnIndex, numberOfColumns);
        this.resetChecks();
        this.analyze();
    }

    public void insertColumn(BaseColumn baseColumn) {
        this.cache.newColumn(this.getColumnIndex(baseColumn));
        this.resetChecks();
        this.analyze();
    }

    private int getColumnIndex(BaseColumn baseColumn) {
        int indexOf = this.model.getExpandedColumns().indexOf(baseColumn);
        if (indexOf < 0) {
            if (baseColumn instanceof BRLConditionColumn) {
                for (BaseColumn column : this.model.getExpandedColumns()) {
                    if (!(column instanceof BRLConditionVariableColumn) || !((BRLConditionColumn)baseColumn).getChildColumns().contains(column)) continue;
                    return this.model.getExpandedColumns().indexOf(column);
                }
                throw new IllegalArgumentException("Could not find BRLConditionColumn: " + baseColumn.toString());
            }
            if (baseColumn instanceof BRLVariableColumn) {
                return this.model.getExpandedColumns().indexOf(this.model.getBRLColumn((BRLVariableColumn)baseColumn));
            }
            throw new IllegalArgumentException("Could not find baseColumn: " + baseColumn.toString());
        }
        return indexOf;
    }

    public void updateColumns(int amountOfRows) {
        if (this.hasTheRowCountIncreased(amountOfRows)) {
            this.addRow(this.eventManager.getNewIndex());
            this.analyze();
        } else if (this.hasTheRowCountDecreased(amountOfRows)) {
            this.checkRunner.remove(this.cache.removeRow(this.eventManager.rowDeleted));
            this.analyze();
        }
        this.eventManager.clear();
    }

    private boolean hasTheRowCountDecreased(int size) {
        return this.cache.all().size() > size;
    }

    private boolean hasTheRowCountIncreased(int size) {
        return this.cache.all().size() < size;
    }

    private void addRow(int index) {
        RuleInspector ruleInspector = this.cache.addRow(index);
        this.checkRunner.addChecks(ruleInspector.getChecks());
    }

    public void deleteRow(int index) {
        this.stop();
        this.eventManager.rowDeleted = index;
    }

    public void appendRow() {
        this.stop();
        this.eventManager.rowAppended = true;
    }

    public void insertRow(int index) {
        this.stop();
        this.eventManager.rowInserted = index;
    }

    public void start() {
        if (this.checkRunner.isEmpty()) {
            this.resetChecks();
            this.analyze();
        } else {
            this.reporter.sendReport(this.getIssues());
        }
    }

    public void stop() {
        this.checkRunner.cancelExistingAnalysis();
    }

    class EventManager {
        boolean rowAppended = false;
        Integer rowInserted = null;
        Integer rowDeleted = null;

        EventManager() {
        }

        public void clear() {
            this.rowAppended = false;
            this.rowInserted = null;
            this.rowDeleted = null;
        }

        int getNewIndex() {
            if (((DecisionTableAnalyzer)DecisionTableAnalyzer.this).eventManager.rowAppended) {
                return DecisionTableAnalyzer.this.model.getData().size() - 1;
            }
            if (((DecisionTableAnalyzer)DecisionTableAnalyzer.this).eventManager.rowInserted != null) {
                return ((DecisionTableAnalyzer)DecisionTableAnalyzer.this).eventManager.rowInserted;
            }
            throw new IllegalStateException("There are no active updates");
        }
    }
}

