/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.RuleInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasIndex;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.CheckManager;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Action;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.CellBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Column;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.ColumnBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Condition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Field;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Fields;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Index;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Rule;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.RuleBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.matchers.UUIDMatcher;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.uberfire.commons.validation.PortablePreconditions;

public class RuleInspectorCache {
    private final Map<Rule, RuleInspector> ruleInspectors = new HashMap<Rule, RuleInspector>();
    private final Index index;
    private final ColumnUtilities utils;
    private final GuidedDecisionTable52 model;
    private CheckManager checkManager = new CheckManager();

    public RuleInspectorCache(ColumnUtilities utils, GuidedDecisionTable52 model, Index index) {
        this.model = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"model", (Object)model);
        this.utils = (ColumnUtilities)PortablePreconditions.checkNotNull((String)"utils", (Object)utils);
        this.index = (Index)PortablePreconditions.checkNotNull((String)"index", (Object)index);
        this.reset();
    }

    public void newColumn(int columnIndex) {
        this.index.columns.add(new ColumnBuilder(this.model, (BaseColumn)this.model.getExpandedColumns().get(columnIndex)).build());
        int rowIndex = 0;
        for (List row : this.model.getData()) {
            BaseColumn baseColumn = (BaseColumn)this.model.getExpandedColumns().get(columnIndex);
            Rule rule = this.getRule(rowIndex);
            new CellBuilder(this.index, this.model, columnIndex, this.utils, baseColumn).build(rule, row);
            ++rowIndex;
        }
    }

    public void deleteColumns(int firstColumnIndex, int numberOfColumns) {
        Collection all = this.index.columns.where(HasIndex.index().is(Integer.valueOf(firstColumnIndex))).select().all();
        Fields.FieldSelector fieldSelector = this.index.rules.where(UUIDMatcher.uuid().any()).select().patterns().where(UUIDMatcher.uuid().any()).select().fields().where(UUIDMatcher.uuid().any()).select();
        ArrayList actions = new ArrayList();
        ArrayList conditions = new ArrayList();
        for (Field field : fieldSelector.all()) {
            for (Column column : all) {
                Collection all1 = field.getActions().where(Action.columnUUID().is(column.getUuidKey())).select().all();
                Collection all2 = field.getConditions().where(Condition.columnUUID().is(column.getUuidKey())).select().all();
                actions.addAll(all1);
                conditions.addAll(all2);
            }
        }
        for (Action action : actions) {
            action.getUuidKey().retract();
        }
        for (Condition condition : conditions) {
            condition.getUuidKey().retract();
        }
        for (Column column : all) {
            column.getUuidKey().retract();
        }
        this.reset();
    }

    public void reset() {
        this.ruleInspectors.clear();
        for (Rule rule : this.index.rules.where(Rule.uuid().any()).select().all()) {
            this.add(new RuleInspector(rule, this.checkManager, this));
        }
    }

    public Collection<RuleInspector> all() {
        return this.ruleInspectors.values();
    }

    public Collection<RuleInspector> all(Filter filter) {
        ArrayList<RuleInspector> result = new ArrayList<RuleInspector>();
        for (RuleInspector ruleInspector : this.all()) {
            if (!filter.accept(ruleInspector)) continue;
            result.add(ruleInspector);
        }
        return result;
    }

    private void add(RuleInspector ruleInspector) {
        this.ruleInspectors.put(ruleInspector.getRule(), ruleInspector);
    }

    public RuleInspector removeRow(int rowNumber) {
        Rule rule = this.getRule(rowNumber);
        RuleInspector remove = this.ruleInspectors.remove(rule);
        this.index.rules.remove(rule);
        return remove;
    }

    private Rule getRule(int rowNumber) {
        return (Rule)this.index.rules.where(HasIndex.index().is(Integer.valueOf(rowNumber))).select().first();
    }

    public RuleInspector addRow(int index) {
        Rule rule = new RuleBuilder(this.index, this.model, index, (List)this.model.getData().get(index), this.utils).build();
        this.index.rules.add(rule);
        RuleInspector ruleInspector = new RuleInspector(rule, this.checkManager, this);
        this.add(ruleInspector);
        return ruleInspector;
    }

    public RuleInspector getRuleInspector(int row) {
        return this.ruleInspectors.get(this.getRule(row));
    }

    public Collection<RuleInspector> allRuleInspectors() {
        return this.ruleInspectors.values();
    }

    public static interface Filter {
        public boolean accept(RuleInspector var1);
    }
}

