/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache;

import java.util.HashSet;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.RuleInspectorCache;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.Check;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.CheckRunner;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Action;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.ActionBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Actions;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Column;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Condition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Conditions;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Index;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Rule;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Values;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.data.Coordinate;
import org.uberfire.commons.validation.PortablePreconditions;

public class UpdateManager {
    private static final int ROW_NUMBER_COLUMN = 0;
    private static final int DESCRIPTION_COLUMN = 1;
    private final Index index;
    private final GuidedDecisionTable52 model;
    private final CheckRunner checkRunner;
    private RuleInspectorCache cache;

    public UpdateManager(Index index, GuidedDecisionTable52 model, RuleInspectorCache cache, CheckRunner checkRunner) {
        this.index = (Index)PortablePreconditions.checkNotNull((String)"index", (Object)index);
        this.model = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"model", (Object)model);
        this.cache = (RuleInspectorCache)PortablePreconditions.checkNotNull((String)"cache", (Object)cache);
        this.checkRunner = (CheckRunner)PortablePreconditions.checkNotNull((String)"updateHandler", (Object)checkRunner);
    }

    public boolean update(List<Coordinate> coordinates) {
        HashSet<Check> checks = new HashSet<Check>();
        for (Coordinate coordinate : coordinates) {
            if (coordinate.getCol() == 0 || coordinate.getCol() == 1 || !new CellUpdateManager(coordinate).update()) continue;
            checks.addAll(this.cache.getRuleInspector(coordinate.getRow()).getChecks());
        }
        if (!checks.isEmpty()) {
            this.checkRunner.addChecks(checks);
        }
        return !checks.isEmpty();
    }

    private class CellUpdateManager {
        private final Column column;
        private final Actions actions;
        private final Conditions conditions;
        private final Values values;

        public CellUpdateManager(Coordinate coordinate) {
            this.column = (Column)((UpdateManager)UpdateManager.this).index.columns.where(Column.index().is(Integer.valueOf(coordinate.getCol()))).select().first();
            Rule rule = (Rule)((UpdateManager)UpdateManager.this).index.rules.where(Rule.index().is(Integer.valueOf(coordinate.getRow()))).select().first();
            this.actions = rule.getActions();
            this.conditions = rule.getConditions();
            this.values = this.getValue((DTCellValue52)((List)UpdateManager.this.model.getData().get(coordinate.getRow())).get(coordinate.getCol()));
        }

        public boolean update() {
            if (!this.updateCondition()) {
                return this.updateAction();
            }
            return true;
        }

        private boolean updateAction() {
            Action action = (Action)this.actions.where(Action.columnUUID().is(this.column.getUuidKey())).select().first();
            if (action != null) {
                return this.updateAction(action);
            }
            return false;
        }

        private boolean updateAction(Action action) {
            Values<Comparable> comparable = action.getValues();
            if (this.values.isThereChanges(comparable)) {
                action.setValue(this.values);
                return true;
            }
            return false;
        }

        private boolean updateCondition() {
            Condition condition = (Condition)this.conditions.where(Condition.columnUUID().is(this.column.getUuidKey())).select().first();
            if (condition != null) {
                return this.updateCondition(condition);
            }
            return false;
        }

        private boolean updateCondition(Condition condition) {
            Values<Comparable> oldValues = condition.getValues();
            if (this.values == null && oldValues == null) {
                return false;
            }
            if (this.values == null || oldValues == null) {
                condition.setValue(this.values);
                return true;
            }
            if (this.values.isThereChanges(oldValues)) {
                condition.setValue(this.values);
                return true;
            }
            return false;
        }

        private Values getValue(DTCellValue52 cell) {
            Comparable value = ActionBuilder.getValue(cell);
            if (value == null) {
                return new Values();
            }
            if (value instanceof String && ((String)((Object)value)).isEmpty()) {
                return new Values();
            }
            Values values = new Values();
            values.add(value);
            return values;
        }
    }
}

