/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors;

import java.util.Collection;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.RuleInspectorUpdater;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.action.ActionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.action.ActionInspectorFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition.ConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition.ConditionInspectorFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasConflicts;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasKeys;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasUUID;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.InspectorList;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.UpdatableInspectorList;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.Conflict;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.HumanReadable;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsConflicting;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsRedundant;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsSubsuming;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Action;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Condition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Field;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.ObjectField;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Key;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.UUIDKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.select.AllListener;
import org.uberfire.commons.validation.PortablePreconditions;

public class FieldInspector
implements HasConflicts,
IsConflicting,
IsSubsuming,
IsRedundant,
HumanReadable,
HasKeys {
    private final ObjectField objectField;
    private final UpdatableInspectorList<ActionInspector, Action> actionInspectorList = new UpdatableInspectorList<ActionInspector, Action>(new ActionInspectorFactory());
    private final UpdatableInspectorList<ConditionInspector, Condition> conditionInspectorList = new UpdatableInspectorList<ConditionInspector, Condition>(new ConditionInspectorFactory());
    private final UUIDKey uuidKey = new UUIDKey(this);
    private final RuleInspectorUpdater ruleInspectorUpdater;

    public FieldInspector(Field field, RuleInspectorUpdater ruleInspectorUpdater) {
        this(field.getObjectField(), ruleInspectorUpdater);
        this.updateActionInspectors(field.getActions().where(Action.value().any()).select().all());
        this.updateConditionInspectors(field.getConditions().where(Condition.value().any()).select().all());
        this.setupActionsListener(field);
        this.setupConditionsListener(field);
    }

    public FieldInspector(ObjectField field, RuleInspectorUpdater ruleInspectorUpdater) {
        this.objectField = (ObjectField)PortablePreconditions.checkNotNull((String)"field", (Object)field);
        this.ruleInspectorUpdater = (RuleInspectorUpdater)PortablePreconditions.checkNotNull((String)"ruleInspectorUpdater", (Object)ruleInspectorUpdater);
    }

    private void setupConditionsListener(Field field) {
        field.getConditions().where(Condition.value().any()).listen().all(new AllListener<Condition>(){

            @Override
            public void onAllChanged(Collection<Condition> all) {
                FieldInspector.this.updateConditionInspectors(all);
                FieldInspector.this.ruleInspectorUpdater.resetConditionsInspectors();
            }
        });
    }

    private void setupActionsListener(Field field) {
        field.getActions().where(Action.value().any()).listen().all(new AllListener<Action>(){

            @Override
            public void onAllChanged(Collection<Action> all) {
                FieldInspector.this.updateActionInspectors(all);
                FieldInspector.this.ruleInspectorUpdater.resetActionsInspectors();
            }
        });
    }

    public ObjectField getObjectField() {
        return this.objectField;
    }

    private void updateConditionInspectors(Collection<Condition> all) {
        this.conditionInspectorList.update(all);
    }

    private void updateActionInspectors(Collection<Action> all) {
        this.actionInspectorList.update(all);
    }

    public InspectorList<ActionInspector> getActionInspectorList() {
        return this.actionInspectorList;
    }

    public InspectorList<ConditionInspector> getConditionInspectorList() {
        return this.conditionInspectorList;
    }

    @Override
    public Conflict hasConflicts() {
        int index = 1;
        for (ConditionInspector conditionInspector : this.conditionInspectorList) {
            for (int j = index; j < this.conditionInspectorList.size(); ++j) {
                if (!conditionInspector.conflicts(this.conditionInspectorList.get(j))) continue;
                return new Conflict(conditionInspector, (HasUUID)this.conditionInspectorList.get(j));
            }
            ++index;
        }
        return Conflict.EMPTY;
    }

    public boolean conflicts(Object other) {
        if (other instanceof FieldInspector && this.objectField.equals(((FieldInspector)other).objectField)) {
            boolean conflicting = this.actionInspectorList.conflicts(((FieldInspector)other).actionInspectorList);
            if (conflicting) {
                return true;
            }
            return this.conditionInspectorList.conflicts(((FieldInspector)other).conditionInspectorList);
        }
        return false;
    }

    public boolean isRedundant(Object other) {
        if (other instanceof FieldInspector && this.objectField.equals(((FieldInspector)other).objectField)) {
            return this.actionInspectorList.isRedundant(((FieldInspector)other).actionInspectorList) && this.conditionInspectorList.isRedundant(((FieldInspector)other).conditionInspectorList);
        }
        return false;
    }

    public boolean subsumes(Object other) {
        if (other instanceof FieldInspector && this.objectField.equals(((FieldInspector)other).objectField)) {
            return this.actionInspectorList.subsumes(((FieldInspector)other).actionInspectorList) && this.conditionInspectorList.subsumes(((FieldInspector)other).conditionInspectorList);
        }
        return false;
    }

    @Override
    public String toHumanReadableString() {
        return this.objectField.getName();
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    @Override
    public Key[] keys() {
        return new Key[]{this.uuidKey};
    }
}

