/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors;

import java.util.Collection;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.FieldInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.RuleInspectorUpdater;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.action.ActionsInspectorMultiMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition.ConditionsInspectorMultiMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasConflicts;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasKeys;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.InspectorList;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.Conflict;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.HumanReadable;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsConflicting;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsRedundant;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsSubsuming;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.RelationResolver;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Field;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.ObjectField;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Pattern;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Key;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.UUIDKey;
import org.uberfire.commons.validation.PortablePreconditions;

public class PatternInspector
implements HasConflicts,
IsConflicting,
IsSubsuming,
IsRedundant,
HumanReadable,
HasKeys {
    private final UUIDKey uuidKey = new UUIDKey(this);
    private final Pattern pattern;
    private final InspectorList<FieldInspector> inspectorList = new InspectorList();
    private final RelationResolver relationResolver;

    public PatternInspector(Pattern pattern, RuleInspectorUpdater ruleInspectorUpdater) {
        this.pattern = (Pattern)PortablePreconditions.checkNotNull((String)"pattern", (Object)pattern);
        this.relationResolver = new RelationResolver(this.inspectorList);
        this.makeFieldInspectors(pattern.getFields().where(Field.uuid().any()).select().all(), ruleInspectorUpdater);
    }

    private void makeFieldInspectors(Collection<Field> fields, RuleInspectorUpdater ruleInspectorUpdater) {
        this.inspectorList.clear();
        for (Field field : fields) {
            this.inspectorList.add(new FieldInspector(field, ruleInspectorUpdater));
        }
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean conflicts(Object other) {
        if (other instanceof PatternInspector) {
            if (this.pattern.getObjectType().getType().equals(((PatternInspector)other).getPattern().getObjectType().getType())) {
                return this.inspectorList.conflicts(((PatternInspector)other).inspectorList);
            }
            return false;
        }
        return false;
    }

    public boolean isRedundant(Object other) {
        if (other instanceof PatternInspector) {
            if (this.pattern.getObjectType().getType().equals(((PatternInspector)other).getPattern().getObjectType().getType())) {
                return this.inspectorList.isRedundant(((PatternInspector)other).inspectorList);
            }
            return false;
        }
        return false;
    }

    public boolean subsumes(Object other) {
        if (other instanceof PatternInspector) {
            if (this.pattern.getObjectType().getType().equals(((PatternInspector)other).getPattern().getObjectType().getType())) {
                return this.inspectorList.subsumes(((PatternInspector)other).inspectorList);
            }
            return false;
        }
        return false;
    }

    @Override
    public Conflict hasConflicts() {
        return this.relationResolver.resolveConflict(this.inspectorList);
    }

    public ActionsInspectorMultiMap getActionsInspector() {
        ActionsInspectorMultiMap<ObjectField> actionsInspector = new ActionsInspectorMultiMap<ObjectField>();
        for (FieldInspector fieldInspector : this.inspectorList) {
            actionsInspector.addAllValues(fieldInspector.getObjectField(), fieldInspector.getActionInspectorList());
        }
        return actionsInspector;
    }

    public ConditionsInspectorMultiMap getConditionsInspector() {
        ConditionsInspectorMultiMap conditionsInspector = new ConditionsInspectorMultiMap();
        for (FieldInspector fieldInspector : this.inspectorList) {
            conditionsInspector.addAllValues(fieldInspector.getObjectField(), fieldInspector.getConditionInspectorList());
        }
        return conditionsInspector;
    }

    @Override
    public String toHumanReadableString() {
        return this.pattern.getName();
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    @Override
    public Key[] keys() {
        return new Key[]{this.uuidKey};
    }
}

