/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors;

import java.util.Collection;
import java.util.Set;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.RuleInspectorCache;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.PatternInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.RuleInspectorUpdater;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.action.ActionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.action.ActionsInspectorMultiMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.action.BRLActionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition.BRLConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition.ConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition.ConditionsInspectorMultiMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasKeys;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.maps.InspectorList;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.Check;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.CheckManager;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.HumanReadable;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsConflicting;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsDeficient;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsRedundant;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsSubsuming;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Action;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.ActionSuperType;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.BRLAction;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.BRLCondition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Condition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.ConditionSuperType;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Conditions;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Field;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.FieldCondition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Pattern;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Rule;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Key;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.UUIDKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.select.AllListener;
import org.uberfire.commons.validation.PortablePreconditions;

public class RuleInspector
implements IsRedundant,
IsSubsuming,
IsConflicting,
IsDeficient<RuleInspector>,
HumanReadable,
HasKeys {
    private final Rule rule;
    private final CheckManager checkManager;
    private final RuleInspectorCache cache;
    private final UUIDKey uuidKey = new UUIDKey(this);
    private final InspectorList<PatternInspector> patternInspectorList = new InspectorList();
    private final InspectorList<ConditionInspector> brlConditionsInspectors = new InspectorList(true);
    private final InspectorList<ActionInspector> brlActionInspectors = new InspectorList(true);
    private InspectorList<ActionsInspectorMultiMap> actionsInspectors = null;
    private InspectorList<ConditionsInspectorMultiMap> conditionsInspectors = null;

    public RuleInspector(Rule rule, CheckManager checkManager, RuleInspectorCache cache) {
        this.rule = (Rule)PortablePreconditions.checkNotNull((String)"rule", (Object)rule);
        this.checkManager = (CheckManager)PortablePreconditions.checkNotNull((String)"checkManager", (Object)checkManager);
        this.cache = (RuleInspectorCache)PortablePreconditions.checkNotNull((String)"cache", (Object)cache);
        this.makePatternsInspectors();
        this.makeBRLActionInspectors();
        this.makeBRLConditionInspectors();
        this.makeChecks();
    }

    private void makeConditionsInspectors() {
        this.conditionsInspectors = new InspectorList(true);
        for (PatternInspector patternInspector : this.patternInspectorList) {
            this.conditionsInspectors.add(patternInspector.getConditionsInspector());
        }
    }

    private void makeActionsInspectors() {
        this.actionsInspectors = new InspectorList(true);
        for (PatternInspector patternInspector : this.patternInspectorList) {
            this.actionsInspectors.add(patternInspector.getActionsInspector());
        }
    }

    private void makeBRLConditionInspectors() {
        this.updateBRLConditionInspectors(this.rule.getConditions().where(Condition.superType().is((Comparable)((Object)ConditionSuperType.BRL_CONDITION))).select().all());
        this.rule.getConditions().where(Condition.superType().is((Comparable)((Object)ConditionSuperType.BRL_CONDITION))).listen().all(new AllListener<Condition>(){

            @Override
            public void onAllChanged(Collection<Condition> all) {
                RuleInspector.this.updateBRLConditionInspectors(all);
            }
        });
    }

    private void makeBRLActionInspectors() {
        this.updateBRLActionInspectors(this.rule.getActions().where(Action.superType().is((Comparable)((Object)ActionSuperType.BRL_ACTION))).select().all());
        this.rule.getActions().where(Action.superType().is((Comparable)((Object)ActionSuperType.BRL_ACTION))).listen().all(new AllListener<Action>(){

            @Override
            public void onAllChanged(Collection<Action> all) {
                RuleInspector.this.updateBRLActionInspectors(all);
            }
        });
    }

    private void makePatternsInspectors() {
        for (Pattern pattern : this.rule.getPatterns().where(Pattern.uuid().any()).select().all()) {
            PatternInspector patternInspector = new PatternInspector(pattern, new RuleInspectorUpdater(){

                @Override
                public void resetActionsInspectors() {
                    RuleInspector.this.actionsInspectors = null;
                }

                @Override
                public void resetConditionsInspectors() {
                    RuleInspector.this.conditionsInspectors = null;
                }
            });
            this.patternInspectorList.add(patternInspector);
        }
    }

    private void updateBRLConditionInspectors(Collection<Condition> conditions) {
        this.brlConditionsInspectors.clear();
        for (Condition condition : conditions) {
            this.brlConditionsInspectors.add(new BRLConditionInspector((BRLCondition)condition));
        }
    }

    private void updateBRLActionInspectors(Collection<Action> actions) {
        this.brlActionInspectors.clear();
        for (Action action : actions) {
            this.brlActionInspectors.add(new BRLActionInspector((BRLAction)action));
        }
    }

    public InspectorList<ConditionsInspectorMultiMap> getConditionsInspectors() {
        if (this.conditionsInspectors == null) {
            this.makeConditionsInspectors();
        }
        return this.conditionsInspectors;
    }

    public InspectorList<ActionsInspectorMultiMap> getActionsInspectors() {
        if (this.actionsInspectors == null) {
            this.makeActionsInspectors();
        }
        return this.actionsInspectors;
    }

    public InspectorList<PatternInspector> getPatternsInspector() {
        return this.patternInspectorList;
    }

    public int getRowIndex() {
        return this.rule.getRowNumber();
    }

    public RuleInspectorCache getCache() {
        return this.cache;
    }

    public boolean isRedundant(Object other) {
        return other instanceof RuleInspector && this.brlConditionsInspectors.isRedundant(((RuleInspector)other).brlConditionsInspectors) && this.brlActionInspectors.isRedundant(((RuleInspector)other).brlActionInspectors) && this.getActionsInspectors().isRedundant(((RuleInspector)other).getActionsInspectors()) && this.getConditionsInspectors().isRedundant(((RuleInspector)other).getConditionsInspectors());
    }

    public boolean subsumes(Object other) {
        return other instanceof RuleInspector && this.brlActionInspectors.subsumes(((RuleInspector)other).brlActionInspectors) && this.brlConditionsInspectors.subsumes(((RuleInspector)other).brlConditionsInspectors) && this.getActionsInspectors().subsumes(((RuleInspector)other).getActionsInspectors()) && this.getConditionsInspectors().subsumes(((RuleInspector)other).getConditionsInspectors());
    }

    public boolean conflicts(Object other) {
        return other instanceof RuleInspector && this.getActionsInspectors().conflicts(((RuleInspector)other).getActionsInspectors()) && this.getConditionsInspectors().subsumes(((RuleInspector)other).getConditionsInspectors());
    }

    public Rule getRule() {
        return this.rule;
    }

    @Override
    public boolean isDeficient(RuleInspector other) {
        if (other.atLeastOneActionHasAValue() && !this.getActionsInspectors().conflicts(other.getActionsInspectors())) {
            return false;
        }
        Collection allConditionsFromTheOtherRule = other.rule.getConditions().where(Condition.value().any()).select().all();
        if (allConditionsFromTheOtherRule.isEmpty()) {
            return true;
        }
        for (Condition condition : allConditionsFromTheOtherRule) {
            if (condition.getValues() == null || !(condition instanceof FieldCondition)) continue;
            FieldCondition fieldCondition = (FieldCondition)condition;
            Conditions conditions = this.rule.getPatterns().where(Pattern.name().is((Comparable)((Object)fieldCondition.getField().getFactType()))).select().fields().where(Field.name().is((Comparable)((Object)fieldCondition.getField().getName()))).select().conditions();
            if (!conditions.where(Condition.value().any()).select().exists()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return !this.atLeastOneConditionHasAValue() && !this.atLeastOneActionHasAValue();
    }

    public boolean atLeastOneActionHasAValue() {
        int amountOfActions = this.rule.getActions().where(Action.value().any()).select().all().size();
        return amountOfActions > 0;
    }

    public boolean atLeastOneConditionHasAValue() {
        int amountOfConditions = this.rule.getConditions().where(Condition.value().any()).select().all().size();
        return amountOfConditions > 0;
    }

    @Override
    public String toHumanReadableString() {
        return this.rule.getRowNumber().toString();
    }

    public InspectorList<ConditionInspector> getBrlConditionsInspectors() {
        return this.brlConditionsInspectors;
    }

    public InspectorList<ActionInspector> getBrlActionInspectors() {
        return this.brlActionInspectors;
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    @Override
    public Key[] keys() {
        return new Key[]{this.uuidKey};
    }

    public Set<Check> getChecks() {
        return this.checkManager.getChecks(this);
    }

    private void makeChecks() {
        this.checkManager.makeChecks(this);
    }

    public Set<Check> clearChecks() {
        return this.checkManager.remove(this);
    }
}

