/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.action;

import com.google.gwt.i18n.client.DateTimeFormat;
import java.util.Date;
import java.util.Iterator;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasKeys;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.HumanReadable;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsConflicting;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsRedundant;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsSubsuming;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Action;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Key;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.UUIDKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Values;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;

public abstract class ActionInspector
implements IsRedundant,
IsSubsuming,
IsConflicting,
HumanReadable,
HasKeys {
    private static final String DATE_FORMAT = ApplicationPreferences.getDroolsDateFormat();
    private UUIDKey uuidKey = new UUIDKey(this);
    private static final DateTimeFormat DATE_FORMATTER = DateTimeFormat.getFormat((String)DATE_FORMAT);
    protected Action action;

    protected ActionInspector(Action action) {
        this.action = action;
    }

    public boolean isRedundant(Object other) {
        if (other instanceof ActionInspector) {
            return this.areValuesRedundant(((ActionInspector)other).action.getValues());
        }
        return false;
    }

    private boolean areValuesRedundant(Values<Comparable> others) {
        for (Comparable comparable : this.action.getValues()) {
            if (this.isValueRedundant(others, comparable)) continue;
            return false;
        }
        for (Comparable comparable : others) {
            if (this.isValueRedundant(this.action.getValues(), comparable)) continue;
            return false;
        }
        return !this.action.getValues().isEmpty() || !others.isEmpty();
    }

    private boolean isValueRedundant(Values<Comparable> others, Comparable comparable) {
        for (Comparable other : others) {
            if (!this.isValueRedundant(comparable, other)) continue;
            return true;
        }
        return false;
    }

    private boolean isValueRedundant(Comparable value, Comparable other) {
        if (value.equals(other)) {
            return true;
        }
        if (value instanceof Date) {
            return this.areDatesEqual((Date)value, other);
        }
        if (other instanceof Date) {
            return this.areDatesEqual((Date)other, value);
        }
        return value.toString().equals(other.toString());
    }

    private boolean areDatesEqual(Date value, Comparable other) {
        if (other instanceof String) {
            return this.format(value).toString().equals(other);
        }
        return false;
    }

    protected String format(Date dateValue) {
        return DATE_FORMATTER.format(dateValue);
    }

    public boolean conflicts(Object other) {
        if (other instanceof ActionInspector) {
            ActionInspector otherActionInspector = (ActionInspector)other;
            return !this.areValuesRedundant(otherActionInspector.action.getValues());
        }
        return false;
    }

    public boolean subsumes(Object other) {
        return this.isRedundant(other);
    }

    @Override
    public String toHumanReadableString() {
        StringBuilder builder = new StringBuilder();
        Iterator iterator = this.action.getValues().iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public boolean hasValue() {
        return this.action.getValues().isEmpty();
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    @Override
    public Key[] keys() {
        return new Key[0];
    }
}

