/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition;

import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition.ConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.Covers;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.Operator;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Field;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.FieldCondition;

public class ComparableConditionInspector<T extends Comparable<T>>
extends ConditionInspector<T>
implements Covers<T> {
    protected final Field field;
    protected final Operator operator;

    public ComparableConditionInspector(FieldCondition condition) {
        super(condition);
        this.field = condition.getField();
        this.operator = Operator.resolve(condition.getOperator());
    }

    public Field getField() {
        return this.field;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public boolean conflicts(Object other) {
        if (other instanceof ComparableConditionInspector) {
            if (!this.field.equals(((ComparableConditionInspector)other).field)) {
                return false;
            }
            switch (((ComparableConditionInspector)other).getOperator()) {
                case NOT_EQUALS: {
                    switch (this.operator) {
                        case NOT_EQUALS: {
                            return false;
                        }
                    }
                }
            }
            boolean overlaps = this.overlaps(other);
            boolean overlapsNOT = !overlaps;
            return overlapsNOT;
        }
        return false;
    }

    @Override
    public boolean overlaps(Object other) {
        if (other instanceof ComparableConditionInspector) {
            ComparableConditionInspector anotherPoint = (ComparableConditionInspector)other;
            if (!this.field.equals(anotherPoint.field)) {
                return false;
            }
            if (anotherPoint != null) {
                switch (anotherPoint.getOperator()) {
                    case NOT_EQUALS: {
                        switch (this.operator) {
                            case EQUALS: {
                                return !this.getValue().equals(anotherPoint.getValue());
                            }
                        }
                        return true;
                    }
                    case EQUALS: {
                        switch (this.operator) {
                            case NOT_EQUALS: {
                                return !this.getValue().equals(anotherPoint.getValue());
                            }
                        }
                        return this.covers((Comparable<T>)anotherPoint.getValue());
                    }
                    case GREATER_OR_EQUAL: {
                        switch (this.operator) {
                            case NOT_EQUALS: {
                                return true;
                            }
                            case LESS_THAN: 
                            case BEFORE: {
                                return anotherPoint.covers((Comparable<T>)this.getValue()) && this.covers((Comparable<T>)anotherPoint.getValue());
                            }
                        }
                        return this.covers((Comparable<T>)anotherPoint.getValue()) || anotherPoint.covers((Comparable<T>)this.getValue());
                    }
                    case LESS_OR_EQUAL: {
                        switch (this.operator) {
                            case NOT_EQUALS: {
                                return true;
                            }
                            case GREATER_THAN: 
                            case AFTER: {
                                return anotherPoint.covers((Comparable<T>)this.getValue()) && this.covers((Comparable<T>)anotherPoint.getValue());
                            }
                        }
                        return this.covers((Comparable<T>)anotherPoint.getValue()) || anotherPoint.covers((Comparable<T>)this.getValue());
                    }
                    case LESS_THAN: 
                    case BEFORE: {
                        switch (this.operator) {
                            case EQUALS: {
                                return anotherPoint.covers((Comparable<T>)this.getValue());
                            }
                            case NOT_EQUALS: {
                                return true;
                            }
                            case LESS_THAN: 
                            case BEFORE: {
                                return this.valueIsEqualTo(anotherPoint.getValue()) || anotherPoint.covers((Comparable<T>)this.getValue()) || this.covers((Comparable<T>)anotherPoint.getValue());
                            }
                            case GREATER_OR_EQUAL: {
                                return anotherPoint.covers((Comparable<T>)this.getValue()) && this.covers((Comparable<T>)anotherPoint.getValue());
                            }
                        }
                        return this.covers((Comparable<T>)anotherPoint.getValue()) || anotherPoint.covers((Comparable<T>)this.getValue());
                    }
                    case GREATER_THAN: 
                    case AFTER: {
                        switch (this.operator) {
                            case EQUALS: {
                                return anotherPoint.covers((Comparable<T>)this.getValue());
                            }
                            case NOT_EQUALS: {
                                return true;
                            }
                            case GREATER_THAN: 
                            case AFTER: {
                                return this.valueIsEqualTo(anotherPoint.getValue()) || anotherPoint.covers((Comparable<T>)this.getValue()) || this.covers((Comparable<T>)anotherPoint.getValue());
                            }
                            case LESS_OR_EQUAL: {
                                return anotherPoint.covers((Comparable<T>)this.getValue()) && this.covers((Comparable<T>)anotherPoint.getValue());
                            }
                        }
                        return this.covers((Comparable<T>)anotherPoint.getValue()) || anotherPoint.covers((Comparable<T>)this.getValue());
                    }
                    case IN: {
                        return anotherPoint.covers((Comparable<T>)this.getValue());
                    }
                    case NOT_IN: {
                        boolean b = anotherPoint.covers((Comparable<T>)this.getValue());
                        return b;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean subsumes(Object other) {
        if (other instanceof ComparableConditionInspector) {
            ComparableConditionInspector anotherPoint = (ComparableConditionInspector)other;
            if (!this.field.equals(anotherPoint.field)) {
                return false;
            }
            if (anotherPoint != null) {
                switch (anotherPoint.getOperator()) {
                    case NOT_EQUALS: {
                        switch (this.operator) {
                            case NOT_EQUALS: {
                                return this.getValue().equals(anotherPoint.getValue());
                            }
                            case EQUALS: {
                                boolean valueIsEqualTo = this.valueIsEqualTo(anotherPoint.getValue());
                                boolean covers = this.covers((Comparable<T>)anotherPoint.getValue());
                                return !valueIsEqualTo && !covers;
                            }
                        }
                        return false;
                    }
                    case EQUALS: {
                        switch (this.operator) {
                            case NOT_EQUALS: {
                                boolean valueIsEqualTo = this.valueIsEqualTo(anotherPoint.getValue());
                                boolean covers = this.covers((Comparable<T>)anotherPoint.getValue());
                                return !valueIsEqualTo && !covers;
                            }
                        }
                        return this.covers((Comparable<T>)anotherPoint.getValue());
                    }
                    case GREATER_OR_EQUAL: {
                        switch (this.operator) {
                            case GREATER_THAN: 
                            case GREATER_OR_EQUAL: {
                                return this.covers((Comparable<T>)anotherPoint.getValue());
                            }
                            case NOT_EQUALS: {
                                return this.valueIsGreaterThan(anotherPoint.getValue());
                            }
                        }
                        return false;
                    }
                    case LESS_OR_EQUAL: {
                        switch (this.operator) {
                            case LESS_THAN: 
                            case LESS_OR_EQUAL: {
                                return this.covers((Comparable<T>)anotherPoint.getValue());
                            }
                            case NOT_EQUALS: {
                                return this.valueIsLessThan(anotherPoint.getValue());
                            }
                        }
                        return false;
                    }
                    case LESS_THAN: {
                        switch (this.operator) {
                            case LESS_OR_EQUAL: {
                                return this.covers((Comparable<T>)anotherPoint.getValue());
                            }
                            case NOT_EQUALS: 
                            case LESS_THAN: {
                                return this.valueIsLessThanOrEqualTo(anotherPoint.getValue());
                            }
                        }
                        return false;
                    }
                    case GREATER_THAN: {
                        switch (this.operator) {
                            case GREATER_OR_EQUAL: {
                                return this.covers((Comparable<T>)anotherPoint.getValue());
                            }
                            case NOT_EQUALS: 
                            case GREATER_THAN: {
                                return this.valueIsGreaterThanOrEqualTo(anotherPoint.getValue());
                            }
                        }
                        return false;
                    }
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean covers(Comparable<T> otherValue) {
        if (otherValue instanceof Comparable) {
            switch (this.operator) {
                case EQUALS: {
                    return this.valueIsEqualTo(otherValue);
                }
                case NOT_EQUALS: {
                    return !this.valueIsEqualTo(otherValue);
                }
                case GREATER_OR_EQUAL: {
                    return this.valueIsGreaterThanOrEqualTo(otherValue);
                }
                case LESS_OR_EQUAL: {
                    return this.valueIsLessThanOrEqualTo(otherValue);
                }
                case LESS_THAN: 
                case BEFORE: {
                    return this.valueIsLessThan(otherValue);
                }
                case GREATER_THAN: 
                case AFTER: {
                    return this.valueIsGreaterThan(otherValue);
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public String toHumanReadableString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.field.getFactType());
        stringBuilder.append(".");
        stringBuilder.append(this.field.getName());
        stringBuilder.append(" ");
        stringBuilder.append((Object)this.operator);
        stringBuilder.append(" ");
        stringBuilder.append(this.getValue());
        return stringBuilder.toString();
    }
}

