/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition;

import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasKeys;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.util.HasUUID;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.HumanReadable;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsConflicting;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsOverlapping;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsRedundant;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsSubsuming;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Condition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Key;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.UUIDKey;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Values;

public abstract class ConditionInspector<T extends Comparable<T>>
implements IsRedundant,
IsOverlapping,
IsSubsuming,
IsConflicting,
HumanReadable,
HasKeys {
    private final UUIDKey uuidKey = new UUIDKey(this);
    private Condition<T> condition;

    public ConditionInspector(Condition<T> condition) {
        this.condition = condition;
    }

    public Condition<T> getCondition() {
        return this.condition;
    }

    public T getValue() {
        if (this.condition.getValues().isEmpty()) {
            return null;
        }
        return (T)((Comparable)this.condition.getValues().iterator().next());
    }

    protected boolean valueIsGreaterThanOrEqualTo(Comparable<T> otherValue) {
        return this.valueIsEqualTo(otherValue) || this.valueIsGreaterThan(otherValue);
    }

    protected boolean valueIsLessThanOrEqualTo(Comparable<T> otherValue) {
        return this.valueIsEqualTo(otherValue) || this.valueIsLessThan(otherValue);
    }

    protected boolean valueIsGreaterThan(Comparable<T> otherValue) {
        return otherValue.compareTo(this.getValue()) > 0;
    }

    protected boolean valueIsLessThan(Comparable<T> otherValue) {
        return otherValue.compareTo(this.getValue()) < 0;
    }

    protected boolean valueIsEqualTo(Comparable<T> otherValue) {
        if (otherValue == null) {
            return this.getValue() == null;
        }
        if (this.getValue() == null) {
            return false;
        }
        return otherValue.compareTo(this.getValue()) == 0;
    }

    public boolean isRedundant(Object object) {
        if (object instanceof IsSubsuming) {
            return this.subsumes(object) && ((IsSubsuming)object).subsumes(this);
        }
        return false;
    }

    public Values<Comparable> getValues() {
        return this.condition.getValues();
    }

    public boolean hasValue() {
        return !this.condition.getValues().isEmpty();
    }

    @Override
    public abstract String toHumanReadableString();

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof HasUUID) {
            return this.uuidKey.equals(((HasUUID)obj).getUuidKey());
        }
        return false;
    }

    public int hashCode() {
        return this.toHumanReadableString().hashCode();
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    @Override
    public Key[] keys() {
        return new Key[]{this.uuidKey};
    }
}

