/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.IsSubsuming;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.Operator;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.FieldCondition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Values;

public class StringConditionInspector
extends ComparableConditionInspector<String> {
    private static final Set<Operator> LEGAL_OPERATORS = StringConditionInspector.getLegalOperators();

    private static HashSet<Operator> getLegalOperators() {
        HashSet<Operator> operators = new HashSet<Operator>();
        operators.add(Operator.MATCHES);
        operators.add(Operator.NOT_MATCHES);
        operators.add(Operator.EQUALS);
        operators.add(Operator.NOT_EQUALS);
        operators.add(Operator.CONTAINS);
        operators.add(Operator.NOT_CONTAINS);
        operators.add(Operator.IN);
        operators.add(Operator.NOT_IN);
        operators.add(Operator.SOUNDSLIKE);
        return operators;
    }

    public StringConditionInspector(FieldCondition<String> fieldInspector) {
        super(fieldInspector);
    }

    @Override
    public boolean isRedundant(Object other) {
        if (this.equals(other)) {
            return true;
        }
        if (other instanceof IsSubsuming) {
            boolean b = this.subsumes(other) && ((IsSubsuming)other).subsumes(this);
            return b;
        }
        return false;
    }

    @Override
    public boolean conflicts(Object other) {
        if (this.equals(other)) {
            return false;
        }
        if (other instanceof StringConditionInspector) {
            if (!LEGAL_OPERATORS.contains((Object)this.operator) || !LEGAL_OPERATORS.contains((Object)((StringConditionInspector)other).operator)) {
                return false;
            }
            if (!this.hasValue() || !((StringConditionInspector)other).hasValue()) {
                return false;
            }
            if ((this.doesNotContainAll(((StringConditionInspector)other).getValues()) || ((StringConditionInspector)other).doesNotContainAll(this.getValues())) && (this.eitherOperatorIs((StringConditionInspector)other, Operator.LESS_THAN) || this.eitherOperatorIs((StringConditionInspector)other, Operator.LESS_OR_EQUAL) || this.eitherOperatorIs((StringConditionInspector)other, Operator.GREATER_THAN) || this.eitherOperatorIs((StringConditionInspector)other, Operator.GREATER_OR_EQUAL))) {
                return false;
            }
            if (this.operatorsAre((StringConditionInspector)other, Operator.NOT_EQUALS)) {
                return false;
            }
        }
        boolean conflicts = !this.overlaps(other);
        return conflicts;
    }

    private boolean eitherOperatorIs(StringConditionInspector other, Operator operator) {
        return other.getOperator().equals((Object)operator) || this.operator.equals((Object)operator);
    }

    @Override
    public boolean overlaps(Object other) {
        if (other instanceof StringConditionInspector) {
            if (!LEGAL_OPERATORS.contains((Object)this.operator) || !LEGAL_OPERATORS.contains((Object)((StringConditionInspector)other).operator)) {
                return false;
            }
            StringConditionInspector otherInspector = (StringConditionInspector)other;
            if (((String)this.getValue()).isEmpty() || ((String)((StringConditionInspector)other).getValue()).isEmpty()) {
                return false;
            }
            if (this.operatorsAre(otherInspector, Operator.LESS_THAN) || this.operatorsAre(otherInspector, Operator.GREATER_THAN) || this.operatorsAre(otherInspector, Operator.LESS_OR_EQUAL) || this.operatorsAre(otherInspector, Operator.GREATER_OR_EQUAL) || this.operatorsAre(otherInspector, Operator.LESS_THAN, Operator.LESS_OR_EQUAL) || this.operatorsAre(otherInspector, Operator.GREATER_THAN, Operator.GREATER_OR_EQUAL)) {
                return true;
            }
            if (((String)this.getValue()).equals(otherInspector.getValue()) && this.operator.equals((Object)otherInspector.getOperator())) {
                return true;
            }
            if (((StringConditionInspector)other).getOperator().equals((Object)Operator.LESS_THAN) || this.operator.equals((Object)Operator.LESS_THAN) || ((StringConditionInspector)other).getOperator().equals((Object)Operator.GREATER_THAN) || this.operator.equals((Object)Operator.GREATER_THAN)) {
                return false;
            }
            if (!otherInspector.hasValue()) {
                return false;
            }
            switch (this.operator) {
                case EQUALS: 
                case MATCHES: 
                case SOUNDSLIKE: 
                case GREATER_OR_EQUAL: 
                case LESS_OR_EQUAL: {
                    switch (otherInspector.getOperator()) {
                        case NOT_EQUALS: {
                            return !otherInspector.containsAll(this.getValues());
                        }
                        case EQUALS: 
                        case MATCHES: 
                        case SOUNDSLIKE: {
                            return otherInspector.containsAll(this.getValues());
                        }
                        case IN: {
                            return otherInspector.valuesContains(this.getValue());
                        }
                        case NOT_IN: {
                            return !otherInspector.valuesContains(this.getValue());
                        }
                    }
                    return super.overlaps(other);
                }
                case NOT_IN: {
                    switch (otherInspector.getOperator()) {
                        case EQUALS: 
                        case MATCHES: 
                        case SOUNDSLIKE: {
                            return !this.valuesContains(otherInspector.getValue());
                        }
                        case IN: {
                            return this.doesNotContainAll(otherInspector.getValues());
                        }
                    }
                    return !otherInspector.containsAll(this.getValues());
                }
                case NOT_EQUALS: {
                    switch (otherInspector.getOperator()) {
                        case IN: {
                            return this.doesNotContainAll(((StringConditionInspector)other).getValues());
                        }
                        case NOT_EQUALS: {
                            return !otherInspector.containsAll(this.getValues());
                        }
                    }
                    return !otherInspector.valuesContains(this.getValue());
                }
                case IN: {
                    switch (otherInspector.getOperator()) {
                        case EQUALS: 
                        case MATCHES: 
                        case SOUNDSLIKE: 
                        case GREATER_OR_EQUAL: 
                        case LESS_OR_EQUAL: {
                            return this.valuesContains(otherInspector.getValue());
                        }
                        case NOT_EQUALS: {
                            return otherInspector.doesNotContainAll(this.getValues());
                        }
                        case NOT_IN: {
                            return this.doesNotContainAll(otherInspector.getValues());
                        }
                        case IN: {
                            return this.containsAny(otherInspector.getValues());
                        }
                    }
                }
            }
        }
        return super.overlaps(other);
    }

    private boolean operatorsAre(StringConditionInspector otherInspector, Operator operator) {
        return this.operator.equals((Object)operator) && otherInspector.getOperator().equals((Object)operator);
    }

    private boolean operatorsAre(StringConditionInspector otherInspector, Operator a, Operator b) {
        return this.operator.equals((Object)a) && otherInspector.getOperator().equals((Object)b) || this.operator.equals((Object)b) && otherInspector.getOperator().equals((Object)a);
    }

    @Override
    public boolean covers(Comparable<String> otherValue) {
        switch (this.operator) {
            case STR_STARTS_WITH: {
                return ((String)this.getValue()).startsWith(otherValue.toString());
            }
            case STR_ENDS_WITH: {
                return ((String)this.getValue()).endsWith(otherValue.toString());
            }
            case MATCHES: 
            case SOUNDSLIKE: {
                return this.valueIsEqualTo(otherValue);
            }
            case CONTAINS: {
                return false;
            }
            case NOT_MATCHES: {
                return !this.valueIsEqualTo(otherValue);
            }
            case IN: {
                return this.valuesContains(otherValue.toString());
            }
            case NOT_IN: {
                return !this.valuesContains(otherValue.toString());
            }
        }
        return super.covers(otherValue);
    }

    @Override
    protected boolean valueIsGreaterThanOrEqualTo(Comparable<String> otherValue) {
        return this.valueIsEqualTo(otherValue);
    }

    @Override
    protected boolean valueIsLessThanOrEqualTo(Comparable<String> otherValue) {
        return this.valueIsEqualTo(otherValue);
    }

    @Override
    protected boolean valueIsGreaterThan(Comparable<String> otherValue) {
        return false;
    }

    @Override
    protected boolean valueIsLessThan(Comparable<String> otherValue) {
        return false;
    }

    @Override
    protected boolean valueIsEqualTo(Comparable<String> otherValue) {
        return this.valuesContains(otherValue.toString());
    }

    private boolean valuesContains(Object value) {
        return this.getValues().contains(value);
    }

    private boolean containsAll(Values<Comparable> otherValues) {
        if (this.getValues().isEmpty() || otherValues.isEmpty()) {
            return false;
        }
        for (Object e : otherValues) {
            if (this.getValues().contains(e)) continue;
            return false;
        }
        return true;
    }

    private boolean doesNotContainAll(Values<Comparable> otherValues) {
        for (Object e : otherValues) {
            if (this.getValues().contains(e)) continue;
            return true;
        }
        return false;
    }

    private boolean containsAny(Values<Comparable> otherValues) {
        for (Object e : this.getValues()) {
            for (Object e2 : otherValues) {
                if (!e.equals(e2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean subsumes(Object other) {
        if (other instanceof StringConditionInspector) {
            if (((StringConditionInspector)other).getOperator().equals((Object)this.operator)) {
                return this.getValues().containsAll(((StringConditionInspector)other).getValues());
            }
            switch (this.operator) {
                case EQUALS: 
                case MATCHES: 
                case SOUNDSLIKE: 
                case GREATER_OR_EQUAL: 
                case LESS_OR_EQUAL: {
                    if (this.operatorsAre((StringConditionInspector)other, Operator.LESS_OR_EQUAL) || this.operatorsAre((StringConditionInspector)other, Operator.GREATER_OR_EQUAL) || this.operatorsAre((StringConditionInspector)other, Operator.LESS_OR_EQUAL, Operator.LESS_THAN) || this.operatorsAre((StringConditionInspector)other, Operator.GREATER_OR_EQUAL, Operator.GREATER_THAN)) {
                        return ((String)this.getValue()).equals(((StringConditionInspector)other).getValue());
                    }
                    switch (((StringConditionInspector)other).getOperator()) {
                        case IN: {
                            return this.getValues().containsAll(((StringConditionInspector)other).getValues());
                        }
                        case EQUALS: 
                        case MATCHES: 
                        case SOUNDSLIKE: {
                            return ((String)this.getValue()).equals(((StringConditionInspector)other).getValue());
                        }
                    }
                    break;
                }
                case IN: {
                    switch (((StringConditionInspector)other).getOperator()) {
                        case EQUALS: 
                        case MATCHES: 
                        case SOUNDSLIKE: {
                            return this.getValues().contains(((StringConditionInspector)other).getValue());
                        }
                    }
                    break;
                }
                case NOT_IN: {
                    switch (((StringConditionInspector)other).getOperator()) {
                        case EQUALS: 
                        case MATCHES: 
                        case SOUNDSLIKE: 
                        case IN: {
                            return !this.containsAll(((StringConditionInspector)other).getValues());
                        }
                        case NOT_EQUALS: {
                            return this.getValues().contains(((StringConditionInspector)other).getValue());
                        }
                    }
                    break;
                }
                case NOT_EQUALS: {
                    switch (((StringConditionInspector)other).getOperator()) {
                        case NOT_IN: {
                            return this.getValues().containsAll(((StringConditionInspector)other).getValues());
                        }
                        case IN: {
                            return !((StringConditionInspector)other).getValues().contains(this.getValue());
                        }
                        case EQUALS: 
                        case MATCHES: 
                        case SOUNDSLIKE: {
                            return !((String)this.getValue()).equals(((StringConditionInspector)other).getValue());
                        }
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean hasValue() {
        return this.getValues() != null && !this.getValues().isEmpty() && this.hasAValueSetInList();
    }

    @Override
    public String toHumanReadableString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.field.getName());
        stringBuilder.append(" ");
        stringBuilder.append((Object)this.operator);
        stringBuilder.append(" ");
        Iterator iterator = this.getValues().iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    private boolean hasAValueSetInList() {
        for (Object e : this.getValues()) {
            if (e == null || ((String)e).trim().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

