/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks;

import com.google.gwt.safehtml.shared.SafeHtml;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.AnalysisConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.PatternInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.RuleInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.inspectors.condition.ConditionsInspectorMultiMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.base.SingleCheck;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.Conflict;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.checks.util.HumanReadable;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.Field;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Explanation;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.ExplanationProvider;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Issue;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.reporting.Severity;

public class DetectImpossibleMatchCheck
extends SingleCheck {
    private Conflict conflict = Conflict.EMPTY;

    public DetectImpossibleMatchCheck(RuleInspector ruleInspector) {
        super(ruleInspector);
    }

    @Override
    public void check() {
        this.hasIssues = false;
        this.conflict = Conflict.EMPTY;
        for (PatternInspector patternInspector : this.ruleInspector.getPatternsInspector()) {
            ConditionsInspectorMultiMap conditionsInspector = patternInspector.getConditionsInspector();
            Conflict conflict = conditionsInspector.hasConflicts();
            if (!conflict.foundIssue()) continue;
            this.hasIssues = true;
            this.conflict = conflict;
        }
    }

    @Override
    public Issue getIssue() {
        Issue issue = new Issue(Severity.ERROR, AnalysisConstants.INSTANCE.ImpossibleMatch(), new ExplanationProvider(){

            @Override
            public SafeHtml toHTML() {
                String fieldName = "";
                String fieldFactType = "";
                if (((Conflict)DetectImpossibleMatchCheck.this.conflict.getOrigin()).getConflictedItem() instanceof ComparableConditionInspector) {
                    Field field = ((ComparableConditionInspector)((Conflict)DetectImpossibleMatchCheck.this.conflict.getOrigin()).getConflictedItem()).getField();
                    fieldName = field.getName();
                    fieldFactType = field.getFactType();
                }
                return new Explanation().startNote().addParagraph(AnalysisConstants.INSTANCE.ImpossibleMatchNote1P1(DetectImpossibleMatchCheck.this.ruleInspector.getRowIndex() + 1, fieldName, fieldFactType)).addParagraph(AnalysisConstants.INSTANCE.ImpossibleMatchNote1P2(HumanReadable.toHumanReadableString(((Conflict)DetectImpossibleMatchCheck.this.conflict.getOrigin()).getConflictedItem()), HumanReadable.toHumanReadableString(((Conflict)DetectImpossibleMatchCheck.this.conflict.getOrigin()).getConflictingItem()))).end().addParagraph(AnalysisConstants.INSTANCE.ImpossibleMatchP1(fieldName)).toHTML();
            }
        }, this.ruleInspector);
        return issue;
    }
}

